<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class NotificationBar extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];
    
    protected $table='notification_bar';

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }


    protected static function boot()
    {
        parent::boot();

        static::deleting(function ($item) {
            if (count($item->langs)) {
                foreach ($item->langs as $lang) {
                    $lang->delete();
                }
            }
        });
    }
}