<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class ProductFeature extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function product()
    {
        return $this->belongsTo('App\Models\Product', 'product_id');
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if (count($item->langs)) {
                foreach ($item->langs as $lang) {
                    $lang->delete();
                }
            }
        });
    }
}
