<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TradingInformation extends Model
{
    protected $table = 'trading_information';

    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $casts = [
        'terms_of_trades' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function nearestPort()
    {
        return $this->belongsTo('App\Models\Country', 'nearest_port');
    }
}