<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Support\Str;

class User extends Authenticatable
{
    use HasFactory, HasRoles, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
     protected $guarded = ['id', 'created_at', 'updated_at'];
   

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    public function services()
    {
        return $this->hasMany(Product::class, 'user_id')
            ->whereHas('c1_service_yes');
    }
    public function scopeTopServiceProviders($query, $limit = 6)
    {
        return $query->withSum(['services as total_views' => function($q) {
            $q->checkStatus();
        }], 'seen')
            ->role('supplier')
            ->where('status', 'active')
            ->orderByDesc('total_views')
            ->take($limit);
    }
    public function setPasswordAttribute($password)
    {
        $this->attributes['password'] = bcrypt($password);
    }
    public function user_info()
    {
        return $this->hasOne('App\Models\UserComplete', 'user_id');
    }
    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','photo');
    }
    public function header_profile()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','header_profile');
    }
    public function gallery()
    {
        return $this->hasMany('App\Models\GalleryCategory', 'user_id')->where('status','active');
    }
    public function certificates()
    {
        return $this->hasMany('App\Models\UserCertificate', 'user_id')->whereNotIN('type_title', ['passport', 'n_cart']);
    }
    public function passport()
    {
        return $this->hasOne('App\Models\UserCertificate', 'user_id')->where('type_title','passport');
    }
    public function n_cart()
    {
        return $this->hasOne('App\Models\UserCertificate', 'user_id')->where('type_title','n_cart');
    }
    public function certificates_other()
    {
        return $this->hasMany('App\Models\UserCertificate', 'user_id')->where('type_id','>',0);
    }
    public function certificates_business_card()
    {
        return $this->hasMany('App\Models\UserCertificate', 'user_id')->where('type_id',0)->where('type_title','business_card');
    }
    public function certificates_business_license()
    {
        return $this->hasMany('App\Models\UserCertificate', 'user_id')->where('type_id',0)->where('type_title','business_license');
    }
    public function addresses()
    {
        return $this->hasMany('App\Models\UserAddress', 'user_id');
    }
     public function user_token()
    {
        return $this->hasOne('App\Models\UserToken', 'user_id');
    }
    public function user_business()
    {
        return $this->belongsToMany('App\Models\Select','user_business_type','user_id','business_type_id');
    }
    public function user_purchasing()
    {
        return $this->belongsTo('App\Models\Select', 'purchasing_frequency_id');
    }
    public function user_volume()
    {
        return $this->belongsTo('App\Models\Select', 'annual_purchase_volume_id');
    }
    public function products()
    {
        return $this->hasMany(Product::class, 'user_id');
    }

    public function products_active()
    {
        return $this->hasMany(Product::class, 'user_id')->checkStatus()->orderByDesc('id');
    }

    public function industry()
    {
        return $this->belongsTo(Industry::class);
    }
    protected static function boot()
    {
        parent::boot();
//        static::saving(function ($item) {
        static::creating(function ($item) {
            $item->u_id = 'sup-' . Str::uuid();
        });
        static::deleting(function ($item) {
            $item->user_business()->detach();
            if($item->photo)
            {
                if(is_file($item->photo->path))
                {
                    File::delete($item->photo->path);
                    delete_directory($item->logo->path);
                }
                $item->photo->delete();
            }
             if(count($item->certificates))
            {
                foreach ($item->certificates as $certificate)
                    $certificate->delete();
            }

        });
    }
}
