<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class UserCertificate extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }
    public function select_type()
    {
        return $this->belongsTo('App\Models\Select', 'type_id');
    }
    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','photo');
    }
    public function get_type_title()
    {
        switch ($this->type_title)
        {
            case 'company_document':
                return 'Company Document';
                break;
            case 'personal_identification':
                return 'Personal Identification';
                break;
            case 'business_card':
                return 'Business Card';
                break;
            case 'business_license':
                return 'Business License';
                break;
            case 'n_cart':
                return 'National ID Card';
                break;
            case 'passport':
                return 'Passport';
                break;
            default:
                return '__';
                break;
        }
    }
    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if($item->photo)
            {
                if(is_file($item->photo->path))
                {
                    File::delete($item->photo->path);
                    delete_directory($item->photo->path);
                }
                $item->photo->delete();
            }
        });
    }
}
