<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lang_sets', function (Blueprint $table) {
            $table->id();
            $table->string('title',200)->nullable();
            $table->string('lang',10)->nullable();
            $table->string('faker',20)->nullable();
            $table->enum('align', ['ltr', 'rtl'])->default('ltr');
            $table->enum('farsi_font', ['yes', 'no'])->default('no');
            $table->integer('sort')->nullable()->default(10);
            $table->enum('status', ['active','pending','default'])->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lang_sets');
    }
};
