<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SiteWordsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $array=[
            ['slug'=>'welcome','word'=>'به ادیب خوش آمدید.'],
            ['slug'=>'home','word'=>'خانه'],
            ['slug'=>'blog','word'=>'وبلاگ'],
            ['slug'=>'about','word'=>'درباره ما'],
            ['slug'=>'contact','word'=>'ما خوشحال میشویم که با شما ارتباط داشته باشیم.'],
            ['slug'=>'articles','word'=>'مقالات'],
            ['slug'=>'social','word'=>'شبکه های اجتماعی'],
            ['slug'=>'quick-access','word'=>'دسترسی سریع'],
            ['slug'=>'follow','word'=>'دنبال کردن'],
            ['slug'=>'more','word'=>'بیشتر'],
            ['slug'=>'our-service','word'=>'خدمات ما'],
            ['slug'=>'recent-blog','word'=>'وبلاگ های اخیر'],
            ['slug'=>'last-blog','word'=>'آخرین اخبار و مقالات'],
            ['slug'=>'address','word'=>'آدرس'],
            ['slug'=>'name','word'=>'نام'],
            ['slug'=>'email','word'=>'ایمیل'],
            ['slug'=>'phone','word'=>'شماره تماس'],
            ['slug'=>'issue','word'=>'موضوع'],
            ['slug'=>'msg-text','word'=>'متن پیام'],
            ['slug'=>'submit-form','word'=>'ارسال فرم'],
            ['slug'=>'news','word'=>'اخبار'],
            ['slug'=>'most-visited','word'=>'بیشترین بازدید'],
            ['slug'=>'keywords','word'=>'کلمات کلیدی'],
            ['slug'=>'msg-err-form','word'=>'خطا در ارسال فرم.'],
            ['slug'=>'msg-success-form','word'=>'فرم با موفقیت ارسال شد.'],
            ['slug'=>'msg-error','word'=>'خطایی رخ داد'],
            ['slug'=>'req-required','word'=>'این فیلد الزامی است'],
            ['slug'=>'req-remote','word'=>'لطفا این بخش را اصلاح کنید.'],
            ['slug'=>'req-email','word'=>'لطفا یک آدرس ایمیل معتبر وارد کنید.'],
            ['slug'=>'req-date','word'=>'لطفا یک تاریخ معتبر وارد کنید.'],
            ['slug'=>'req-url','word'=>'لطفاً یک آدرس وب معتبر وارد کنید.'],
            ['slug'=>'rqq-number','word'=>'لطفا یک شماره معتبر وارد کنید.'],
            ['slug'=>'req-date-iso','word'=>'لطفا یک تاریخ معتبر (ISO) وارد کنید.'],
            ['slug'=>'req-credit-card','word'=>'لطفا یک شماره کارت اعتباری معتبر وارد کنید.'],
            ['slug'=>'req-digits','word'=>'لطفا فقط اعداد را وارد کنید.'],
            ['slug'=>'req-equal-to','word'=>'لطفا مجددا همان مقدار را وارد کنید.'],
            ['slug'=>'req-accept','word'=>'لطفاً مقداری با پسوند معتبر وارد کنید'],
            ['slug'=>'req-min-length','word'=>'لطفا کمتر از کاراکتر وارد نکنید.'],
            ['slug'=>'req-max-length','word'=>'لطفا بیش از کاراکتر وارد نکنید.'],
            ['slug'=>'req-range','word'=>'یک مقدار بین وارد کنید.'],
            ['slug'=>'req-rang-elength','word'=>'لطفاً یک مقدار بین کاراکترها وارد کنید.'],
            ['slug'=>'req-max','word'=>'لطفاً مقداری کمتر یا مساوی وارد کنید'],
            ['slug'=>'req-min','word'=>'لطفاً مقداری بزرگتر یا مساوی وارد کنید'],
            ['slug'=>'rules','word'=>'قوانین'],
            ['slug'=>'terms-conditions','word'=>'قوانین و مقررات'],
            ['slug'=>'faq','word'=>'سوالات متداول'],
            ['slug'=>'successful','word'=>'موفق'],
            ['slug'=>'unsuccessful','word'=>'ناموفق'],
            ['slug'=>'gallery','word'=>'گالری'],
            ['slug'=>'msg-err-date','word'=>'خطایی در تنظیم تاریخ رخ داده.'],
            ['slug'=>'msg-success-register','word'=>'ثبت نام با موفقیت انجام شد.'],
            ['slug'=>'msg-success-form-contact','word'=>'ارسال فرم با موفقیت انجام شد، منتظر تماس همکاران ما باشید.'],
            ['slug'=>'captcha','word'=>'کد امنیتی'],
            ['slug'=>'captcha-err','word'=>'کد امنیتی اشتباه است'],
            ['slug'=>'username','word'=>'نام کاربری'],
            ['slug'=>'password','word'=>'رمز عبور'],
            ['slug'=>'login','word'=>'ورود'],
            ['slug'=>'products-new','word'=>'محصولات جدید'],
            ['slug'=>'product','word'=>'محصول'],
            ['slug'=>'all','word'=>'همه'],
            ['slug'=>'products','word'=>'محصولات'],
            ['slug'=>'category','word'=>'دسته بندی'],
            ['slug'=>'service','word'=>'خدمات'],
            ['slug'=>'index','word'=>'صفحه اصلی']
        ];
        foreach ($array as $arr)
        {
            DB::table('site_words')->insert($arr);
        }
    }
}
