@extends('admin.layouts.app',['tbl'=>true])

@section('content')
  <div class="row mt-5">
    <div class="col-xl-12 col-md-12 col-lg-12">
      <div class="card">
        <div class="card-header  border-0">
          <h4 class="w-100">
            {{$title}}
            @can('permission_cat_create')
            <a href="{{route('admin.permission-cat.create')}}" class="btn btn-primary float-left">{{translateText('افزودن',lang_admin())}}</a>
              @endcan
          </h4>
        </div>

        <div class="card-body">
          <div class="table-responsive">
            <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">
              <thead>
              <tr>
                <th class="border-bottom-0">#</th>
                <th class="border-bottom-0">{{translateText('نام جدول',lang_admin())}}</th>
                <th class="border-bottom-0">{{translateText('سورت',lang_admin())}}</th>
                <th class="border-bottom-0">{{translateText('ابتدای کد دسترسی',lang_admin())}}</th>
                <th class="border-bottom-0">{{translateText('کد دسترسی(نمایش)',lang_admin())}}</th>
                @canany(['permission_cat_edit','permission_cat_delete'])
                  <th class="border-bottom-0">{{translateText('عملیات',lang_admin())}}</th>
                @endcan
              </tr>
              </thead>
              <tbody>
              @foreach($items as $key=>$item)
                <tr>
                  <td>{{$key+1}}</td>
                  <td>{{translateText($item->table_name,lang_admin())}}</td>
                  <td>{{$item->sort_by}}</td>
                  <td>{{$item->access_list_code}}</td>
                  <td>{{$item->access_code}}</td>
                  @canany(['permission_cat_edit','permission_cat_delete'])
                    <td>
                      <div class="d-flex">
                        @can('permission_cat_edit')
                          <a href="{{route('admin.permission-cat.edit',$item->id)}}"
                             class="action-btns1" data-bs-toggle="tooltip" data-bs-html="true"  data-bs-placement="top"
                             title="<b>{{translateText('ویرایش',lang_admin())}}</b>">
                            <i class="fa fa-edit  text-success"></i>
                          </a>
                        @endcan
                        @can('permission_cat_delete')
                          {!! Form::open(['method' => 'DELETE', 'route' => ['admin.permission-cat.destroy', $item->id] ]) !!}
                          <button class="action-btns1" data-bs-toggle="tooltip" data-bs-html="true"
                                  data-bs-placement="top" title="<b>{{translateText('حذف',lang_admin())}}</b>"
                                  onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                            <i class="fa fa-trash text-danger"></i>
                          </button>
                          {!! Form::close() !!}
                        @endcan
                      </div>
                    </td>
                  @endcan
                </tr>
              @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>


@endsection
