@extends('admin.layouts.app',['req'=>true])

@section('content')
  <div class="row mt-5">
    <div class="col-xl-12 col-md-12 col-lg-12">
      <div class="card">
        <div class="card-header  border-0">
          <h4 class="card-title">
            {{$title}}
          </h4>
        </div>
        <div class="card-body">
          {{ Form::model($item,array('route' => array('admin.role.update',$item->id), 'method' => 'PATCH','id'=>'form_req')) }}
          {{Form::hidden('id', $item->id)}}
          {{Form::hidden('user_id', $item->user_id)}}
          <div class="row">
              @if(Auth::user()->HasRole('developer'))
            <div class="col-md-6">
              <div class="form-group">
                {{Form::label('title', translateText('نام سطح درسترسی',lang_admin()).' *')}}
                {{Form::text('title', null, array('class' => 'form-control','required'))}}
              </div>
            </div>
            <div class="col-md-6 d-none">
              <div class="form-group">
                {{Form::label('name', translateText('کد سطح درسترسی',lang_admin()).' *')}}
                {{Form::text('name', null, array('class' => 'form-control d-ltr text-end','required'))}}
              </div>
            </div>
            @endif
            <div class="col-12">
              @foreach($permission_cats as $key1=> $permission_cat)
                @if(Auth::user()->roles->first()->id>1)
                  @can($permission_cat->access_list_code)
                    <div class="permission_cat_box">
                      <h4>{{translateText($permission_cat->table_name,lang_admin())}}</h4>
                      <hr>
                      @if(count($permission_cat->permissions))
                        @foreach($permission_cat->permissions as $permission)
                                <?php
                                $status = false;
                                if (in_array($permission->id, $permission_role)) {
                                    $status = true;
                                }
                                ?>

                          <label class="custom-switch ml-3">

                            {{ Form::checkbox('permission[]', $permission->name, $status) }}

                            <span class="mr-1">  {{translateText($permission->title,lang_admin())}} </span>
                          </label>
                        @endforeach
                      @else
                        {{translateText('فاقد دسترسی',lang_admin())}}
                      @endif
                    </div>
                  @endcan
                @else
                  <div class="permission_cat_box">
                    <h4>{{translateText($permission_cat->table_name,lang_admin())}}</h4>
                    <hr>
                    @if(count($permission_cat->permissions))
                      @foreach($permission_cat->permissions as $permission)
                              <?php
                              $status = false;
                              if (in_array($permission->id, $permission_role)) {
                                  $status = true;
                              }
                              ?>

                        <label class="custom-switch ml-3">

                          {{ Form::checkbox('permission[]', $permission->name, $status) }}

                          <span class="mr-1">  {{translateText($permission->title,lang_admin())}} </span>
                        </label>
                      @endforeach
                    @else
                      {{translateText('فاقد دسترسی',lang_admin())}}
                    @endif
                  </div>
                @endif
              @endforeach

            </div>
            <div class="col-md-12">
              <hr/>
              {{Form::submit(translateText('ویرایش',lang_admin()),array('class'=>'btn btn-primary float-left','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
            </div>
          </div>
          {!! Form::close() !!}
        </div>
      </div>
    </div>
  </div>


@endsection
@push('in_tag_script')

@endpush
