@extends('admin.layouts.app',['tbl'=>true])

@section('content')

  <div class="row mt-5">
    <div class="col-xl-12 col-md-12 col-lg-12">
      <div class="card">
        <div class="card-header  border-0">
          <h4 class="w-100">
            {{$title}}
            @can('role_create')
            <a href="{{route('admin.role.create')}}" class="btn btn-primary float-left">{{translateText('افزودن',lang_admin())}}</a>
            @endcan
          </h4>
        </div>

        <div class="card-body">
          <div class="table-responsive">
            <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">
              <thead>
              <tr>
                <th class="border-bottom-0">#</th>
                <th class="border-bottom-0">{{translateText('نام سطح دسترسی',lang_admin())}}</th>
                <th class="border-bottom-0">{{translateText('کد سطح',lang_admin())}}</th>
                @canany(['role_edit','role_delete'])
                  <th class="border-bottom-0">{{translateText('عملیات',lang_admin())}}</th>
                @endcan
              </tr>
              </thead>
              <tbody>
              @foreach($items as $key=>$item)
                <tr>
                  <td>{{$key+1}}</td>
                  <td>{{$item->title}}</td>
                  <td>{{$item->name}}</td>
                  @canany(['role_edit','role_delete'])
                    <td>
                      <div class="d-flex">
                        @can('role_edit')

                          <a href="{{route('admin.role.edit',$item->id)}}"
                             class="action-btns1" data-toggle="tooltip" data-placement="top" title="{{translateText('ویرایش',lang_admin())}}">
                            <i class="fa fa-edit  text-success"></i>
                          </a>
                        @endcan
                        @can('role_delete')

                          {!! Form::open(['method' => 'DELETE', 'route' => ['admin.role.destroy', $item->id] ]) !!}
                          <button class="action-btns1" data-toggle="tooltip"
                                  data-placement="top" title="{{translateText('حذف',lang_admin())}}"
                                  onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                            <i class="fa fa-trash text-danger"></i>
                          </button>
                          {!! Form::close() !!}
                        @endcan
                      </div>
                    </td>
                  @endcan
                </tr>
              @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>


@endsection
