@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item,array('route' => array('admin.blog.update',$item->id),'id'=>'form_req', 'method' => 'PATCH','files'=>true)) }}
                    {{Form::hidden('id', $item->id)}}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}" id="nav-{{$lang->lang}}-tab" data-toggle="tab" data-target="#nav-{{$lang->lang}}" type="button" role="tab" aria-controls="nav-{{$lang->lang}}" aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}}  {{$lang->align=='ltr'?'ltr_tab':''}}" id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-2">
                                                <div class="form-group rounded-lg shadow p-3 mt-2">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="radio" name="{{$lang->status=='default'?'status':'status_'.$lang->lang}}" id="exampleRadios1" value="pending" {{ read_lang($item,'status',$lang->lang) == 'pending' ? 'checked' : ''}}>
                                                        <label class="form-check-label mr-5" for="exampleRadios1">
                                                            {{translateText('عدم انتشار',lang_admin())}}
                                                        </label>
                                                    </div>
                                                    <div class="form-check mt-2">
                                                        <input class="form-check-input" type="radio" name="{{$lang->status=='default'?'status':'status_'.$lang->lang}}" id="exampleRadios2" value="active" {{ read_lang($item,'status',$lang->lang) == 'active' ? 'checked' : ''}}>
                                                        <label class="form-check-label mr-5" for="exampleRadios2">
                                                            {{translateText('انتشار',lang_admin())}}
                                                        </label>
                                                    </div>
                                                </div>
                                                @error('status')
                                                <span class="mt-1 text-danger"></span>
                                                @enderror
                                            </div>

                                            <div class="col-md-5">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, translateText('عنوان مقاله',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'title':'title_'.$lang->lang,  read_lang($item,'title',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-5">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'author':'author_'.$lang->lang, translateText('نویسنده',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'author':'author_'.$lang->lang, read_lang($item,'author',$lang->lang), array('class' => 'form-control',))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                {{Form::label($lang->status=='default'?'text':'text_'.$lang->lang, translateText('متن مقاله',lang_admin()))}}
                                                <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'text':'text_'.$lang->lang, read_lang($item,'text',$lang->lang), array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                            <div class="col-md-4 d-none">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'meta_title':'meta_title_'.$lang->lang, translateText('عنوان صفحه(سئو)',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'meta_title':'meta_title_'.$lang->lang, read_lang($item,'meta_title',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12 d-none">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'meta_description':'meta_description_'.$lang->lang, translateText('توضیحات سئو',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'meta_description':'meta_description_'.$lang->lang, read_lang($item,'meta_description',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="col-md-6 d-none">
                            <div class="form-group">
                                {{Form::label('category_id', translateText('دسته بندی',lang_admin()).' *')}}
                                {{ Form::select('category_id', array_pluck($categories, 'title', 'id'), null, array('class' => 'form-control select2-show-search custom-select')) }}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('tags', translateText('برچسب ها',lang_admin()).' *')}}
                                {{ Form::select('tags[]', array_pluck($tags, 'title', 'id'), null, array('class' => 'form-control select2-show-search custom-select','multiple','data-placeholder'=>translateText('انتخاب کنید',lang_admin()),'required')) }}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('slug', 'Slug *')}}
                                {{ Form::text('slug', null, array('class' => 'form-control slug_input','data-placeholder'=>'انتخاب کنید','required')) }}
                            </div>
                            <p class="text-danger">_<small>{{translateText('این قسمت برای آدرس صفحه استفاده می شود.',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id="photos">
                                {{Form::label('photo', translateText('تصویر',lang_admin()))}}
                                {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.webp','id' => $item->photo ? $item->photo->id : 0,'data-default-file'=>$item->photo && is_file($item->photo->path)?url($item->photo->path):null))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('بهترین سایز تصویر عرض 300 پیکسل در ارتفاع 280 پیکسل می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP باشد',lang_admin())}}</small></p>
                        </div>

                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('ویرایش',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </div>


@endsection
