@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
    <style>
        .select2-container,
        .select2-results__option {
            direction: ltr;
            text-align: left;
        }

        .select2-selection--multiple {
            height: 38px !important;
        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item,array('route' => array('admin.contact-information.update',$item->id),'id'=>'form_req', 'method' => 'PATCH','files'=>true)) }}
                    {{Form::hidden('id', $item->id)}}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}"
                                            id="nav-{{$lang->lang}}-tab" data-toggle="tab"
                                            data-target="#nav-{{$lang->lang}}" type="button" role="tab"
                                            aria-controls="nav-{{$lang->lang}}"
                                            aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div
                                        class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}"
                                        id="nav-{{$lang->lang}}" role="tabpanel"
                                        aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'contact_person':'contact_person_'.$lang->lang, translateText('شخص تماس',lang_admin()).'*')}}
                                                    {{Form::text($lang->status=='default'?'contact_person':'contact_person_'.$lang->lang,read_lang($item,'contact_person',$lang->lang), array('class' => 'form-control','required'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'job_title':'job_title_'.$lang->lang, translateText('عنوان شغلی',lang_admin()).'*')}}
                                                    {{Form::text($lang->status=='default'?'job_title':'job_title_'.$lang->lang,read_lang($item,'job_title',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'department':'department_'.$lang->lang, translateText('بخش',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'department':'department_'.$lang->lang, read_lang($item,'department',$lang->lang), array('class' => 'form-control','required'))}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <div class="col-md-6">
                            <div class="form-group ">
                                {{Form::label('email_address', translateText('ایمیل',lang_admin()).'*')}}
                                {{Form::text('email_address', $item->email_address, array('class' => 'form-control'))}}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group ">
                                {{Form::label('backup_email', translateText('ایمیل پشتیبان',lang_admin()).'*')}}
                                {{Form::text('backup_email', $item->backup_email, array('class' => 'form-control'))}}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('phone_number', translateText('شماره تلفن', lang_admin()).'*') }}
                                <div class="d-flex">
                                    {{ Form::select('country_code1',
                                        $country_code,
                                        $item->country_code1,
                                        array('class' => 'form-control select2-show-search custom-select me-2')
                                    ) }}
                                    {{ Form::text('city_code', $item->city_code ?? '', ['class' => 'form-control me-2', 'placeholder' => translateText('کد شهر', lang_admin()), 'style' => 'width: 20%;']) }}
                                    {{ Form::text('phone_number', $item->phone_number ?? '', ['class' => 'form-control', 'placeholder' => translateText('شماره', lang_admin()), 'style' => 'width: 60%;']) }}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('phone_number', translateText('شماره موبایل', lang_admin()).'*') }}
                                <div class="d-flex">
                                    {{ Form::select('country_code2',
                                        $country_code,
                                        $item->country_code2,
                                        array('class' => 'form-control select2-show-search custom-select me-2')
                                    ) }}
                                    {{ Form::text('mobile_number', $item->mobile_number ?? '', ['class' => 'form-control', 'placeholder' => translateText('شماره', lang_admin()), 'style' => 'width: 70%;']) }}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('phone_number', translateText('شماره فکس', lang_admin())) }}
                                <div class="d-flex">
                                    {{ Form::select('country_code3',
                                        $country_code,
                                        $item->country_code3,
                                        array('class' => 'form-control select2-show-search custom-select me-2')
                                    ) }}
                                    {{ Form::text('city_code2', $item->city_code2 ?? '', ['class' => 'form-control me-2', 'placeholder' => translateText('کد شهر', lang_admin()), 'style' => 'width: 20%;']) }}
                                    {{ Form::text('fax_number', $item->fax_number ?? '', ['class' => 'form-control', 'placeholder' => translateText('شماره', lang_admin()), 'style' => 'width: 60%;']) }}
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('supported_languages', translateText('زبان های پشتیبانی شده', lang_admin()).'*') }}
                                {{ Form::select('supported_languages[]', $langS, json_decode($item->supported_languages, true), ['class' => 'form-control select2-show-search custom-select', 'multiple']) }}
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                {{ Form::label('social_media', translateText('شبکه های اجتماعی', lang_admin()).'*') }}
                                <div id="social-media-container">
                                    @if($item->social_media)
                                        @foreach(json_decode($item->social_media, true) as $media)
                                            <div class="d-flex mb-2">
                                                {{ Form::select('social_media_type[]', $social_media, $media['type'], ['class' => 'form-control select2-show-search custom-select me-2']) }}
                                                {{ Form::text('social_media[]', $media['value'], ['class' => 'form-control', 'placeholder' => translateText('شماره / آیدی', lang_admin())]) }}
                                                <button type="button" class="btn btn-danger remove-social-media" style="margin-left: 10px;">{{ translateText('حذف', lang_admin()) }}</button>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>
                                <button type="button" id="add-social-media" class="btn btn-primary mt-2">{{ translateText('اضافه کردن شبکه اجتماعی', lang_admin()) }}</button>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                {{ Form::label('country_id', translateText('کشور', lang_admin()).'*') }}
                                {{ Form::select('country_id', $country, $item->country_id, ['class' => 'form-control select2-show-search custom-select', 'id' => 'country-select']) }}
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                {{ Form::label('state_id', translateText('استان', lang_admin()).'*') }}
                                {{ Form::select('state_id', [], $item->state_id, ['class' => 'form-control select2-show-search custom-select', 'id' => 'state-select', 'disabled' => true]) }}
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                {{ Form::label('city_id', translateText('شهر', lang_admin()).'*') }}
                                {{ Form::select('city_id', [], $item->city_id, ['class' => 'form-control select2-show-search custom-select', 'id' => 'city-select', 'disabled' => true]) }}
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group ">
                                {{Form::label('street', translateText('خیابان',lang_admin()).'*')}}
                                {{Form::text('street', $item->street, array('class' => 'form-control'))}}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group ">
                                {{Form::label('post_code', translateText('کده پستی',lang_admin()).'*')}}
                                {{Form::text('post_code', $item->post_code, array('class' => 'form-control'))}}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('time_zone', translateText('منطقه زمانی', lang_admin()).'*') }}
                                {{ Form::select('time_zone', $time_zone, $item->time_zone, ['class' => 'form-control select2-show-search custom-select']) }}
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group" id="profiles">
                                {{Form::label('profile', translateText('پروفایل',lang_admin()))}}
                                {{Form::file('profile', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.png,.webp','id' => $item->profile ? $item->profile->id : 0,'data-default-file'=>$item->profile && is_file($item->profile->path)?url($item->profile->path):null))}}
                            </div>
                            <p class="text-danger">
                                _<small>{{translateText('حداکثر حجم تصویر 2MB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('بهترین سایز تصویر عرض 500 پیکسل در ارتفاع 500 پیکسل می باشد',lang_admin())}}</small>
                            </p>
                            <p class="text-danger">
                                _<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small>
                            </p>
                        </div>
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('ویرایش',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </div>

@endsection
@section('in_tag_script')
    <script>
        const translations = {
            addSocialMedia: "{{ translateText('اضافه کردن شبکه اجتماعی', lang_admin()) }}",
            remove: "{{ translateText('حذف', lang_admin()) }}",
            selectSocialMedia: "{{ translateText('انتخاب شبکه اجتماعی', lang_admin()) }}",
            socialMediaPlaceholder: "{{ translateText('شماره / آیدی', lang_admin()) }}"
        };

        document.addEventListener('DOMContentLoaded', function () {
            const container = document.getElementById('social-media-container');
            const addButton = document.getElementById('add-social-media');

            addButton.addEventListener('click', function () {
                const newRow = document.createElement('div');
                newRow.classList.add('d-flex', 'mb-2');
                newRow.innerHTML = `
            <select name="social_media_type[]" class="form-control select2-show-search custom-select me-2">
                <option value="" disabled selected>${translations.selectSocialMedia}</option>
                @foreach($social_media as $key => $value)
                <option value="{{ $key }}">{{ $value }}</option>
                @endforeach
                </select>
                <input type="text" name="social_media[]" class="form-control" placeholder="${translations.socialMediaPlaceholder}">
            <button type="button" class="btn btn-danger remove-social-media" style="margin-left: 10px;">${translations.remove}</button>
        `;

                container.appendChild(newRow);

                $(newRow).find('.select2-show-search').select2();
            });

            container.addEventListener('click', function (e) {
                if (e.target.classList.contains('remove-social-media')) {
                    e.target.parentElement.remove();
                }
            });
        });

        $(document).ready(function () {
            const countrySelect = $('#country-select');
            const stateSelect = $('#state-select');
            const citySelect = $('#city-select');


            const selectedCountryId = countrySelect.val();
            const selectedStateId = "{{ $item->state_id }}";
            const selectedCityId = "{{ $item->city_id }}";

            if (selectedCountryId) {
                const getStatesUrl = "{{ route('get.states', ':countryId') }}".replace(':countryId', selectedCountryId);
                $.ajax({
                    url: getStatesUrl,
                    type: 'GET',
                    success: function (states) {
                        stateSelect.empty().append('<option value="" disabled selected></option>').prop('disabled', false);
                        $.each(states, function (index, state) {
                            const isSelected = state.id == selectedStateId ? 'selected' : '';
                            stateSelect.append('<option value="' + state.id + '" ' + isSelected + '>' + state.name + '</option>');
                        });

                        // اگر استانی انتخاب‌شده وجود دارد، شهرها را واکشی کنید
                        if (selectedStateId) {
                            const getCityUrl = "{{ route('get.cities', ':stateId') }}".replace(':stateId', selectedStateId);
                            $.ajax({
                                url: getCityUrl,
                                type: 'GET',
                                success: function (cities) {
                                    citySelect.empty().append('<option value="" disabled selected></option>').prop('disabled', false);
                                    $.each(cities, function (index, city) {
                                        const isSelected = city.id == selectedCityId ? 'selected' : '';
                                        citySelect.append('<option value="' + city.id + '" ' + isSelected + '>' + city.name + '</option>');
                                    });
                                },
                                error: function () {
                                    alert('خطا در دریافت شهر‌ها');
                                }
                            });
                        }
                    },
                    error: function () {
                        alert('خطا در دریافت استان‌ها');
                    }
                });
            }

            // واکشی استان‌ها هنگام تغییر کشور
            countrySelect.on('change', function () {
                const countryId = $(this).val();

                stateSelect.empty().append('<option value="" disabled selected></option>').prop('disabled', true);
                citySelect.empty().append('<option value="" disabled selected></option>').prop('disabled', true);

                if (countryId) {
                    const getStatesUrl = "{{ route('get.states', ':countryId') }}".replace(':countryId', countryId);
                    $.ajax({
                        url: getStatesUrl,
                        type: 'GET',
                        success: function (states) {
                            stateSelect.prop('disabled', false);
                            $.each(states, function (index, state) {
                                stateSelect.append('<option value="' + state.id + '">' + state.name + '</option>');
                            });
                        },
                        error: function () {
                            alert('خطا در دریافت استان‌ها');
                        }
                    });
                }
            });

            // واکشی شهر‌ها هنگام تغییر استان
            stateSelect.on('change', function () {
                const stateId = $(this).val();

                citySelect.empty().append('<option value="" disabled selected></option>').prop('disabled', true);
                if (stateId) {
                    const getCityUrl = "{{ route('get.cities', ':stateId') }}".replace(':stateId', stateId);
                    $.ajax({
                        url: getCityUrl,
                        type: 'GET',
                        success: function (cities) {
                            citySelect.prop('disabled', false);
                            $.each(cities, function (index, city) {
                                citySelect.append('<option value="' + city.id + '">' + city.name + '</option>');
                            });
                        },
                        error: function () {
                            alert('خطا در دریافت شهر‌ها');
                        }
                    });
                }
            });
        });
    </script>
@endsection
