@extends('admin.layouts.app',['req'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header border-0">
                    <h4 class="card-title">{{ translateText($title, lang_admin()) }}</h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item, ['route' => ['admin.factory-information.update', $item->id], 'method' => 'PATCH', 'files' => true]) }}

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('factory_location', translateText('موقعیت کارخانه', lang_admin())) }}
                                {{ Form::text('factory_location', $item->factory_location, ['class' => 'form-control', 'required']) }}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('factory_total_area', translateText('مساحت کل کارخانه', lang_admin())) }}
                                {{ Form::text('factory_total_area', $item->factory_total_area, [
                                    'class' => 'form-control',
                                    'placeholder' => 'e.g 2000 m2 ~ 5000 m2',
                                    'required',
                                    'onkeypress' => 'handleFactoryInput(event, this)',
                                    'dir' => 'ltr'
                                ]) }}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('no_production_staff', translateText('تعداد کارکنان تولید', lang_admin())) }}
                                {{ Form::text('no_production_staff', $item->no_production_staff, [
                                    'class' => 'form-control',
                                    'placeholder' => 'e.g 10 ~ 100 People',
                                    'required',
                                    'onkeypress' => 'handlePeopleInput(event, this)',
                                    'dir' => 'ltr'
                                ]) }}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('no_qc_staff', translateText('تعداد کارکنان کنترل کیفیت', lang_admin())) }}
                                {{ Form::text('no_qc_staff', $item->no_qc_staff, [
                                    'class' => 'form-control',
                                    'placeholder' => 'e.g 10 ~ 100 People',
                                    'required',
                                    'onkeypress' => 'handlePeopleInput(event, this)',
                                    'dir' => 'ltr'
                                ]) }}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('no_rd_staff', translateText('تعداد کارکنان تحقیق و توسعه', lang_admin())) }}
                                {{ Form::text('no_rd_staff', $item->no_rd_staff, [
                                    'class' => 'form-control',
                                    'placeholder' => 'e.g 10 ~ 100 People',
                                    'required',
                                    'onkeypress' => 'handlePeopleInput(event, this)',
                                    'dir' => 'ltr'
                                ]) }}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('no_production_lines', translateText('تعداد خطوط تولید', lang_admin())) }}
                                {{ Form::number('no_production_lines', $item->no_production_lines, [
                                    'class' => 'form-control',
                                    'min' => 0,
                                    'required'
                                ]) }}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('annual_output', translateText('خروجی سالانه', lang_admin())) }}
                                {{ Form::text('annual_output', $item->annual_output, [
                                    'class' => 'form-control',
                                    'placeholder' => 'e.g 100000 Units',
                                    'required',
                                    'onkeypress' => 'handleUnitInput(event, this)',
                                    'dir' => 'ltr'
                                ]) }}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('average_lead_time', translateText('میانگین زمان تحویل', lang_admin())) }}
                                {{ Form::text('average_lead_time', $item->average_lead_time, [
                                    'class' => 'form-control',
                                    'placeholder' => 'e.g 10 ~ 15 Days',
                                    'required',
                                    'onkeypress' => 'handleDaysInput(event, this)',
                                    'dir' => 'ltr'
                                ]) }}
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group" id="photos">
                                {{Form::label('video', translateText('ویدئو',lang_admin()))}}
                                {{Form::file('video', array('class' => 'dropify','data-height'=>'180','accept' => '.mp4,.mov','id' => $item->video ? $item->video->id : 0,'data-default-file'=>$item->video && is_file($item->video->path)?url($item->video->path):null))}}
                            </div>
                            <p class="text-danger">
                                _<small>{{translateText('حداکثر حجم تصویر 10MB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('ویدئو مرتبط با محصول',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('فرمت فقط باید MP4,MOV باشد',lang_admin())}}</small></p>

                            @if($item->video && is_file($item->video->path))
                                <p class="text-danger">_<small><a
                                                href="{{url($item->video->path)}}">{{translateText('نمایش ویدئو',lang_admin())}}</a></small>
                                </p>
                                <p class="text-danger">_<small><a
                                                href="{{route('admin.pic.delete',$item->video->id)}}"
                                                onclick="return confirm('{{translateText('برای حذف ویدئو مطمئن هستید؟',lang_admin())}}')">{{translateText('حذف ویدئو',lang_admin())}}</a></small>
                                </p>
                            @endif
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="form-group">
                                    {{Form::label('gallery',translateText('تصاویر',lang_admin()))}}
                                    <div class="input-group mb-5 file-browser">
                                        <input type="text" class="form-control browse-file"
                                               placeholder="{{translateText('تصاویر مربوط به محصول را انتخاب کنید',lang_admin())}}"
                                               readonly>
                                        <label class="input-group-append">
                                            <span class="btn btn-primary">
                                                {{translateText('انتخاب',lang_admin())}}
                                                {{Form::file('gallery[]', array('class' => 'file-browserinput d-none','accept' => '.jpg,.png,.jpeg,.webp','multiple'))}}
                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <p class="text-danger">
                                _<small>{{translateText('حداکثر حجم تصویر 5MB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('حداکثر تعداد تصویر 6 عدد می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('بهترین سایز تصویر عرض 1000 پیکسل در ارتفاع 1000 پیکسل می باشد',lang_admin())}}</small>
                            </p>
                            <p class="text-danger">
                                _<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small>
                            </p>
                            <p class="text-danger">
                                _<small>{{translateText('برای انتخاب چند تصویر دکمه ctrl کیبورد را نگه دارید و چند تصویر را انتخاب کنید',lang_admin())}}</small>
                            </p>
                        </div>
                        
                        @if(count($item->gallery))
                            <div class="col-md-12">
                                <div class="container-fluid">
                                    <div class="row">
                                        @foreach($item->gallery as $photo)
                                            <div class="col-md-3 col-sm-6">
                                                <div class="img_box_photos">
                                                    <img src="{{url($photo->path)}}" alt="{{$item->title}}">
                                                    <a href="{{route('admin.pic.delete',$photo->id)}}"
                                                       onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')"
                                                       class="photo_destroy file_delete" data-toggle="tooltip"
                                                       data-placement="top"
                                                       title="{{translateText('حذف',lang_admin())}}">×</a>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endif

                        <div class="col-md-12">
                            <div class="form-group">
                                {{ Form::label('video_url', translateText('لینک ویدیوی یوتیوب', lang_admin())) }}
                                {{ Form::text('video_url', $item->video_url, ['class' => 'form-control', 'placeholder' => translateText('مثال: https://www.youtube.com/...', lang_admin())]) }}
                            </div>
                        </div>

                        <div class="col-md-12 text-left">
                            <hr>
                            {{ Form::submit(translateText('ویرایش اطلاعات', lang_admin()), ['class' => 'btn btn-primary', 'onclick' => "return confirm('".translateText('آیا مطمئن هستید؟', lang_admin())."')"]) }}
                        </div>
                    </div>

                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>
@endsection
@section('in_tag_script')

    <script>
        // تابع عمومی برای مدیریت فاصله
        function handleSpace(event, input, unit, isRange) {
            if (event.key === ' ') {
                event.preventDefault();
                const cursorPos = input.selectionStart;
                let value = input.value;

                if (isRange) {
                    if (!value.includes(unit) && !value.includes('~')) {
                        // حالت اول: عدد اول + واحد
                        value = value + ' ' + unit;
                    } else if (value.includes(unit) && !value.includes('~')) {
                        // حالت دوم: اضافه کردن ~
                        value = value + ' ~ ';
                    } else if (value.includes('~') && !value.endsWith(' ' + unit)) {
                        // حالت سوم: اضافه کردن واحد به عدد دوم
                        const parts = value.split('~');
                        value = parts[0] + '~ ' + parts[1].trim() + ' ' + unit;
                    }
                } else {
                    // برای فیلدهای غیر رنجی
                    if (!value.includes(unit)) {
                        value = value + ' ' + unit;
                    }
                }

                input.value = value;
                setTimeout(() => {
                    const newCursorPos = cursorPos + (event.key === ' ' ? (value.includes('~') ? 3 : unit.length + 1) : 0);
                    input.setSelectionRange(newCursorPos, newCursorPos);
                }, 0);
            }
        }

        // توابع اختصاصی برای هر نوع فیلد
        function handleFactoryInput(event, input) {
            handleSpace(event, input, 'm2', true);
        }

        function handlePeopleInput(event, input) {
            handleSpace(event, input, 'People', true);
        }

        function handleUnitInput(event, input) {
            handleSpace(event, input, 'Units', false);
        }

        function handleDaysInput(event, input) {
            handleSpace(event, input, 'Days', true);
        }

        // اعتبارسنجی نهایی قبل از ارسال فرم
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.querySelector('form');
            if (form) {
                form.addEventListener('submit', function(e) {
                    // اینجا می‌توانید اعتبارسنجی نهایی را انجام دهید
                    // مثلاً بررسی کنید که همه فیلدها فرمت صحیح دارند
                });
            }
        });
    </script>
@endsection