@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
    <style>
        .select2-container,
        .select2-results__option {
            direction: ltr;
            text-align: left;
        }

        .select2-selection--multiple {
            height: 38px !important;
        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item,array('route' => array('admin.general-information.update',$item->id),'id'=>'form_req', 'method' => 'PATCH','files'=>true)) }}
                    {{Form::hidden('id', $item->id)}}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}"
                                            id="nav-{{$lang->lang}}-tab" data-toggle="tab"
                                            data-target="#nav-{{$lang->lang}}" type="button" role="tab"
                                            aria-controls="nav-{{$lang->lang}}"
                                            aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div
                                        class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}"
                                        id="nav-{{$lang->lang}}" role="tabpanel"
                                        aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'company_name':'company_name_'.$lang->lang, translateText('نام شرکت',lang_admin()).'*')}}
                                                    {{Form::text($lang->status=='default'?'company_name':'company_name_'.$lang->lang,read_lang($item,'company_name',$lang->lang), array('class' => 'form-control','required'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'company_ceo':'company_ceo_'.$lang->lang, translateText('مدیرعامل شرکت',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'company_ceo':'company_ceo_'.$lang->lang,read_lang($item,'company_ceo',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'company_introduction':'company_introduction_'.$lang->lang, translateText('معرفی شرکت',lang_admin()).'*')}}
                                                    {{Form::text($lang->status=='default'?'company_introduction':'company_introduction_'.$lang->lang, read_lang($item,'company_introduction',$lang->lang), array('class' => 'form-control','required'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                {{Form::label($lang->status=='default'?'company_description':'company_description_'.$lang->lang, translateText('توضیحات شرکت',lang_admin()))}}
                                                *
                                                <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'company_description':'company_description_'.$lang->lang, read_lang($item,'company_description',$lang->lang), array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('main_markets', translateText('فروشگاه های اصلی', lang_admin())) }}
                                {{ Form::select('main_markets[]',
                                        $countries,
                                        $item->mainMarkets->pluck('country_id')->all(),
                                        array('class' => 'form-control select2-show-search custom-select', 'multiple')
                                    ) }}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group ">
                                {{Form::label('year_of_established', translateText('تاریخ تاسیس',lang_admin()).'*')}}
                                {{Form::date('year_of_established', $item->year_of_established, array('class' => 'form-control','required'))}}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('number_of_employees', translateText('تعداد کارمندان', lang_admin())) }}
                                {{ Form::select('number_of_employees',
                                        $employeesRange,
                                        $item->number_of_employees,
                                        array('class' => 'form-control select2-show-search custom-select')
                                    ) }}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group ">
                                {{Form::label('website', translateText('وبسایت',lang_admin()))}}
                                {{Form::text('website', $item->website, array('class' => 'form-control'))}}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('accepted_currencies', translateText('ارزهای پذیرفته شده', lang_admin())) }}
                                {{ Form::select('accepted_currencies[]',
                                        $currencies,
                                        $accepted_currencies,
                                        array('class' => 'form-control select2-show-search custom-select', 'multiple')
                                    ) }}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('payment_terms', translateText('شرایط پرداخت', lang_admin())) }}
                                {{ Form::select('payment_terms[]',
                                        $payments,
                                        $payment_terms,
                                        array('class' => 'form-control select2-show-search custom-select', 'multiple')
                                    ) }}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('working_days', translateText('روزهای کاری', lang_admin())) }}
                                {{ Form::select('working_days[]',
                                        $days,
                                        $working_days,
                                        array('class' => 'form-control select2-show-search custom-select', 'multiple')
                                    ) }}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{{translateText('خدمات OEM', lang_admin())}}</label>
                                <div class="radio">
                                    <label>
                                        <input type="radio" name="oem_services"
                                               value="yes" <?php echo (isset($item->oem_services) && $item->oem_services == 'yes') ? 'checked' : ''; ?>>
                                        {{translateText('آره', lang_admin())}}
                                    </label>
                                </div>
                                <div class="radio">
                                    <label>
                                        <input type="radio" name="oem_services"
                                               value="no" <?php echo (isset($item->oem_services) && $item->oem_services == 'no') ? 'checked' : ''; ?>>
                                        {{translateText('نه', lang_admin())}}
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12"></div>
                        <div class="col-md-4">
                            <div class="form-group" id="logos">
                                {{Form::label('logo', translateText('لوگو',lang_admin()))}}
                                {{Form::file('logo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.png,.webp','id' => $item->logo ? $item->logo->id : 0,'data-default-file'=>$item->logo && is_file($item->logo->path)?url($item->logo->path):null))}}
                            </div>
                            <p class="text-danger">
                                _<small>{{translateText('حداکثر حجم تصویر 1MB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('بهترین سایز تصویر عرض 500 پیکسل در ارتفاع 500 پیکسل می باشد',lang_admin())}}</small>
                            </p>
                            <p class="text-danger">
                                _<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG,GIF باشد',lang_admin())}}</small>
                            </p>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group" id="banner1">
                                {{Form::label('banner1', translateText('بنر اول',lang_admin()))}}
                                {{Form::file('banner1', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.png,.webp','id' => $item->banner1 ? $item->banner1->id : 0,'data-default-file'=>$item->banner1 && is_file($item->banner1->path)?url($item->banner1->path):null))}}
                            </div>
                            <p class="text-danger">
                                _<small>{{translateText('حداکثر حجم تصویر 2MB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('بهترین سایز تصویر عرض 1440 پیکسل در ارتفاع 400 پیکسل می باشد',lang_admin())}}</small>
                            </p>
                            <p class="text-danger">
                                _<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG,GIF باشد',lang_admin())}}</small>
                            </p>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group" id="banner2">
                                {{Form::label('banner2', translateText('بنر دوم',lang_admin()))}}
                                {{Form::file('banner2', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.png,.webp','id' => $item->banner2 ? $item->banner2->id : 0,'data-default-file'=>$item->banner2 && is_file($item->banner2->path)?url($item->banner2->path):null))}}
                            </div>
                            <p class="text-danger">
                                _<small>{{translateText('حداکثر حجم تصویر 2MB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('بهترین سایز تصویر عرض 1440 پیکسل در ارتفاع 200 پیکسل می باشد',lang_admin())}}</small>
                            </p>
                            <p class="text-danger">
                                _<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG,GIF باشد',lang_admin())}}</small>
                            </p>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group" id="brochures">
                                {{Form::label('brochure', translateText('بروشور',lang_admin()))}}
                                {{Form::file('brochure', array('class' => 'dropify','data-height'=>'180','accept' => '.pdf,','id' => $item->brochure->first() ? $item->brochure->first()->id : 0,'data-default-file'=>$item->brochure->first() && is_file($item->brochure->first()->path)?url($item->brochure->first()->path):null))}}
                            </div>
                            <p class="text-danger">
                                _<small>{{translateText('حداکثر حجم تصویر 15MB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('فرمت فقط باید PDF باشد',lang_admin())}}</small>
                            </p>
                            @if($item->brochure->first() && is_file($item->brochure->first()->path))
                                <p class="text-danger">_<small><a
                                                href="{{url($item->brochure->first()->path)}}">{{translateText('نمایش بروشور',lang_admin())}}</a></small>
                                </p>
                                <p class="text-danger">_<small><a
                                                href="{{route('admin.pic.delete',$item->brochure->first()->id)}}"
                                                onclick="return confirm('{{translateText('برای حذف بروشور مطمئن هستید؟',lang_admin())}}')">{{translateText('حذف بروشور',lang_admin())}}</a></small>
                                </p>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id="photos">
                                {{Form::label('video', translateText('ویدئو',lang_admin()))}}
                                {{Form::file('video', array('class' => 'dropify','data-height'=>'180','accept' => '.mp4,.mov','id' => $item->video->first() ? $item->video->first()->id : 0,'data-default-file'=>$item->video->first() && is_file($item->video->first()->path)?url($item->video->first()->path):null))}}
                            </div>
                            <p class="text-danger">
                                _<small>{{translateText('حداکثر حجم تصویر 10MB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('ویدئو مرتبط با محصول',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('فرمت فقط باید MP4,MOV باشد',lang_admin())}}</small></p>

                            @if($item->video->first() && is_file($item->video->first()->path))
                                <p class="text-danger">_<small><a
                                                href="{{url($item->video->first()->path)}}">{{translateText('نمایش ویدئو',lang_admin())}}</a></small>
                                </p>
                                <p class="text-danger">_<small><a
                                                href="{{route('admin.pic.delete',$item->video->first()->id)}}"
                                                onclick="return confirm('{{translateText('برای حذف ویدئو مطمئن هستید؟',lang_admin())}}')">{{translateText('حذف ویدئو',lang_admin())}}</a></small>
                                </p>
                            @endif
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="form-group">
                                    {{Form::label('gallery',translateText('تصاویر',lang_admin()))}}
                                    <div class="input-group mb-5 file-browser">
                                        <input type="text" class="form-control browse-file"
                                               placeholder="{{translateText('تصاویر مربوط به محصول را انتخاب کنید',lang_admin())}}"
                                               readonly>
                                        <label class="input-group-append">
                                            <span class="btn btn-primary">
                                                {{translateText('انتخاب',lang_admin())}}
                                                {{Form::file('gallery[]', array('class' => 'file-browserinput d-none','accept' => '.jpg,.png,.jpeg,.webp','multiple'))}}
                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <p class="text-danger">
                                _<small>{{translateText('حداکثر حجم تصویر 5MB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('حداکثر تعداد تصویر 6 عدد می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('بهترین سایز تصویر عرض 1000 پیکسل در ارتفاع 1000 پیکسل می باشد',lang_admin())}}</small>
                            </p>
                            <p class="text-danger">
                                _<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small>
                            </p>
                            <p class="text-danger">
                                _<small>{{translateText('برای انتخاب چند تصویر دکمه ctrl کیبورد را نگه دارید و چند تصویر را انتخاب کنید',lang_admin())}}</small>
                            </p>
                        </div>
                        @if(count($item->gallery))
                            <div class="col-md-12">
                                <div class="container-fluid">
                                    <div class="row">
                                        @foreach($item->gallery as $photo)
                                            <div class="col-md-3 col-sm-6">
                                                <div class="img_box_photos">
                                                    <img src="{{url($photo->path)}}" alt="{{$item->title}}">
                                                    <a href="{{route('admin.pic.delete',$photo->id)}}"
                                                       onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')"
                                                       class="photo_destroy file_delete" data-toggle="tooltip"
                                                       data-placement="top"
                                                       title="{{translateText('حذف',lang_admin())}}">×</a>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endif
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('ویرایش',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </div>

@endsection
@section('in_tag_script')
    <script>

    </script>
@endsection
