@extends('admin.layouts.app',['tbl'=>true])

@section('content')
    <style>
        .box-sh {
            box-shadow: 0 0 2px 0 #666;
            border-radius: 10px;
            padding: 15px 15px;

        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                        <button type="button" class="btn btn-primary float-left" data-toggle="modal"
                                data-target="#addBranchModal">
                            {{ translateText('افزودن شعبه جدید', lang_admin()) }}
                        </button>
                        <div class="modal fade" id="addBranchModal" tabindex="-1" role="dialog">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">{{ translateText('افزودن شعبه جدید', lang_admin()) }}</h5>
                                    </div>
                                    {{ Form::open([
                                        'route' => 'admin.office-information.store',
                                        'method' => 'POST',
                                        'id' => 'add-branch-form'
                                    ]) }}
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{ Form::label('country_id', translateText('کشور', lang_admin()).'*') }}
                                                    {{ Form::select('country_id', $country, null, ['class' => 'form-control select2-show-search custom-select', 'id' => 'country-select']) }}
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{ Form::label('state_id', translateText('استان', lang_admin()).'*') }}
                                                    {{ Form::select('state_id', [], null, ['class' => 'form-control select2-show-search custom-select', 'id' => 'state-select', 'disabled' => true]) }}
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{ Form::label('city_id', translateText('شهر', lang_admin()).'*') }}
                                                    {{ Form::select('city_id', [], null, ['class' => 'form-control select2-show-search custom-select', 'id' => 'city-select', 'disabled' => true]) }}
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{ Form::label('street', translateText('خیابان', lang_admin()).'*') }}
                                                    {{ Form::text('street', null, [
                                                        'class' => 'form-control'
                                                    ]) }}
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{ Form::label('zip_code', translateText('کد پستی', lang_admin()).'*') }}
                                                    {{ Form::text('zip_code', null, [
                                                        'class' => 'form-control'
                                                    ]) }}
                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{ Form::label('time_zone', translateText('منطقه زمانی', lang_admin()).'*') }}
                                                    {{ Form::select('time_zone', $time_zone, null, [
                                                        'class' => 'form-control select2-show-search custom-select'
                                                    ]) }}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit"
                                                class="btn btn-primary">{{ translateText('ذخیره', lang_admin()) }}</button>
                                        <button type="button" class="btn btn-secondary"
                                                data-dismiss="modal">{{ translateText('انصراف', lang_admin()) }}</button>
                                    </div>
                                    {{ Form::close() }}
                                </div>
                            </div>
                        </div>
                    </h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-wrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0">{{translateText('کشور',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('استان',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('شهر',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('نوع',lang_admin())}}</th>
                                @canany(['company_edit','company_delete'])
                                    <th class="border-bottom-0">{{translateText('عملیات',lang_admin())}}</th>
                                @endcan
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td dir="ltr">{{$key+1 < 10 ? "0".$key+1 : $key+1}}</td>
                                    <td>{{$item->country->name ?? '---'}}</td>
                                    <td>{{$item->state->name ?? '---'}}</td>
                                    <td>{{$item->city->name ?? '---'}}</td>
                                    <td>{{$item->type}}</td>
                                    @canany(['company_edit','company_delete'])
                                        <td>
                                            <div class="d-flex">
                                                @can('company_edit')
                                                    <a href="{{route('admin.office-information.edit',$item->id)}}"
                                                       class="action-btns1">
                                                        <i class="feather feather-edit-2  text-success"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="{{translateText('ویرایش',lang_admin())}}"></i>
                                                    </a>
                                                @endcan
                                                @can('company_delete')
                                                    {!! Form::open(['method' => 'DELETE', 'route' => ['admin.office-information.destroy', $item->id] ]) !!}
                                                    <button class="action-btns1" data-toggle="tooltip"
                                                            data-placement="top"
                                                            title="{{translateText('حذف',lang_admin())}}"
                                                            onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                                                        <i class="feather feather-trash-2 text-danger"></i>
                                                    </button>
                                                    {!! Form::close() !!}
                                                @endcan
                                            </div>
                                        </td>
                                    @endcan
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
@section('in_tag_script')
    <script>
        $(document).ready(function () {
            $('#addBranchModal').on('shown.bs.modal', function () {
                $('#country-select').select2({
                    dropdownParent: $('#addBranchModal')
                });

                $('#state-select').select2({
                    dropdownParent: $('#addBranchModal')
                });

                $('#city-select').select2({
                    dropdownParent: $('#addBranchModal')
                });
            });
        });
        $(document).ready(function () {
            const countrySelect = $('#country-select');
            const stateSelect = $('#state-select');
            const citySelect = $('#city-select');

            countrySelect.on('change', function () {
                const countryId = $(this).val();

                stateSelect.empty().append('<option value="" disabled selected></option>').prop('disabled', true);
                citySelect.empty().append('<option value="" disabled selected></option>').prop('disabled', true);

                if (countryId) {
                    const getStatesUrl = "{{ route('get.states', ':countryId') }}".replace(':countryId', countryId);
                    $.ajax({
                        url: getStatesUrl,
                        type: 'GET',
                        success: function (states) {
                            stateSelect.prop('disabled', false);
                            $.each(states, function (index, state) {
                                stateSelect.append('<option value="' + state.id + '">' + state.name + '</option>');
                            });
                        },
                        error: function () {
                            alert('خطا در دریافت استان‌ها');
                        }
                    });
                }
            });

            stateSelect.on('change', function () {
                const stateId = $(this).val();

                citySelect.empty().append('<option value="" disabled selected></option>').prop('disabled', true);
                if (stateId) {
                    const getCityUrl = "{{ route('get.cities', ':stateId') }}".replace(':stateId', stateId);
                    $.ajax({
                        url: getCityUrl,
                        type: 'GET',
                        success: function (cities) {
                            citySelect.prop('disabled', false);
                            $.each(cities, function (index, city) {
                                citySelect.append('<option value="' + city.id + '">' + city.name + '</option>');
                            });
                        },
                        error: function () {
                            alert('خطا در دریافت شهر‌ها');
                        }
                    });
                }
            });
        });
    </script>
@endsection