@extends('admin.layouts.app', ['req' => true, 'editor' => true, 'file_upload' => true])
@section('content')
    <div class="container-fluid py-4">
        <div class="row justify-content-center">
            <div class="col-lg-10 col-md-12">
                <div class="card shadow-sm border-0 rounded-3">
                    <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center py-3">
                        <h3 class="card-title mb-0">{{$title}}</h3>
                        <a href="{{ $item->story ? route('admin.feedback.story.index') : route('admin.feedback.video.index') }}"
                           class="btn btn-light btn-sm">
                            <i class="bi bi-arrow-right me-2"></i>{{translateText('بازگشت',lang_admin())}}
                        </a>
                    </div>
                    <div class="card-body p-4">
                        <div class="row g-4">
                            <div class="col-md-12">
                                <form action="{{ route('admin.feedback.update', ['id' => $item->id]) }}" method="POST">
                                    @csrf
                                    <div class="form-group bg-light p-3 rounded">
                                        <div class="form-group">
                                            {{Form::label('status', translateText('وضعیت',lang_admin()))}}
                                            {{ Form::select('status', ['pending'=>translateText('عدم انتشار',lang_admin()),'active'=>translateText('انتشار',lang_admin())], $item->status, array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید',)) }}
                                        </div>
                                        <button class="btn btn-primary">{{translateText('اعمال',lang_admin())}}</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('نام',lang_admin())}}
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->full_name }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('ایمیل',lang_admin())}}
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->email }}</p>
                                </div>
                            </div>
                        </div>
                        @if($item->story)
                            <div class="row g-4">
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('نام شرکت',lang_admin())}}
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->company_name }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('لوگو',lang_admin())}}
                                    </label>
                                    <img width="100px" src="{{url($item->photo->path)}}">
                                </div>
                            </div>
                        </div>
                        @endif
                        <div class="row g-4">
                            <div class="col-md-12">
                                @if($item->story)
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i></label>
                                    <p class="mb-0 text-primary">{{ $item->story }}</p>
                                </div>
                                @else
                                    <iframe src="{{url($item->video->path)}}"
                                            title="{{$item->full_name}}"
                                            frameborder="0"
                                            allowfullscreen></iframe>
                                @endif
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection