@extends('admin.layouts.app',['tbl'=>true])

@section('content')
    <style>
        .box-sh
        {
            box-shadow: 0 0 2px 0 #666;
            border-radius: 10px;
            padding: 15px 15px;

        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-wrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0">{{translateText('نام کاربری / ایمیل',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('سرویس',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('سرویس فرعی',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('وضعیت',lang_admin())}}</th>
                                @can('required_service_show')
                                    <th class="border-bottom-0">{{translateText('عملیات',lang_admin())}}</th>
                                @endcan
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td dir="ltr">{{$key+1 < 10 ? "0".$key+1 : $key+1}}</td>
                                    <td>{{$item->user->username}}</td>
                                    <td>{{$item->service}}</td>
                                    <td>{{$item->sub_service}}</td>
                                    <td>
                                        <i class="feather  {{$item->seen == 'no' ? 'feather-circle text-danger' : 'feather-check-circle text-success'}} "></i>
                                        {{$item->seen == 'no' ? 'مشاهده نشده' : 'مشاهده شده'}}
                                    </td>
                                    @can('required_service_show')
                                        <td>
                                            <div class="d-flex">
                                                @can('required_service_show')
                                                    <a href="{{route('admin.required-service.show',$item->id)}}"
                                                       class="action-btns1">
                                                        <i class="feather feather-eye  text-primary"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="مشاهده"></i>
                                                    </a>
                                                @endcan
                                            </div>
                                        </td>
                                    @endcan
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
