@extends('admin.layouts.app', ['req' => true, 'editor' => true, 'file_upload' => true])
@section('content')
    <div class="container-fluid py-4">
        <div class="row justify-content-center">
            <div class="col-lg-10 col-md-12">
                <div class="card shadow-sm border-0 rounded-3">
                    <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center py-3">
                        <h3 class="card-title mb-0">{{$title}}</h3>
                        <a href="{{  route('admin.required-service.index')}}"
                           class="btn btn-light btn-sm">
                            <i class="bi bi-arrow-right me-2"></i>{{translateText('بازگشت',lang_admin())}}
                        </a>
                    </div>
                    <div class="card-body p-4">
                        <div class="row g-4">
                            <div class="col-md-9">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('نام کاربری / ایمیل',lang_admin())}}
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->user->username }}</p>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('تامین کننده مورد تایید :',lang_admin())}}
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->verified_providers ? 'باشد' : 'نباشد' }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('سرویس',lang_admin())}}
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->service }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('سرویس فرعی',lang_admin())}}
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->sub_service }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('کلمات کلیدی',lang_admin())}}
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->keyword }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('توضیحات',lang_admin())}}
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->description }}</p>
                                </div>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection