@extends('admin.layouts.app',['tbl'=>true])

@section('content')
    <style>
        table * {
            /*font-size: 13px;*/
        }

        table.dataTable tbody td, table.dataTable thead td {
            padding: 6px !important;
        }

        table.dataTable tbody th, table.dataTable thead th {
            padding: 10px 6px !important;
            /*font-size: 13px!important;*/
        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                        @can('landing_create')
                            @if(blank($l_id))
                                <a href="{{route('admin.land.create')}}" class="btn btn-primary float-left">{{translateText('افزودن',lang_admin())}}</a>
                            @else
                                <a href="{{route('admin.land.create',['l_id'=>$l_id])}}"
                                   class="btn btn-primary float-left">{{translateText('افزودن',lang_admin())}}</a>
                            @endif
                        @endcan
                    </h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0 col-md-9">{{translateText('عنوان',lang_admin())}}</th>
                                @if(blank($l_id))
                                <th class="border-bottom-0 col-md-9">{{translateText('لینک',lang_admin())}}</th>
                                @else
                                    <th class="border-bottom-0 col-md-9">{{translateText('سایز و مکان',lang_admin())}}</th>
                                @endif
                                <th class="border-bottom-0 col-md-9">{{translateText('زمان ثبت',lang_admin())}}</th>
                                @if(blank($l_id))
                                    <th class="border-bottom-0">{{translateText('عملیات',lang_admin())}}</th>
                                @else
                                    @canany(['landing_edit','landing_delete'])
                                        <th class="border-bottom-0">عملیات</th>
                                    @endcan
                                @endif
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>
                                        {{$item->title}}
                                        @if(blank($l_id))
                                        <span class="badge badge-info">{{$item->footer}}</span>
                                            @endif
                                    </td>
                                    @if(blank($l_id))
                                    <td>
                                        <p class="mb-0">
                                        <a href="{{blank($item->link) ? route('front.landing',$item->slug) : $item->link}}" target="_blank">
                                            {{translateText('مشاهده صفحه',lang_admin())}}
                                        </a>
                                        </p>
                                    </td>
                                    @else
                                        <td>
                                            {{$item->width}}%
                                            <br/>
                                            {{$item->v_h == 'v' ? 'Vertical' : 'Horizontal'}}
                                        </td>
                                    @endif
                                    <td>
                                        {{$item->created_at}}
                                    </td>
                                    @if(blank($l_id))
                                            <td>
                                                <div class="d-flex">
                                                    @if(blank($item->link))
                                                    <a href="{{route('admin.land.index',['l_id'=>$item->id])}}"
                                                       class="action-btns1">
                                                        <i class="feather feather-eye  text-primary"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="{{translateText('جزئیات',lang_admin())}}"></i>
                                                    </a>
                                                    @endif
                                                    @can('landing_edit')
                                                        <a href="{{route('admin.land.edit',[$item->id,blank($l_id)?'':'l_id'=>$l_id])}}"
                                                           class="action-btns1">
                                                            <i class="feather feather-edit-2  text-success"
                                                               data-toggle="tooltip" data-placement="top"
                                                               title="{{translateText('ویرایش',lang_admin())}}"></i>
                                                        </a>
                                                    @endcan
                                                        @if(blank($item->link))
                                                    @can('landing_delete')
                                                        {!! Form::open(['method' => 'DELETE', 'route' => ['admin.land.destroy', [$item->id,blank($l_id)?'':'l_id'=>$l_id]] ]) !!}
                                                        <button class="action-btns1" data-toggle="tooltip"
                                                                data-placement="top" title="{{translateText('حذف',lang_admin())}}"
                                                                onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                                                            <i class="feather feather-trash-2 text-danger"></i>
                                                        </button>
                                                        {!! Form::close() !!}
                                                    @endcan
                                                        @endif
                                                </div>
                                            </td>
                                    @else
                                        @canany(['landing_edit','landing_delete'])
                                            <td>
                                                <div class="d-flex">
                                                    @can('landing_edit')
                                                        <a href="{{route('admin.land.edit',[$item->id,blank($l_id)?'':'l_id'=>$l_id])}}"
                                                           class="action-btns1">
                                                            <i class="feather feather-edit-2  text-success"
                                                               data-toggle="tooltip" data-placement="top"
                                                               title="{{translateText('ویرایش',lang_admin())}}"></i>
                                                        </a>
                                                    @endcan
                                                    @can('landing_delete')
                                                        {!! Form::open(['method' => 'DELETE', 'route' => ['admin.land.destroy', [$item->id,blank($l_id)?'':'l_id'=>$l_id]] ]) !!}
                                                        <button class="action-btns1" data-toggle="tooltip"
                                                                data-placement="top" title="{{translateText('حذف',lang_admin())}}"
                                                                onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                                                            <i class="feather feather-trash-2 text-danger"></i>
                                                        </button>
                                                        {!! Form::close() !!}
                                                    @endcan
                                                </div>
                                            </td>
                                        @endcan
                                    @endif
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
