@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])
@section('styles')
    <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css"/>
    <link rel="stylesheet" href="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.css"/>
    <style>
        #locateBtn {
            position: absolute;
            top: 11px;
            left: 60px;
            z-index: 999;
        }
    </style>
@endsection
@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item,array('route' => array('admin.sourcing-magazine.update',$item->id),'id'=>'form_req', 'method' => 'PATCH','files'=>true)) }}
                    {{Form::hidden('id', $item->id)}}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}"
                                            id="nav-{{$lang->lang}}-tab" data-toggle="tab"
                                            data-target="#nav-{{$lang->lang}}" type="button" role="tab"
                                            aria-controls="nav-{{$lang->lang}}"
                                            aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}"
                                     id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'status':'status_'.$lang->lang, translateText('وضعیت',lang_admin()).' *')}}
                                                    {{ Form::select($lang->status=='default'?'status':'status_'.$lang->lang, ['pending'=>translateText('عدم انتشار',lang_admin()),'active'=>translateText('انتشار',lang_admin())], read_lang($item,'status',$lang->lang), array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید',)) }}
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, translateText('عنوان',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'title':'title_'.$lang->lang,read_lang($item,'title',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'issue_date':'issue_date_'.$lang->lang, 'Issue Date')}}
                                                    {{Form::text($lang->status=='default'?'issue_date':'issue_date_'.$lang->lang,read_lang($item,'issue_date',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'text':'text_'.$lang->lang, translateText('توضیحات',lang_admin()))}}
                                                    {{Form::textarea($lang->status=='default'?'text':'text_'.$lang->lang,read_lang($item,'text',$lang->lang), array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'includes':'includes_'.$lang->lang, translateText('Each issue includes',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'includes':'includes_'.$lang->lang, read_lang($item,'includes',$lang->lang), array('class' => 'form-control d-ltr text-left contact_multi'))}}
                                                </div>
                                                <p class="text-danger">
                                                    _<small>{{translateText('درصورت داشتن چند شماره فکس میتوانید با زدن "Add" به تعداد شماره را وارد کنید',lang_admin())}}</small>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                {{Form::label('cat_id', translateText('دسته بندی',lang_admin()).' *')}}
                                {{ Form::select('cat_id', array_pluck($cats, 'title', 'id',['',translateText('انتخاب کنید',lang_admin())]), null, array('class' => 'form-control select2-show-search select_prefix custom-select','data-placeholder'=>translateText('انتخاب کنید',lang_admin()),'required')) }}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id="photos">
                                {{Form::label('photo', translateText('تصویر',lang_admin()))}}
                                {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.webp,.png','id' => $item->photo ? $item->photo->id : 0,'data-default-file'=>$item->photo && is_file($item->photo->path)?url($item->photo->path):null))}}
                            </div>
                            <p class="text-danger">
                                _<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('فرمت فقط باید jPG,WEBP,PNG باشد',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id="photos">
                                {{Form::label('pdf','PDF')}}
                                {{Form::file('pdf', array('class' => 'dropify','data-height'=>'180','accept' => '.pdf','id' => $item->pdf ? $item->pdf->id : 0,'data-default-file'=>$item->pdf && is_file($item->pdf->path)?url($item->pdf->path):null))}}
                            </div>
                            <p class="text-danger">
                                _<small>{{translateText('حداکثر حجم 50MB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('فرمت فقط باید PDF باشد',lang_admin())}}</small></p>
                            @if($item->pdf && is_file($item->pdf->path))
                                <p class="text-danger">_<small><a
                                                href="{{url($item->pdf->path)}}" target="_blank">{{translateText('نمایش',lang_admin())}} pdf</a></small>
                                </p>
{{--                                <p class="text-danger">_<small><a href="{{route('admin.pic.delete',$item->pdf->id)}}"--}}
{{--                                                                  onclick="return confirm('{{translateText('برای حذف pdf مطمئن هستید؟',lang_admin())}}')">{{translateText('حذف pdf',lang_admin())}}</a></small>--}}
{{--                                </p>--}}
                            @endif
                        </div>

                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('ویرایش',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </div>

@endsection
@section('in_tag_script')

@endsection