@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])
@section('styles')
    <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css"/>
    <link rel="stylesheet" href="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.css"/>
    <style>
        #locateBtn {
            position: absolute;
            top: 11px;
            left: 60px;
            z-index: 999;
        }
    </style>
@endsection
@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item,array('route' => array('admin.transport.update',$item->id),'id'=>'form_req', 'method' => 'PATCH','files'=>true)) }}
                    {{Form::hidden('id', $item->id)}}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}"
                                            id="nav-{{$lang->lang}}-tab" data-toggle="tab"
                                            data-target="#nav-{{$lang->lang}}" type="button" role="tab"
                                            aria-controls="nav-{{$lang->lang}}"
                                            aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}"
                                     id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'status':'status_'.$lang->lang, translateText('وضعیت',lang_admin()).' *')}}
                                                    {{ Form::select($lang->status=='default'?'status':'status_'.$lang->lang, ['pending'=>translateText('عدم انتشار',lang_admin()),'active'=>translateText('انتشار',lang_admin())], read_lang($item,'status',$lang->lang), array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید',)) }}
                                                </div>
                                            </div>
                                            <div class="col-md-8">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, translateText('نام شرکت',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'title':'title_'.$lang->lang,read_lang($item,'title',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'about':'about_'.$lang->lang, translateText('درباره شرکت',lang_admin()))}}
                                                    {{Form::textarea($lang->status=='default'?'about':'about_'.$lang->lang,read_lang($item,'about',$lang->lang), array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'service':'service_'.$lang->lang, translateText('خدمات',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'service':'service_'.$lang->lang, read_lang($item,'service',$lang->lang), array('class' => 'form-control d-ltr text-left contact_multi'))}}
                                                </div>
                                                <p class="text-danger">
                                                    _<small>{{translateText('درصورت داشتن چند شماره فکس میتوانید با زدن "Add" به تعداد شماره را وارد کنید',lang_admin())}}</small>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{Form::label('type', translateText('نوع',lang_admin()).' *')}}
                                {{ Form::select('type', ['multimodal_transports'=>translateText('Multimodal Transports',lang_admin()),'sea_transportation'=>translateText('Sea transportation',lang_admin()),'air_freight'=>translateText('Air Freight',lang_admin()),'land_freight'=>translateText('Land Freight',lang_admin()),'freight_agents'=>translateText('Freight Agents',lang_admin()),'customs_clearance_services'=>translateText('Customs Clearance Services',lang_admin())], null, array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید',)) }}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id="photos">
                                {{Form::label('video', translateText('ویدئو',lang_admin()))}}
                                {{Form::file('video', array('class' => 'dropify','data-height'=>'180','accept' => '.mp4,.mov','id' => $item->video ? $item->video->id : 0,'data-default-file'=>$item->video && is_file($item->video->path)?url($item->video->path):null))}}
                            </div>
                            <p class="text-danger">
                                _<small>{{translateText('حداکثر حجم 50MB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('فرمت فقط باید MP4,MOV باشد',lang_admin())}}</small></p>
                            @if($item->video && is_file($item->video->path))
                                <p class="text-danger">_<small><a
                                                href="{{url($item->video->path)}}" target="_blank">{{translateText('نمایش ویدئو',lang_admin())}}</a></small>
                                </p>
                                <p class="text-danger">_<small><a href="{{route('admin.pic.delete',$item->video->id)}}"
                                                                  onclick="return confirm('{{translateText('برای حذف ویدئو مطمئن هستید؟',lang_admin())}}')">{{translateText('حذف ویدئو',lang_admin())}}</a></small>
                                </p>
                            @endif
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="form-group">
                                    {{Form::label('photos',translateText('تصاویر',lang_admin()))}}
                                    <div class="input-group mb-5 file-browser">
                                        <input type="text" class="form-control browse-file"
                                               placeholder="{{translateText('تصاویر مربوط به محصول را انتخاب کنید',lang_admin())}}"
                                               readonly>
                                        <label class="input-group-append">
                                            <span class="btn btn-primary">
                                                {{translateText('انتخاب',lang_admin())}}
                                                {{Form::file('photos[]', array('class' => 'file-browserinput d-none','accept' => '.jpg,.png,.jpeg,.webp','multiple'))}}
                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <p class="text-danger">
                                _<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small>
                            </p>
                            <p class="text-danger">
                                _<small>{{translateText('برای انتخاب چند تصویر دکمه ctrl کیبورد را نگه دارید و چند تصویر را انتخاب کنید',lang_admin())}}</small>
                            </p>
                        </div>
                        @if(count($item->photos))
                            <div class="col-md-12">
                                <div class="container-fluid">
                                    <div class="row">
                                        @foreach($item->photos as $photo)
                                            <div class="col-md-3 col-sm-6">
                                                <div class="img_box_photos">
                                                    <img src="{{url($photo->path)}}" alt="{{$item->title}}">
                                                    <a href="{{route('admin.pic.delete',$photo->id)}}"
                                                       onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')"
                                                       class="photo_destroy file_delete" data-toggle="tooltip"
                                                       data-placement="top"
                                                       title="{{translateText('حذف',lang_admin())}}">×</a>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endif


                        <div class="col-lg-12 position-relative">
                            <button type="button" id="locateBtn" class="btn btn-dark">My Location</button>
                            <div id="map" style="height: 300px;width: 100%"></div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('latitude', 'latitude')}}
                                {{Form::text('latitude', null, array('class' => 'form-control text-center','dir'=>'ltr','readonly'))}}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('longitude', 'longitude')}}
                                {{Form::text('longitude', null, array('class' => 'form-control text-center','dir'=>'ltr','readonly'))}}
                            </div>
                        </div>
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('ویرایش',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </div>

@endsection
@section('in_tag_script')
    <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
    <script src="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.js"></script>
    <script>
        var lat = parseFloat({{(float)$item->latitude > 0 && (float)$item->longitude > 0 ? $item->latitude : 37.095 }});
        var lng = parseFloat({{(float)$item->latitude > 0 && (float)$item->longitude > 0 ? $item->longitude : 42.348 }});
        var map = L.map('map').setView([lat, lng], 7);

        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
        }).addTo(map);
        @if((float)$item->latitude > 0 && (float)$item->longitude > 0)
        var marker = L.marker([lat, lng]).addTo(map);
        @else
        var marker
        @endif

        // افزودن باکس جستجو به نقشه
        var geocoder = L.Control.Geocoder.nominatim();
        var control = L.Control.geocoder({
            geocoder: geocoder
        }).addTo(map);

        control.on('markgeocode', function (e) {
            var lat = e.geocode.center.lat;
            var lng = e.geocode.center.lng;

            // حذف مارکر قدیمی اگر وجود داشت
            if (marker) {
                map.removeLayer(marker);
            }


            // افزودن مارکر جدید به نقطه جستجو شده
            marker = L.marker([lat, lng]).addTo(map);
            map.setView([lat, lng], 7); // زوم به نقطه جستجو شده


            // قرار دادن مختصات در inputها
            document.getElementById('latitude').value = lat;
            document.getElementById('longitude').value = lng;
        });
        // رویداد کلیک روی نقشه
        map.on('click', function (e) {
            var lat = e.latlng.lat;
            var lng = e.latlng.lng;

            // حذف مارکر قدیمی اگر وجود داشت
            if (marker) {
                map.removeLayer(marker);
            }

            // افزودن مارکر جدید به نقطه کلیک شده
            marker = L.marker([lat, lng]).addTo(map);

            // قرار دادن مختصات در inputها
            document.getElementById('latitude').value = lat;
            document.getElementById('longitude').value = lng;
        });

        // رویداد کلیک روی دکمه "مکان‌یابی من"
        document.getElementById('locateBtn').addEventListener('click', function () {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function (position) {
                    var lat = position.coords.latitude;
                    var lng = position.coords.longitude;

                    // حذف مارکر قبلی اگر وجود دارد
                    if (marker) {
                        map.removeLayer(marker);
                    }

                    // اضافه کردن مارکر به مکان فعلی کاربر
                    marker = L.marker([lat, lng]).addTo(map);
                    map.setView([lat, lng], 14); // زوم به مکان کاربر

                    // قرار دادن مختصات مکان فعلی کاربر در inputها
                    document.getElementById('latitude').value = lat;
                    document.getElementById('longitude').value = lng;
                }, function (error) {
                    alert('Not Found Location 1');
                });
            } else {
                alert('Not Found Location 2');
            }
        });
    </script>
@endsection