@extends('admin.layouts.app',['tbl'=>true,'req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                        @can('transport_create')
                            <a href="{{route('admin.transport.create')}}"
                               class="btn btn-primary float-left">{{translateText('افزودن',lang_admin())}}</a>
                        @endcan
                    </h4>
                </div>

                <div class="card-body">
                    @can('transport_edit')
                    <div class="container-fluid shadow-lg rounded mb-5">
                        {{ Form::open(array('route' => 'admin.transport.top.page', 'method' => 'POST','id'=>'form_req','files'=>true,'class'=>'row')) }}
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}"
                                            id="nav-{{$lang->lang}}-tab" data-toggle="tab"
                                            data-target="#nav-{{$lang->lang}}" type="button" role="tab"
                                            aria-controls="nav-{{$lang->lang}}"
                                            aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}"
                                     id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-8">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'transport_title':'transport_title_'.$lang->lang, translateText('عنوان',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'transport_title':'transport_title_'.$lang->lang,read_lang($setting,'transport_title',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'transport_text':'transport_text_'.$lang->lang, translateText('متن بالای صفحه',lang_admin()))}}
                                                    {{Form::textarea($lang->status=='default'?'transport_text':'transport_text_'.$lang->lang,read_lang($setting,'transport_text',$lang->lang), array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id="photos">
                                {{Form::label('transport_photo', translateText('تصویر',lang_admin()))}}
                                {{Form::file('transport_photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.webp','id' => $setting->transport_photo ? $setting->transport_photo->id : 0,'data-default-file'=>$setting->transport_photo && is_file($setting->transport_photo->path)?url($setting->transport_photo->path):null))}}
                            </div>
                            <p class="text-danger">
                                _<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">
                                _<small>{{translateText('بهترین سایز تصویر عرض 600 پیکسل در ارتفاع 400 پیکسل می باشد',lang_admin())}}</small>
                            </p>
                            <p class="text-danger">
                                _<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP باشد',lang_admin())}}</small>
                            </p>
                        </div>
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('ویرایش',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                        {{ Form::close() }}
                    </div>
                    @endcan
                        @can('transport_create')
                            <a href="{{route('admin.transport.create')}}"
                               class="btn btn-primary float-left">{{translateText('افزودن',lang_admin())}}</a>
                        @endcan
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0">{{translateText('نام شرکت',lang_admin())}}</th>
                                @can('transport_sort')
                                    <th class="border-bottom-0">{{translateText('Sort',lang_admin())}}</th>
                                @endcan
                                @canany(['transport_edit','transport_delete'])
                                    <th class="border-bottom-0">{{translateText('عملیات',lang_admin())}}</th>
                                @endcan
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>
                                        {{$item->title}}
                                    </td>
                                    @can('transport_sort')
                                        <td>
                                            {!! Form::open(['method' => 'POST', 'route' => ['admin.transport.sort', $item->id] ]) !!}
                                            <input type="number" name="sort" class="form-control w-60px"
                                                   value="{{$item->sort}}" onchange="return this.form.submit()">
                                            {!! Form::close() !!}
                                        </td>
                                    @endcan
                                    @canany(['transport_edit','transport_delete'])
                                        <td>
                                            <div class="d-flex">
                                                @can('transport_edit')
                                                    <a href="{{route('admin.transport.edit',$item->id)}}"
                                                       class="action-btns1">
                                                        <i class="feather feather-edit-2  text-success"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="{{translateText('ویرایش',lang_admin())}}"></i>
                                                    </a>
                                                @endcan
                                                @can('transport_delete')
                                                    {!! Form::open(['method' => 'DELETE', 'route' => ['admin.transport.destroy', $item->id] ]) !!}
                                                    <button class="action-btns1" data-toggle="tooltip"
                                                            data-placement="top"
                                                            title="{{translateText('حذف',lang_admin())}}"
                                                            onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                                                        <i class="feather feather-trash-2 text-danger"></i>
                                                    </button>
                                                    {!! Form::close() !!}
                                                @endcan
                                            </div>
                                        </td>
                                    @endcan
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
