@php
    $i=0;
@endphp
@foreach($items as $item)
    @php
        $i++;
    @endphp
    <tr>
        <td dir="ltr">{{$number}} - {{$i < 10 ? "0$i" : $i}}</td>
        <td>
            {{$item->title}}
        </td>
        <td dir="ltr" class="text-center">
            @if($item->parent && $item->parent->parent && $item->parent->parent->parent)
                <span class="badge badge-info mb-1">{{$item->parent->parent->parent->title}}</span>
                <br/>
            @endif
            @if($item->parent && $item->parent->parent)
                <span class="badge badge-info mb-1">{{$item->parent->parent->title}}</span>
                <br/>
            @endif
            @if($item->parent)
                <span class="badge badge-info">{{$item->parent->title}}</span>
            @endif
        </td>
        @can('product_category_supplier_sort')
            <td>
                {!! Form::open(['method' => 'POST', 'route' => ['admin.product-category-supplier.sort', $item->id] ]) !!}
                <input type="number" name="sort" class="form-control w-60px" value="{{$item->sort}}"
                       onchange="return this.form.submit()">
                {!! Form::close() !!}
            </td>
        @endcan
        @canany(['product_category_supplier_edit','product_category_supplier_delete'])
            <td>
                <div class="d-flex">
                    @can('product_category_supplier_edit')
                        <a href="{{route('admin.product-category-supplier.edit',$item->id)}}"
                           class="action-btns1">
                            <i class="feather feather-edit-2  text-success"
                               data-toggle="tooltip" data-placement="top"
                               title="{{translateText('ویرایش',lang_admin())}}"></i>
                        </a>
                    @endcan
                    @can('product_category_supplier_delete')
                        {!! Form::open(['method' => 'DELETE', 'route' => ['admin.product-category-supplier.destroy', $item->id] ]) !!}
                        <button class="action-btns1" data-toggle="tooltip"
                                data-placement="top" title="{{translateText('حذف',lang_admin())}}"
                                onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                            <i class="feather feather-trash-2 text-danger"></i>
                        </button>
                        {!! Form::close() !!}
                    @endcan
                </div>
            </td>
        @endcan
    </tr>
    {{--  @if(count($item->childs))--}}
    {{--      @include('admin.product.category.each',['items'=>$item->childs,'number'=>$number.' - '.$i < 10 ? "0$i" : $i])--}}
    {{--  @endif--}}
@endforeach