@extends('admin.layouts.app',['req'=>true])

@section('content')
    <style>
        .box-sh
        {
            box-shadow: 0 0 2px 0 #666;
            border-radius: 5px;
            padding: 10px;
            margin-bottom: 20px;
        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                    </h4>
                </div>
                <div class="card-body">
                    <div class="container-fluid box-sh">
                        <form action="{{route('admin.product.price.store',$product->id)}}" method="post" id="frm-req" class="row">
                            @csrf
                            <div class="col-12">
                                <h5>{{translateText('افزودن',lang_admin())}}</h5>
                                <hr/>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('price', translateText('قیمت فروش(دلار)',lang_admin()).' *')}}
                                    {{ Form::number('price', null, array('class' => 'form-control text-center','dir'=>'ltr','step'=>'0.01','required')) }}
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('from', translateText('از',lang_admin()).'('.$product->unit.') *')}}
                                    {{ Form::number('from', null, array('class' => 'form-control text-center','dir'=>'ltr','required')) }}
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('to', translateText('تا',lang_admin()).'('.$product->unit.') *')}}
                                    {{ Form::number('to', null, array('class' => 'form-control text-center','dir'=>'ltr','required')) }}
                                </div>
                            </div>
                            <div class="col-md-12 text-left">
                                {{Form::submit(translateText('افزودن',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                            </div>
                        </form>
                    </div>
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-wrap table-bordered border-bottom">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0">{{translateText('قیمت(دلار)',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('از ',lang_admin())}} {{$product->unit}}</th>
                                <th class="border-bottom-0">{{translateText('تا ',lang_admin())}} {{$product->unit}}</th>
                                <th class="border-bottom-0">{{translateText('عملیات',lang_admin())}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <form action="{{route('admin.product.price.update',$item->id)}}" method="post">
                                    @csrf
                                    <tr>
                                        <td>{{$key+1}}</td>
                                        <td>
                                            <input type="number" class="form-control text-center" step="0.01"
                                                   name="price" dir="ltr" value="{{$item->price}}">
                                        </td>
                                        <td>
                                            <input type="number" class="form-control text-center" step="1" name="from"
                                                   dir="ltr" value="{{$item->from}}">
                                        </td>
                                        <td>
                                            <input type="number" class="form-control text-center" step="1" name="to"
                                                   dir="ltr" value="{{$item->to}}">
                                        </td>
                                        <td>
                                            <div class="d-flex">
                                                <button type="submit"
                                                        class="action-btns1" onclick="return confirm('{{translateText('برای ویرایش مطمئن هستید؟',lang_admin())}}')">
                                                    <i class="feather feather-edit-2  text-success"
                                                       data-toggle="tooltip" data-placement="top"
                                                       title="{{translateText('ویرایش',lang_admin())}}"></i>
                                                </button>
                                                <a href="{{route('admin.product.price.remove', $item->id)}}"
                                                   class="action-btns1" data-toggle="tooltip"
                                                   data-placement="top" title="{{translateText('حذف',lang_admin())}}"
                                                   onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                                                    <i class="feather feather-trash-2 text-danger"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                </form>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
