@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
    <style>
        .select2-container,
        .select2-results__option
        {
            direction: ltr;
            text-align: left;
        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>
                <hr>

                <div class="card-body">
                    {{ Form::open(array('route' => 'admin.product-service.store', 'method' => 'POST','id'=>'form_req','files'=>true)) }}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}"
                                            id="nav-{{$lang->lang}}-tab" data-toggle="tab"
                                            data-target="#nav-{{$lang->lang}}" type="button" role="tab"
                                            aria-controls="nav-{{$lang->lang}}"
                                            aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div
                                    class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}"
                                    id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'status':'status_'.$lang->lang, translateText('وضعیت',lang_admin()).' *')}}
                                                    {{ Form::select($lang->status=='default'?'status':'status_'.$lang->lang, ['pending'=>translateText('عدم انتشار',lang_admin()),'active'=>translateText('انتشار',lang_admin())], null, array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید',)) }}
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, translateText('نام خدمت',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'title':'title_'.$lang->lang,null, array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'unit':'unit_'.$lang->lang, translateText('واحد فروش(تن/کیلوگرم/عدد)',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'unit':'unit_'.$lang->lang,null, array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                {{Form::label($lang->status=='default'?'text':'text_'.$lang->lang, translateText('درباره خدمت توضیح دهید',lang_admin()))}}
                                                <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'text':'text_'.$lang->lang, null, array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'meta_title':'meta_title_'.$lang->lang, translateText('عنوان صفحه(سئو)',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'meta_title':'meta_title_'.$lang->lang, null, array('class' => 'form-control'))}}
                                                </div>
                                                <p class="text-danger">_<small> {{translateText('می تواند نام خدمت باشد، برای شناخت بهتر درگوگل',lang_admin())}}</small></p>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'meta_description':'meta_description_'.$lang->lang, translateText('توضیحات(سئو)',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'meta_description':'meta_description_'.$lang->lang, null, array('class' => 'form-control'))}}
                                                </div>
                                                <p class="text-danger">_<small> {{translateText('حداکثر 120 کاراکتر توضیح، مناسب برای شناخت در گوگل',lang_admin())}}</small></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('category_id1', translateText('دسته بندی 1',lang_admin()).' *')}}
                                <select name="category_id1" dir="ltr" id="category1_id"
                                        class="form-control" required>
                                    @foreach($cats as $cat)
                                        <option value="{{$cat->id}}" {{old('category_id1')==$cat->id?'selected':''}}>{{$cat->title}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('category_id2', translateText('دسته بندی 2',lang_admin()).' *')}}
                                <select name="category_id2" dir="ltr" id="category2_id"
                                        class="form-control" required>
                                    @if(count($cats2))
                                        <option value="">{{translateText('Selected Category',lang_admin())}}</option>
                                        @foreach($cats2 as $cat)
                                            <option value="{{$cat->id}}" class="cat_id2 cat_id2_{{$cat->parent_id}}" {{old('category_id2')==$cat->id?'selected':''}}>{{$cat->title}}</option>
                                        @endforeach
                                    @else
                                        <option value="">{{translateText('ابتدا دسته بندی های خود را تعریف کنید',lang_admin())}}</option>
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('category_id3', translateText('دسته بندی 3',lang_admin()).' *')}}
                                <select name="category_id3" dir="ltr" id="category3_id"
                                        class="form-control" required>
                                    <option value="">{{translateText('Selected Category',lang_admin())}}</option>
                                    @foreach($cats3 as $cat)
                                        <option value="{{$cat->id}}" class="cat_id3 cat_id3_{{$cat->parent_id}} {{old('category2_id') && old('category2_id') == $cat->parent_id ? '' : 'd-none'}}" {{old('category_id3')==$cat->id?'selected':''}} {{old('category2_id') && old('category2_id') == $cat->parent_id ? '' : 'disabled'}}>{{$cat->title}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('category_id', translateText('دسته بندی 4',lang_admin()))}}
                                <select name="category_id" dir="ltr" id="category_id"
                                        class="form-control" required>
                                    <option value="father">{{translateText('Selected Category',lang_admin())}}</option>
                                    @foreach($cats3 as $cat)
                                        @foreach($cat->childs->where('user_id', auth()->id()) as $childs)
                                            <option value="{{$childs->id}}" class="cat_id4 cat_id4_{{$childs->parent_id}} {{old('category3_id') && old('category3_id') == $childs->parent_id ? '' : 'd-none'}}" {{old('category_id')==$childs->id?'selected':''}}  {{old('category3_id') && old('category3_id') == $childs->parent_id ? '' : 'disabled'}}>{{$childs->title}}</option>
                                        @endforeach
                                    @endforeach
                                </select>
                            </div>
                        </div>
{{--                        <div class="col-md-4">--}}
{{--                            <div class="form-group">--}}
{{--                                {{Form::label('slug', 'Slug  *')}}--}}
{{--                                {{ Form::text('slug', null, array('class' => 'form-control slug_input','required')) }}--}}
{{--                            </div>--}}
{{--                            <p class="text-danger">_<small> {{translateText('در آدرس دهی خدمت استفاده می شود(مناسب برای سئو)',lang_admin())}}</small></p>--}}
{{--                            <p class="text-danger">_<small> {{translateText('بهتر است نام خدمت بصورت لاتین وارد شود.',lang_admin())}}</small></p>--}}
{{--                        </div>--}}
                        <div class="col-md-12"></div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('photo', translateText('تصویر',lang_admin()).'* ')}}
                                {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.png,.webp','required'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('بهترین سایز تصویر عرض 600 پیکسل در ارتفاع 400 پیکسل می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('video', translateText('ویدئو',lang_admin()))}}
                                {{Form::file('video', array('class' => 'dropify','data-height'=>'180','accept' => '.mp4,.mov'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 10MB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('ویدئو مرتبط با خدمت',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت فقط باید MP4,MOV باشد',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id="photos">
                                {{Form::label('icon', translateText('آیکون(سرویس منتخب)',lang_admin()))}}
                                {{Form::file('icon', array('class' => 'dropify','data-height'=>'180','accept' => '.png,.webp'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 256KB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('بهترین سایز تصویر عرض 100 پیکسل در ارتفاع 100 پیکسل می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید WEBP,PNG باشد',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="form-group">
                                    {{Form::label('photos',translateText('تصاویر',lang_admin()))}}
                                    <div class="input-group mb-5 file-browser">
                                        <input type="text" class="form-control browse-file"
                                               placeholder="{{translateText('تصاویر مربوط به خدمت را انتخاب کنید',lang_admin())}}" readonly>
                                        <label class="input-group-append">
                                            <span class="btn btn-primary">
                                                {{translateText('انتخاب',lang_admin())}}
                                                {{Form::file('photos[]', array('class' => 'file-browserinput d-none','accept' => '.jpg,.png,.jpeg,.webp','multiple'))}}
                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('بهترین سایز تصویر عرض 600 پیکسل در ارتفاع 400 پیکسل می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('برای انتخاب چند تصویر دکمه ctrl کیبورد را نگه دارید و چند تصویر را انتخاب کنید',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('افزودن',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>
@endsection
@section('in_tag_script')
    <script>
        $('#category1_id').on('change',function (){
            var value=$(this).val();
            $('.cat_id2').prop('disabled',true)
            $('.cat_id2').addClass('d-none')
            $('.cat_id3').prop('disabled',true)
            $('.cat_id3').addClass('d-none')
            $('.cat_id4').prop('disabled',true)
            $('.cat_id4').addClass('d-none')
            $('.cat_id2_'+value).prop('disabled',false)
            $('.cat_id2_'+value).removeClass('d-none')
            $('#category2_id').val('')
            $('#category3_id').val('')
            $('#category_id').val('father')
        })
        $('#category2_id').on('change',function (){
            var value=$(this).val();
            $('.cat_id3').prop('disabled',true)
            $('.cat_id3').addClass('d-none')
            $('.cat_id4').prop('disabled',true)
            $('.cat_id4').addClass('d-none')
            $('.cat_id3_'+value).prop('disabled',false)
            $('.cat_id3_'+value).removeClass('d-none')
            $('#category3_id').val('')
            $('#category_id').val('father')
        })
        $('#category3_id').on('change',function (){
            var value=$(this).val();
            $('.cat_id4').prop('disabled',true)
            $('.cat_id4').addClass('d-none')
            $('.cat_id4_'+value).prop('disabled',false)
            $('.cat_id4_'+value).removeClass('d-none')
            $('#category_id').val('father')
        })

    </script>
@endsection
