@extends('admin.layouts.app', ['req' => true, 'editor' => true, 'file_upload' => true])
@section('content')
    <div class="container-fluid py-4">
        <div class="row justify-content-center">
            <div class="col-lg-10 col-md-12">
                <div class="card shadow-sm border-0 rounded-3">
                    <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center py-3">
                        <h3 class="card-title mb-0">{{$title}}</h3>
                        <a href="{{  route('admin.rfq-form.index2')}}"
                           class="btn btn-light btn-sm">
                            <i class="bi bi-arrow-right me-2"></i>{{translateText('بازگشت',lang_admin())}}
                        </a>
                    </div>
                    <div class="card-body p-4">
                        <div class="row g-4">
                            <div class="col-md-12">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('نام کاربری / ایمیل',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->user->username }}</p>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('عنوان محصولات',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->product_name }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('دسته بندی',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->category->title }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('دسته بندی درخواستی',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->product_category_custom == null ? translateText('ندارد',lang_admin()) : $item->product_category_custom}}</p>
                                </div>
                            </div>
                        </div>
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('مقدار مورد نیاز',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->required_quantity }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('واحد',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->select_unit }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('شرایط تجارت',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->trade_terms }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('محدودیت بودجه',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->budget_limit }} USD</p>
                                </div>
                            </div>
                        </div>
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('قیمت واحد مورد انتظار',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->expected_unit_price }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('واحد مورد انتظار',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->expected_unit_price_currency }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('فرکانس خرید',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->buying_frequency }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('مقصد',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->destination }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('متد ارسال',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->shipping_method }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('شرایط پرداخت',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->payment_terms }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="row g-4">
                            <div class="col-md-4">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('زمان تحویل',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->delivery_time }}</p>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('rfq expiry',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->rfq_expiry }}</p>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('rfq expiry type',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->rfq_expiry_type }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="row g-4">
                            <div class="col-md-12">
                                <div class="form-group bg-light p-3 rounded">
                                    <label class="form-label fw-bold"><i
                                                class="bi bi-truck text-primary me-2"></i>{{translateText('جزئیات محصول',lang_admin())}}
                                        :
                                    </label>
                                    <p class="mb-0 text-primary">{{ $item->product_details}}</p>
                                </div>
                            </div>
                        </div>
                        <div class="row g-4">
                            <div class="col-md-12">
                            <div class="form-group bg-light p-3 rounded">
                                <label class="form-label fw-bold"><i
                                            class="bi bi-truck text-primary me-2"></i>{{translateText('فایل ها',lang_admin())}}
                                    :
                                </label>
                                @foreach($item->file as $file)
                                    <a href="{{url($file->path)}}"
                                       class="mb-0 btn btn-info">{{translateText('مشاهده',lang_admin())}}</a>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
@endsection