@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item,array('route' => array('admin.about.update',$item->id),'id'=>'form_req', 'method' => 'PATCH','files'=>true)) }}
                    {{Form::hidden('id', $item->id)}}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}" id="nav-{{$lang->lang}}-tab" data-toggle="tab" data-target="#nav-{{$lang->lang}}" type="button" role="tab" aria-controls="nav-{{$lang->lang}}" aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}" id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, translateText('عنوان درباره ما',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'title':'title_'.$lang->lang, read_lang($item,'title',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'text':'text_'.$lang->lang, translateText('متن درباره ما',lang_admin()))}}
                                                    {{Form::textarea($lang->status=='default'?'text':'text_'.$lang->lang, read_lang($item,'text',$lang->lang), array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                            <div class="col-md-6 {{$item->type=='about'?'':'d-none'}}">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title1':'title1_'.$lang->lang, translateText('عنوان ماموریت ما',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'title1':'title1_'.$lang->lang, read_lang($item,'title1',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-6 {{$item->type=='register'?'':'d-none'}}">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title1':'title1_'.$lang->lang, translateText('عنوان بخش تکمیل کردن ثبت نام',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'title1':'title1_'.$lang->lang, read_lang($item,'title1',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12 {{$item->type=='about'?'':'d-none'}}">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'text1':'text1_'.$lang->lang, translateText('متن ماموریت ما',lang_admin()))}}
                                                    {{Form::textarea($lang->status=='default'?'text1':'text1_'.$lang->lang,  read_lang($item,'text1',$lang->lang), array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12 {{$item->type=='register'?'':'d-none'}}">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'text1':'text1_'.$lang->lang, translateText('متن بخش تکمیل کردن ثبت نام',lang_admin()))}}
                                                    {{Form::textarea($lang->status=='default'?'text1':'text1_'.$lang->lang,  read_lang($item,'text1',$lang->lang), array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>

                                            <div class="col-md-12 {{$item->type=='about'?'':'d-none'}}">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'text2':'text2_'.$lang->lang, translateText('متن انتها',lang_admin()))}}
                                                    {{Form::textarea($lang->status=='default'?'text2':'text2_'.$lang->lang,  read_lang($item,'text2',$lang->lang), array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12 {{$item->type=='register'?'':'d-none'}}">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'text2':'text2_'.$lang->lang, translateText('متن انتها',lang_admin()))}}
                                                    {{Form::textarea($lang->status=='default'?'text2':'text2_'.$lang->lang,  read_lang($item,'text2',$lang->lang), array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12  d-none">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'text3':'text3_'.$lang->lang, 'متن3')}}
                                                    {{Form::textarea($lang->status=='default'?'text3':'text3_'.$lang->lang,  read_lang($item,'text3',$lang->lang), array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <div class="col-md-12 {{$item->type=='footer' || 'register'?'d-none':''}}">
                            <div class="form-group" id="photos">
                                {{Form::label('photo',translateText('تصویر',lang_admin()))}}
                                {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.webp','id' => $item->photo ? $item->photo->id : 0,'data-default-file'=>$item->photo && is_file($item->photo->path)?url($item->photo->path):null))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('بهترین سایز تصویر عرض 1100 پیکسل در ارتفاع 280 پیکسل می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP باشد',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('ویرایش',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </div>


@endsection
@push('in_tag_script')

@endpush
