@extends('admin.layouts.app',['req'=>true,'file_upload'=>true])

@section('content')
  <div class="row mt-5">
    <div class="col-xl-12 col-md-12 col-lg-12">
      <div class="card">
        <div class="card-header  border-0">
          <h4 class="card-title">
            {{$title}}
          </h4>
        </div>
        <hr>

        <div class="card-body">
          {{ Form::open(array('route' => 'admin.lang-set.store', 'method' => 'POST','id'=>'form_req','files'=>true)) }}
          <div class="row">
            <div class="col-md-4">
              <div class="form-group">
                {{Form::label('title', translateText('عنوان',lang_admin()).' *')}}
                {{Form::text('title',null, array('class' => 'form-control','required'))}}
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                {{Form::label('lang', translateText('اختصار 2 حرفی',lang_admin()).' *')}}
                {{Form::text('lang',null, array('class' => 'form-control en_input','required'))}}
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                {{Form::label('faker', 'Faker Locale * ')}}
                {{Form::text('faker',null, array('class' => 'form-control en_input','required'))}}
                <p class="text-danger">_<small>{{translateText('مثل نمونه',lang_admin())}}: fa_IR</small></p>
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                {{Form::label('farsi_font', translateText('فونت',lang_admin()).' *')}}
                {{ Form::select('farsi_font', ['no'=>translateText('انگلیسی',lang_admin()),'yes'=>translateText('فارسی',lang_admin())], null, array('class' => 'form-control select2-show-search custom-select')) }}
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                {{Form::label('align', translateText('چیدمان',lang_admin()).' *')}}
                {{ Form::select('align', ['ltr'=>translateText('چپ به راست',lang_admin()),'rtl'=>translateText('راست به چپ',lang_admin())], null, array('class' => 'form-control select2-show-search custom-select')) }}
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                {{Form::label('status', translateText('وضعیت',lang_admin()).' *')}}
                {{ Form::select('status', ['active'=>translateText('انتشار',lang_admin()),'pending'=>translateText('عدم انتشار',lang_admin())], null, array('class' => 'form-control select2-show-search custom-select')) }}
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                {{Form::label('sort', translateText('Sort',lang_admin()))}}
                {{Form::number('sort',$sort, array('class' => 'form-control'))}}
              </div>
            </div>

            <div class="col-md-12"></div>
            <div class="col-md-6">
              <div class="form-group">
                {{Form::label('photo', translateText('تصویر',lang_admin()).' *')}}
                {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.png,.webp','required'))}}
              </div>
              <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
              <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small></p>
            </div>
            <div class="col-md-12 text-left">
              <hr/>
              {{Form::submit(translateText('افزودن',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
            </div>
          </div>
          {{ Form::close() }}
        </div>
      </div>
    </div>
  </div>
@endsection
@push('in_tag_script')

@endpush
