@extends('admin.layouts.app',['req'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>
                <hr>

                <div class="card-body">
                    {{ Form::open(array('route' => 'admin.meta.store', 'method' => 'POST','id'=>'form_req','files'=>true)) }}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}" id="nav-{{$lang->lang}}-tab" data-toggle="tab" data-target="#nav-{{$lang->lang}}" type="button" role="tab" aria-controls="nav-{{$lang->lang}}" aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}" id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'status':'status_'.$lang->lang, translateText('وضعیت',lang_admin()).' *')}}
                                                    {{ Form::select($lang->status=='default'?'status':'status_'.$lang->lang, ['active'=>translateText('انتشار',lang_admin()),'pending'=>translateText('عدم انتشار',lang_admin())], null, array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید',)) }}
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'name_page':'name_page_'.$lang->lang, translateText('عنوان صفحه',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'name_page':'name_page_'.$lang->lang, null, array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title_page':'title_page_'.$lang->lang, translateText('عنوان متا',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'title_page':'title_page_'.$lang->lang, null, array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'keyword':'keyword_'.$lang->lang, translateText('کلمات کلیدی',lang_admin()))}}
                                                    {{Form::textarea($lang->status=='default'?'keyword':'keyword_'.$lang->lang, null, array('class' => 'form-control','rows'=>3))}}
                                                </div>
                                                <p class="text-danger">_<small>{{translateText('حداکثر 500 کاراکتر',lang_admin())}}</small></p>
                                                <p class="text-danger">_<small>{{translateText('کلمات کلیدی را با "," از هم جدا کنید',lang_admin())}}</small></p>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'description':'description_'.$lang->lang, translateText('توضیحات',lang_admin()))}}
                                                    {{Form::textarea($lang->status=='default'?'description':'description_'.$lang->lang, null, array('class' => 'form-control','rows'=>3))}}
                                                </div>
                                                <p class="text-danger">_<small>{{translateText('حداکثر 500 کاراکتر',lang_admin())}}</small></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                {{Form::label('link', translateText('لینک صفحه',lang_admin()).' *')}}
                                {{Form::url('link', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                {{Form::label('canonical', 'Canonical')}}
                                {{Form::url('canonical', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                {{Form::label('robots', 'Robots')}}
                                {{Form::text('robots', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                {{Form::label('schema', 'Schema')}}
                                {{Form::textarea('schema', null, array('class' => 'form-control text-left','dir'=>'ltr','rows'=>3))}}
                            </div>
                        </div>
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('افزودن',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>


@endsection
