@extends('admin.layouts.app')

@section('content')
    <style>
        .remover
        {
            cursor: pointer;
            color: #ab0011;
            box-shadow: 0 0 2px 0 #ab0011;
            padding: 3px;
        }
        .append_add_1 .box_add_1:first-child .remove_div,
        .append_add_2 .box_add_2:first-child .remove_div,
        .append_add_3 .box_add_3:first-child .remove_div
        {
            display: none!important;
        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-xl-12 col-md-12 col-lg-12">
                        <div class="tab-menu-heading hremp-tabs p-0">
                            <div class="tabs-menu1">
                                <!-- Tabs -->
                                @include('admin.setting.profile.include.tab',['active'=>3])
                            </div>
                        </div>
                        <div class="panel-body tabs-menu-body hremp-tabs1 p-0">
                            @can('profile_verify')
                                <div class="card-body">
                                    {{ Form::model($item,array('route' => array('admin.profile.update.verify'), 'method' => 'PATCH','id'=>'form_req','files'=>true)) }}
                                    {{Form::hidden('id', $item->id)}}
                                    <div class="row">
                                        @if(auth()->user()->status_verify == 'active')
                                            <div class="col-12 my-3 py-3 badge badge-success">
                                                {{translateText('Your Account Has Been Verified. If You Make Any Changes to This Section, Your Account Will be Removed From Verification Mode.',lang_admin())}}
                                            </div>
                                        @endif
                                        @if(count($certificates))
                                            <div class="col-12">
                                                <h3 class="text-center">
                                                    {{translateText('گواهینامه های ثبت شده',lang_admin())}}
                                                </h3>
                                            </div>
                                            <table class="table table-striped">
                                                <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>{{translateText('نوع سند',lang_admin())}}</th>
                                                    <th>{{translateText('نوع گواهینامه',lang_admin())}}</th>
                                                    <th>Tax Id/License Id</th>
                                                    <th>{{translateText('تصویر',lang_admin())}}</th>
                                                    <th>{{translateText('حذف',lang_admin())}}</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach($certificates as $key=>$certificate)
                                                    <tr>
                                                        <th scope="row">{{$key + 1}}</th>
                                                        <td>{{$certificate->get_type_title()}}</td>
                                                        <td>{{$certificate->select_type ? $certificate->select_type->title : '__'}}</td>
                                                        <td>{{!blank($certificate->tax_id) ? $certificate->tax_id : '__'}}</td>
                                                        <td>
                                                            @if($certificate->photo)
                                                                <a href="{{url($certificate->photo->path)}}"
                                                                   target="_blank">
                                                                    {{translateText('نمایش',lang_admin())}}
                                                                </a>
                                                            @else
                                                                __
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <a href="{{route('admin.profile.delete.verify.certificate',$certificate->id)}}"
                                                               class="btn btn-danger"
                                                               onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                                                                × {{translateText('حذف',lang_admin())}}
                                                            </a>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                        @endif
                                            @if(auth()->user()->hasRole('buyer'))
                                                @if(auth()->user()->user_type == 'legal')
{{--                                                Business Card--}}
                                                <div class="col-12">
                                                    <hr/>
                                                    <h3 class="text-center">Business Card</h3>
                                                </div>
                                                <div class="container-fluid append_add_1">
                                                    <div class="row box_add_1">
                                                        <div class="col-md-12 mt-5 mb-3 text-left remove_div">
                                                            <i class="remover fa fa-close" title="Remove"></i>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group" id="photos">
                                                                {{Form::label('photo_card', translateText('تصویر',lang_admin()))}}
                                                                {{Form::file('photo_card[]', array('class' => 'form-control','accept' => '.jpg,.jpeg,.png,.webp'))}}
                                                            </div>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small>
                                                            </p>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small>
                                                            </p>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('در صورتی که دارید وارد کنید.',lang_admin())}}</small>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-12">
                                                    <button type="button" class="btn btn-primary new_btn_1 w-100">
                                                        New Business Card
                                                    </button>
                                                </div>
{{--                                                Business License--}}
                                                <div class="col-12">
                                                    <hr/>
                                                    <h3 class="text-center">Business License</h3>
                                                </div>
                                                <div class="container-fluid append_add_2">
                                                    <div class="row box_add_2">
                                                        <div class="col-md-12 mt-5 mb-3 text-left remove_div">
                                                            <i class="remover fa fa-close" title="Remove"></i>
                                                        </div>
                                                        <div class="col-lg-4 col-md-6">
                                                            <div class="form-group">
                                                                {{Form::label('license_number', 'License Number')}}
                                                                {{Form::text('license_number[]', null, array('class' => 'form-control slug_input d-ltr text-left'))}}
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group" id="photos">
                                                                {{Form::label('photo_license', translateText('تصویر',lang_admin()))}}
                                                                {{Form::file('photo_license[]', array('class' => 'form-control','accept' => '.jpg,.jpeg,.png,.webp'))}}
                                                            </div>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small>
                                                            </p>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small>
                                                            </p>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('در صورتی که دارید وارد کنید.',lang_admin())}}</small>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-12">
                                                    <button type="button" class="btn btn-primary new_btn_2 w-100">
                                                        New Business License
                                                    </button>
                                                </div>
{{--                                                دیگر گواهینامه ها--}}
                                                <div class="col-12">
                                                    <hr/>
                                                    <h3 class="text-center">{{translateText('دیگر گواهینامه ها',lang_admin())}}</h3>
                                                </div>
                                                <div class="container-fluid append_add_3">
                                                    <div class="row box_add_3">
                                                        <div class="col-md-12 mt-5 mb-3 text-left remove_div">
                                                            <i class="remover fa fa-close" title="Remove"></i>
                                                        </div>
                                                        <div class="col-lg-4 col-md-6">
                                                            <div class="form-group">
                                                                {{Form::label('type_title', translateText('حقیقی/حقوقی',lang_admin()))}}
                                                                {{ Form::select('type_title[]', ['company_document'=>translateText('حقوقی',lang_admin()),'personal_identification'=>translateText('حقیقی',lang_admin())], null, array('class' => 'form-control')) }}
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-6">
                                                            <div class="form-group">
                                                                {{Form::label('type_id', translateText('نوع سند',lang_admin()))}}
                                                                {{ Form::select('type_id[]', array_pluck($type_certificate, 'title', 'id'), null, array('class' => 'form-control')) }}
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-6">
                                                            <div class="form-group">
                                                                {{Form::label('tax_id', 'Tax Id')}}
                                                                {{Form::text('tax_id[]', null, array('class' => 'form-control slug_input d-ltr text-left'))}}
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group" id="photos">
                                                                {{Form::label('photo', translateText('تصویر',lang_admin()))}}
                                                                {{Form::file('photo[]', array('class' => 'form-control','accept' => '.jpg,.jpeg,.png,.webp'))}}
                                                            </div>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small>
                                                            </p>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small>
                                                            </p>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('در صورتی که دارید وارد کنید.',lang_admin())}}</small>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-12">
                                                    <button type="button" class="btn btn-primary w-100 new_btn_3">
                                                        + New Certificate
                                                    </button>
                                                </div>
                                                @endif

                                                    {{--                                                Passport--}}
                                                    <div class="col-12">
                                                        <hr/>
                                                        <h3 class="text-center">{{translateText('Passport',lang_admin())}}</h3>
                                                    </div>
                                                    <div class="container-fluid">
                                                        <div class="row">
                                                            <div class="col-lg-4 col-md-6">
                                                                <div class="form-group">
                                                                    {{Form::label('p_code', translateText('Passport Number',lang_admin()))}}
                                                                    {{Form::text('p_code', auth()->user()->passport?auth()->user()->passport->tax_id:null, array('class' => 'form-control slug_input d-ltr text-left'))}}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <div class="form-group" id="photos">
                                                                    {{Form::label('p_photo', translateText('تصویر',lang_admin()))}}
                                                                    {{Form::file('p_photo', array('class' => 'form-control','accept' => '.jpg,.jpeg,.png,.webp'))}}
                                                                </div>
                                                                <p class="text-danger">
                                                                    _<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small>
                                                                </p>
                                                                <p class="text-danger">
                                                                    _<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small>
                                                                </p>
                                                                @if(auth()->user()->passport && auth()->user()->passport->photo)
                                                                    <p class="text-danger">
                                                                        _<small>
                                                                            <a href="{{url(auth()->user()->passport->photo->path)}}"
                                                                               target="_blank">
                                                                                {{translateText('نمایش',lang_admin())}}
                                                                            </a>
                                                                        </small>
                                                                    </p>
                                                                    <p class="text-danger">
                                                                        _<small>
                                                                            <a href="{{route('admin.profile.delete.verify.certificate',auth()->user()->passport->id)}}"
                                                                               class="btn btn-danger"
                                                                               onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                                                                                × {{translateText('حذف',lang_admin())}}
                                                                            </a>
                                                                        </small>
                                                                    </p>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                    {{--                                                National ID card--}}
                                                    <div class="col-12">
                                                        <hr/>
                                                        <h3 class="text-center">{{translateText('National ID Card',lang_admin())}}</h3>
                                                    </div>
                                                    <div class="container-fluid append_add_2">
                                                        <div class="row box_add_2">
                                                            <div class="col-lg-4 col-md-6">
                                                                <div class="form-group">
                                                                    {{Form::label('n_code',  translateText('National ID Card Number',lang_admin()))}}
                                                                    {{Form::text('n_code', auth()->user()->n_cart?auth()->user()->n_cart->tax_id:null, array('class' => 'form-control slug_input d-ltr text-left'))}}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <div class="form-group" id="photos">
                                                                    {{Form::label('n_photo', translateText('تصویر',lang_admin()))}}
                                                                    {{Form::file('n_photo', array('class' => 'form-control','accept' => '.jpg,.jpeg,.png,.webp'))}}
                                                                </div>
                                                                <p class="text-danger">
                                                                    _<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small>
                                                                </p>
                                                                <p class="text-danger">
                                                                    _<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small>
                                                                </p>
                                                                @if(auth()->user()->n_cart && auth()->user()->n_cart->photo)
                                                                <p class="text-danger">
                                                                    _<small>
                                                                        <a href="{{url(auth()->user()->n_cart->photo->path)}}"
                                                                           target="_blank">
                                                                            {{translateText('نمایش',lang_admin())}}
                                                                        </a>
                                                                    </small>
                                                                </p>
                                                                <p class="text-danger">
                                                                    _<small>
                                                                        <a href="{{route('admin.profile.delete.verify.certificate',auth()->user()->n_cart->id)}}"
                                                                           class="btn btn-danger"
                                                                           onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                                                                            × {{translateText('حذف',lang_admin())}}
                                                                        </a>
                                                                    </small>
                                                                </p>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                            @else
{{--                                                Business Card--}}
                                                <div class="col-12">
                                                    <hr/>
                                                    <h3 class="text-center">Business Card</h3>
                                                </div>
                                                <div class="container-fluid append_add_1">
                                                    <div class="row box_add_1">
                                                        <div class="col-md-12 mt-5 mb-3 text-left remove_div">
                                                            <i class="remover fa fa-close" title="Remove"></i>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group" id="photos">
                                                                {{Form::label('photo_card', translateText('تصویر',lang_admin()))}}
                                                                {{Form::file('photo_card[]', array('class' => 'form-control','accept' => '.jpg,.jpeg,.png,.webp'))}}
                                                            </div>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small>
                                                            </p>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small>
                                                            </p>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('در صورتی که دارید وارد کنید.',lang_admin())}}</small>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-12">
                                                    <button type="button" class="btn btn-primary new_btn_1 w-100">
                                                        New Business Card
                                                    </button>
                                                </div>
                                                {{--                                                Business License--}}
                                                <div class="col-12">
                                                    <hr/>
                                                    <h3 class="text-center">Business License</h3>
                                                </div>
                                                <div class="container-fluid append_add_2">
                                                    <div class="row box_add_2">
                                                        <div class="col-md-12 mt-5 mb-3 text-left remove_div">
                                                            <i class="remover fa fa-close" title="Remove"></i>
                                                        </div>
                                                        <div class="col-lg-4 col-md-6">
                                                            <div class="form-group">
                                                                {{Form::label('license_number', 'License Number')}}
                                                                {{Form::text('license_number[]', null, array('class' => 'form-control slug_input d-ltr text-left'))}}
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group" id="photos">
                                                                {{Form::label('photo_license', translateText('تصویر',lang_admin()))}}
                                                                {{Form::file('photo_license[]', array('class' => 'form-control','accept' => '.jpg,.jpeg,.png,.webp'))}}
                                                            </div>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small>
                                                            </p>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small>
                                                            </p>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('در صورتی که دارید وارد کنید.',lang_admin())}}</small>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-12">
                                                    <button type="button" class="btn btn-primary new_btn_2 w-100">
                                                        New Business License
                                                    </button>
                                                </div>
{{--                                                دیگر گواهینامه ها--}}
                                                <div class="col-12">
                                                    <hr/>
                                                    <h3 class="text-center">{{translateText('دیگر گواهینامه ها',lang_admin())}}</h3>
                                                </div>
                                                <div class="container-fluid append_add_3">
                                                    <div class="row box_add_3">
                                                        <div class="col-md-12 mt-5 mb-3 text-left remove_div">
                                                            <i class="remover fa fa-close" title="Remove"></i>
                                                        </div>
                                                        <div class="col-lg-4 col-md-6">
                                                            <div class="form-group">
                                                                {{Form::label('type_title', translateText('حقیقی/حقوقی',lang_admin()))}}
                                                                {{ Form::select('type_title[]', ['company_document'=>translateText('حقوقی',lang_admin()),'personal_identification'=>translateText('حقیقی',lang_admin())], null, array('class' => 'form-control')) }}
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-6">
                                                            <div class="form-group">
                                                                {{Form::label('type_id', translateText('نوع سند',lang_admin()))}}
                                                                {{ Form::select('type_id[]', array_pluck($type_certificate, 'title', 'id'), null, array('class' => 'form-control')) }}
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-6">
                                                            <div class="form-group">
                                                                {{Form::label('tax_id', 'Tax Id')}}
                                                                {{Form::text('tax_id[]', null, array('class' => 'form-control slug_input d-ltr text-left'))}}
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group" id="photos">
                                                                {{Form::label('photo', translateText('تصویر',lang_admin()))}}
                                                                {{Form::file('photo[]', array('class' => 'form-control','accept' => '.jpg,.jpeg,.png,.webp'))}}
                                                            </div>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small>
                                                            </p>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small>
                                                            </p>
                                                            <p class="text-danger">
                                                                _<small>{{translateText('در صورتی که دارید وارد کنید.',lang_admin())}}</small>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-12">
                                                    <button type="button" class="btn btn-primary w-100 new_btn_3">
                                                        + New Certificate
                                                    </button>
                                                </div>
                                            @endif

                                        <div class="col-md-12 text-left">
                                            <hr/>
                                            {{Form::submit(translateText('ثبت',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                                        </div>
                                    </div>
                                    {!! Form::close() !!}
                                </div>
                            @endcan
                        </div>
                    </div>
                </div>
                <!-- End Row-->
            </div>
        </div>
    </div>
@endsection
@section('in_tag_script')
    <script>
        $(document).ready(function () {
            $('.new_btn_1').click(function () {
                var append_add_1 = $('.append_add_1').find('.box_add_1').first().html();
                $('.append_add_1').append('<div class="row box_add_1">' + append_add_1 + '</div>');
                remover();
            });
            $('.remover').click(function () {
                $(this).parent().parent().remove();
            });
        });
        $(document).ready(function () {
            $('.new_btn_2').click(function () {
                var append_add_2 = $('.append_add_2').find('.box_add_2').first().html();
                $('.append_add_2').append('<div class="row box_add_2">' + append_add_2 + '</div>');
                remover();
            });
            $('.remover').click(function () {
                $(this).parent().parent().remove();
            });
        });
        $(document).ready(function () {
            $('.new_btn_3').click(function () {
                var append_add_3 = $('.append_add_3').find('.box_add_3').first().html();
                $('.append_add_3').append('<div class="row box_add_3">' + append_add_3 + '</div>');
                remover();
            });
            $('.remover').click(function () {
                $(this).parent().parent().remove();
            });
        });
        function remover() {
            $('.remover').click(function () {
                $(this).parent().parent().remove();
            });
        }
    </script>
@endsection


