@extends('admin.layouts.app',['tbl'=>true])

@section('content')
  <div class="row mt-5">
    <div class="col-xl-12 col-md-12 col-lg-12">
      <div class="card">
        <div class="card-header  border-0">
          <h4 class="w-100">
            {{$title}}
            <a href="{{route('admin.select.create',['type'=>$type])}}" class="btn btn-primary float-left">افزودن</a>
          </h4>
        </div>

        <div class="card-body">
          <div class="table-responsive">
            <table class="table  table-vcenter text-wrap table-bordered border-bottom" id="tbl_1">
              <thead>
              <tr>
                <th class="border-bottom-0">#</th>
                <th class="border-bottom-0">{{translateText('عنوان',lang_admin())}}</th>
                @can('select_status')
                  <th class="border-bottom-0">{{translateText('وضعیت',lang_admin())}}</th>
                @endcan
                @canany(['select_edit','select_delete'])
                  <th class="border-bottom-0">{{translateText('عملیات',lang_admin())}}</th>
                @endcan
              </tr>
              </thead>
              <tbody>
              @foreach($items as $key=>$item)
                <tr>
                  <td>{{$key+1}}</td>
                  <td>{{$item->title}}</td>
                  @can('select_status')
                    <td>
                      @if($item->status=='active')
                        <span class="text-success ml-2">{{translateText('فعال',lang_admin())}}</span>
                        <a href="{{route('admin.select.status',[$item->id,'status','pending'])}}">
                          <i class="fa fa-close text-danger"></i>
                        </a>
                      @else
                        <span class="text-danger ml-2">{{translateText('غیر فعال',lang_admin())}}</span>
                        <a href="{{route('admin.select.status',[$item->id,'status','active'])}}">
                          <i class="fa fa-check text-success"></i>
                        </a>
                      @endif
                    </td>
                  @endcan
                  @canany(['select_edit','select_delete'])
                    <td>
                      <div class="d-flex">
                        @can('select_edit')
                          <a href="{{route('admin.select.edit',$item->id)}}"
                             class="action-btns1">
                            <i class="feather feather-edit-2  text-success"
                               data-toggle="tooltip" data-placement="top"
                               title="{{translateText('ویرایش',lang_admin())}}"></i>
                          </a>
                        @endcan
                        @can('select_delete')
                          {!! Form::open(['method' => 'DELETE', 'route' => ['admin.select.destroy', $item->id] ]) !!}
                          <button class="action-btns1" data-toggle="tooltip"
                                  data-placement="top" title="{{translateText('حذف',lang_admin())}}"
                                  onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                            <i class="feather feather-trash-2 text-danger"></i>
                          </button>
                          {!! Form::close() !!}
                        @endcan
                      </div>
                    </td>
                  @endcan
                </tr>
              @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>


@endsection
