@extends('admin.layouts.app',['tbl'=>true])

@section('content')
    <style>
        table *
        {
            /*font-size: 13px;*/
        }
        table.dataTable tbody td, table.dataTable thead td
        {
            padding: 6px!important;
        }
        table.dataTable tbody th, table.dataTable thead th
        {
            padding: 10px 6px!important;
            /*font-size: 13px!important;*/
        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                        @can('slider_create')
                        <a href="{{route('admin.slider.create')}}" class="btn btn-primary float-left">{{translateText('افزودن',lang_admin())}}</a>
                        @endcan
                    </h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0">{{translateText('تصویر',lang_admin())}}</th>
                                @canany(['slider_edit','slider_delete'])
                                <th class="border-bottom-0">{{translateText('عملیات',lang_admin())}}</th>
                                @endcan    
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>
                                        @if($item->photo && is_file($item->photo->path))
                                            <img src="{{url($item->photo->path)}}" height="100px">
                                        @else
                                            __
                                        @endif
                                    </td>
                                    @canany(['slider_edit','slider_delete'])
                                        <td>
                                            <div class="d-flex">
                                                @can('slider_edit')
                                                    <a href="{{route('admin.slider.edit',$item->id)}}"
                                                       class="action-btns1">
                                                        <i class="feather feather-edit-2  text-success"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="{{translateText('ویرایش',lang_admin())}}"></i>
                                                    </a>
                                                @endcan
                                                    @can('slider_delete')
                                                    {!! Form::open(['method' => 'DELETE', 'route' => ['admin.slider.destroy', $item->id] ]) !!}
                                                    <button class="action-btns1" data-toggle="tooltip"
                                                            data-placement="top" title="{{translateText('حذف',lang_admin())}}"
                                                            onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                                                        <i class="feather feather-trash-2 text-danger"></i>
                                                    </button>
                                                    {!! Form::close() !!}
                                                    @endcan
                                            </div>
                                        </td>
                                    @endcan
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
