@extends('admin.layouts.app',['req'=>true,'date_picker'=>true,'file_upload'=>true])

@section('content')
  <div class="row mt-5">
    <div class="col-xl-12 col-md-12 col-lg-12">
      <div class="card">
        <div class="card-header  border-0">
          <h4 class="card-title">
            {{$title}}
          </h4>
        </div>
        <hr>

        <div class="card-body">
          {{ Form::open(array('route' => 'admin.upload.store', 'method' => 'POST','id'=>'form_req','files'=>true)) }}
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                {{Form::label('title', translateText('عنوان',lang_admin()).' *')}}
                {{Form::text('title', null, array('class' => 'form-control','required'))}}
              </div>
            </div>
            <div class="col-md-12">
              <div class="form-group">
                <div class="form-group">
                  {{Form::label('file', translateText('فایل',lang_admin()).' *')}}
                  <div class="input-group mb-5 file-browser">
                    <input type="text" class="form-control browse-file"
                           placeholder="{{translateText('فایل خود را جهت آپلود انتخاب کنید',lang_admin())}}" readonly>
                    <label class="input-group-append">
												<span class="btn btn-primary">
													{{translateText('انتخاب',lang_admin())}}
                                                    {{Form::file('file', array('class' => 'file-browserinput d-none','accept' => '*.*','required'))}}
												</span>
                    </label>
                  </div>

                </div>
              </div>

              <p class="text-danger">_<small>{{translateText('حداکثر حجم 50Mb می باشد',lang_admin())}}</small></p>
            </div>

            <div class="col-md-12 text-left">
              <hr/>
              {{Form::submit(translateText('افزودن',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
            </div>
          </div>
          {{ Form::close() }}
        </div>
      </div>
    </div>
  </div>


@endsection
