@extends('admin.layouts.app',['tbl'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                        @can('upload_create')
                        <a href="{{route('admin.upload.create')}}" class="btn btn-primary float-left">{{translateText('افزودن',lang_admin())}}</a>
                            @endcan
                    </h4>
                </div>

                <div class="card-body">
                    <div class="col-12">
                        <div class="alert alert-info text-center">
                            {!! translateText('           برای کپی کردن لینک رو کلمه "لینک" راست کلیک سپس روی <span dir="ltr"> "copy link address" </span> کلیک کنید',lang_admin()) !!}
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0">{{translateText('عنوان',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('لینک',lang_admin())}}</th>
                                @can('upload_delete')
                                <th class="border-bottom-0">{{translateText('عملیات',lang_admin())}}</th>
                                    @endcan
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>{{$item->title}}</td>
                                    <td><a href="{{url($item->file)}}" target="_blank">{{translateText('لینک',lang_admin())}}</a></td>
                                    @can('upload_delete')
                                    <td>
                                        <div class="d-flex">
                                            {!! Form::open(['method' => 'DELETE', 'route' => ['admin.upload.destroy', $item->id] ]) !!}
                                            <button class="action-btns1" data-toggle="tooltip"
                                                    data-placement="top" title="{{translateText('حذف',lang_admin())}}"
                                                    onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')">
                                                <i class="feather feather-trash-2 text-danger"></i>
                                            </button>
                                            {!! Form::close() !!}
                                        </div>
                                    </td>
                                        @endcan
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
