@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item,array('route' => array('admin.user.update',$item->id),'id'=>'form_req', 'method' => 'PATCH','files'=>true)) }}
                    {{Form::hidden('id', $item->id)}}
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('name', translateText('نام',lang_admin()).' *')}}
                                {{Form::text('name',null, array('class' => 'form-control','required'))}}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('role_name', translateText('سطح دسترسی',lang_admin()).' * ')}}
                                {{ Form::select('role_name', array_pluck($roles,'title','name',['',translateText('انتخاب کنید',lang_admin())]), $item->roles->first()->name, array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>translateText('انتخاب کنید',lang_admin()),'required')) }}
                            </div>
                        </div>
                        <div class="col-md-12">
                            {{Form::label('info', translateText('درباره کاربر',lang_admin()))}}
                            <div class="form-group form-group-post">
                                {{Form::textarea('info', null, array('class' => 'form-control textarea_'.dir_admin()))}}
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{Form::label('username', translateText('نام کاربرِی/ایمیل',lang_admin()).' * ')}}
                                {{Form::email('username',$item->username, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{Form::label('password', translateText('رمز عبور',lang_admin()))}}
                                {{Form::password('password', array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداقل 6 کاراکتر',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{Form::label('password_confirmation', translateText('تکرار رمز عبور',lang_admin()))}}
                                {{Form::password('password_confirmation', array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداقل 6 کاراکتر',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('رمز عبور با تکرار برابر باشد',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('photo', translateText('تصویر',lang_admin()))}}
                                {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.png,.webp','id' => $item->photo ? $item->photo->id : 0,'data-default-file'=> $item->photo && is_file($item->photo->path)?url($item->photo->path):null))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 256KB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('بهترین سایز تصویر عرض 120 پیکسل در ارتفاع 150 پیکسل می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small></p>
                        </div>

                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('ویرایش',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </div>

@endsection
@push('in_tag_script')

@endpush
