@extends('front.layouts.front')
@section('styles')
    <style>
        .app-content {
            margin-right: unset !important;
            margin-top: 20px !important;
        }

        footer.footer {
            padding: unset;
        }

        .bg_image {
            background: url('{{login_bg()}}');
            background-repeat: no-repeat;
            background-size: cover;
        }

        .gmail_icon {
            width: 60px;
        }

    </style>

@endsection
@section('body')
    <div class="py-5 bg_image">
        <div class="container">
            <div class="row justify-content-end">
                <div class="col-lg-4 col-md-6">

                    <div class="card">
                        <div class="card-header">{{read_lang_word('register-title')}} <strong>{{ucwords(session('role_id'))}}</strong></div>
                        <div class="card-body position-relative">
                            <div class="loading_full d-none">
                                <div class="loader"></div>
                            </div>
                            <form>
                                <div class="form-group">
                                    <label for="email"
                                           class="col-form-label py-0">{{read_lang_word('login-email')}} *</label>
                                    <input id="username" type="email"
                                           class="form-control d-ltr text-left @error('username') is-invalid @enderror"
                                           name="username" value="{{ old('username') }}" required
                                           autocomplete="username" autofocus>
                                </div>
                                <div class="form-group mt-3 d-none level2">
                                    <label for="verify_code"
                                           class="col-form-label py-0">{{read_lang_word('login-verify-code')}} *</label>
                                    <input id="verify_code" type="number"
                                           class="form-control d-ltr text-left @error('verify_code') is-invalid @enderror"
                                           name="verify_code" value="{{ old('verify_code') }}" required>
                                    <a class="py-2 d-block w-100 level2" href="javascript:void(0)" data-url="{{route('front.register.send.mail')}}" id="level2_resend">
                                        {{read_lang_word('login-resend-verify')}}
                                    </a>
                                </div>
{{--                                level3--}}
                                <div class="form-group mt-3 d-none level3">
                                    <label for="name"
                                           class="col-form-label py-0">{{read_lang_word('login-name')}} *</label>
                                    <input id="name" type="text"
                                           class="form-control d-ltr text-left @error('name') is-invalid @enderror"
                                           name="name" value="{{ old('name') }}" required>
                                </div>
                                <div class="form-group mt-3 d-none level3">
                                    <label for="password"
                                           class="col-form-label py-0">{{read_lang_word('login-password')}} *</label>
                                    <input id="password" type="password"
                                           class="form-control d-ltr text-left @error('password') is-invalid @enderror"
                                           name="password" required autocomplete="current-password">
                                </div>
                                <div class="form-group mt-3 d-none level3">
                                    <label for="password_confirmation"
                                           class="col-form-label py-0">{{read_lang_word('login-password-confirm')}} *</label>
                                    <input id="password_confirmation" type="password"
                                           class="form-control d-ltr text-left @error('password') is-invalid @enderror"
                                           name="password_confirmation" required autocomplete="current-password">
                                </div>


                                <div class="form-group mt-3">
                                    <button type="button" class="btn btn-primary w-100 level1" data-url="{{route('front.register.send.mail')}}" id="level2_next">
                                        {{read_lang_word('login-verify-send')}}
                                    </button>
                                    <button type="button" class="btn btn-primary w-100 d-none level2" data-url="{{route('front.register.verify.mail')}}" id="level3_next">
                                        {{read_lang_word('login-verify-btn')}}
                                    </button>
                                    <button type="button" class="btn btn-primary mt-2 w-100 d-none level3" data-url="{{route('front.register.end')}}" id="register_end">
                                        {{read_lang_word('login-register')}}
                                    </button>
                                    <button type="button" class="btn btn-secondary w-100 mt-2 d-none level2_3" data-url="{{route('front.register.clear.mail')}}" id="level1_back">
                                        {{read_lang_word('login-change-mail')}}
                                    </button>
                                    <a class="btn btn-secondary mt-2 w-100 level1" href="{{route('login')}}">
                                        {{read_lang_word('login-btn')}}
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
