@extends('front.layouts.front')
@section('styles') @endsection
@section('body')
  @if(count($items))
    <!--blog section start-->
    <section class="blog-section pt-120 overflow-hidden pb-120">
      <div class="container">
        <div class="blog-card-wrapper mt-5">
          <div class="row g-4 justify-content-center">
            @foreach($items as $item)
            <div class="col-xl-3 col-lg-4 col-md-6 col-sm-10 px-1">
              @include('front.blog.includes.card',['item'=>$item])
            </div>
            @endforeach
              <div class="col-12 mt-5 paginate-div text-center">
                {{$items->appends(Request::except('page'))->links("cpag.custom")}}
              </div>
          </div>
        </div>
      </div>
    </section>
    <!--blog section end-->
  @else
    <div class="col-12 alert alert-danger text-center">
      Not Found Items
    </div>
  @endif
@endsection
@section('scripts') @endsection
