@extends('front.layouts.front')
@section('styles') @endsection
@section('body')
    <!--contact section start-->
    <section class="contact-section ptb-50 bg-white">
        <div class="container contact-info">
            @foreach($items as $item)
                <div class="row mb-5">
                    <div class="col-12">
                        <h2 class="text-center">{{read_lang($item,'title')}}</h2>
                        <hr class="my-4"/>
                    </div>
                    @if(!blank($item->phone) && count(explode(',',$item->phone)))
                        <div class="col-lg-3 col-md-4 col-sm-6 mx-auto text-center bg-white p-3">
                            <span class="icon-wrapper line-height-48px rounded bg-light-primary rounded-circle flex-shrink-0"><i
                                        class="fa fa-phone"></i></span>
                            @foreach(explode(',',$item->phone) as $key=>$phone)
                                <br/>
                                <div class="{{dir_set()=='ltr'?'ms-3':'me-3'}} info-content">
                                    <a href="tel:{{str_replace([' ','+'],'',$phone)}}" dir="ltr" target="_blank"
                                       rel="nofollow noopener noreferrer">{{$phone}}</a>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    @if(!blank($item->mobile) && count(explode(',',$item->mobile)))
                        <div class="col-lg-3 col-md-4 col-sm-6 mx-auto text-center bg-white p-3">
                            <span class="icon-wrapper line-height-48px rounded bg-light-primary rounded-circle flex-shrink-0"><i
                                        class="fa fa-mobile"></i></span>
                            @foreach(explode(',',$item->mobile) as $key=>$mobile)
                                <br/>
                                <div class="{{dir_set()=='ltr'?'ms-3':'me-3'}} info-content">
                                    <a href="tel:{{str_replace([' ','+'],'',$mobile)}}" dir="ltr" target="_blank"
                                       rel="nofollow noopener noreferrer">{{$mobile}}</a>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    @if(!blank($item->fax) && count(explode(',',$item->fax)))
                        <div class="col-lg-3 col-md-4 col-sm-6 mx-auto text-center bg-white p-3">
                            <span class="icon-wrapper line-height-48px rounded bg-light-primary rounded-circle flex-shrink-0"><i
                                        class="fa fa-fax"></i></span>
                            @foreach(explode(',',$item->fax) as $key=>$fax)
                                <br/>
                                <div class="{{dir_set()=='ltr'?'ms-3':'me-3'}} info-content">
                                    <a href="tel:{{str_replace([' ','+'],'',$fax)}}" dir="ltr" target="_blank"
                                       rel="nofollow noopener noreferrer">{{$fax}}</a>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    @if(!blank($item->email) && count(explode(',',$item->email)))
                        <div class="col-lg-3 col-md-4 col-sm-6 mx-auto text-center bg-white p-3">
                            <span class="icon-wrapper line-height-48px rounded bg-light-primary rounded-circle flex-shrink-0"><i
                                        class="fa-regular fa-envelope"></i></span>
                            @foreach(explode(',',$item->email) as $key=>$email)
                                <br/>
                                <div class="{{dir_set()=='ltr'?'ms-3':'me-3'}} info-content">
                                    <a href="maito:{{str_replace([' ','+'],'',$email)}}" dir="ltr" target="_blank"
                                       rel="nofollow noopener noreferrer">{{$email}}</a>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    <div class="col-md-12 mt-5 px-md-5 px-2">
                        <p>
                            <span class="icon-wrapper rounded bg-light-primary rounded-circle flex-shrink-0"><i
                                        class="fa fa-location-arrow"></i></span>
                            {{read_lang($item,'address')}}
                        </p>
                        <p>
                            <span class="icon-wrapper rounded bg-light-primary rounded-circle flex-shrink-0"><i
                                        class="fa fa-clock"></i></span>
                            {{read_lang($item,'time')}}
                        </p>
                    </div>
                    <div class="col-md-12 mt-5">
                        @if(!blank($item->address_iframe))
                            <!--map area started-->
                            <div class="map-area h-200px">
                                <iframe src="{{$item->address_iframe}}" width="100%" height="200" style="border:0;" allowfullscreen=""
                                        loading="lazy"></iframe>
                            </div>
                        @endif
                    </div>
                </div>
            @endforeach

{{--            <div class="row">--}}

{{--                <div class="col-xl-8">--}}
{{--                    <div class="contact-form-area bg-white rounded">--}}
{{--                        <h4 class="mb-3">{{read_lang($item,'title')}}</h4>--}}
{{--                        <hr/>--}}
{{--                        <form action="{{route('front.contact.us.post')}}" class="ct-form-wrapper mt-3" method="post"--}}
{{--                              id="form_req_search_form">--}}
{{--                            @csrf--}}
{{--                            <div class="row g-4">--}}
{{--                                <div class="col-sm-6">--}}
{{--                                    <div class="input-field">--}}
{{--                                        <label class="fw-semibold text-secondary mb-1">{{read_lang_word('name')}}--}}
{{--                                            *</label>--}}
{{--                                        <input type="text" placeholder="{{read_lang_word('name')}}" name="name"--}}
{{--                                               value="{{old('name')}}" class="border w-100 rounded" required>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                                <div class="col-sm-6">--}}
{{--                                    <div class="input-field">--}}
{{--                                        <label class="fw-semibold text-secondary mb-1">{{read_lang_word('email')}}--}}
{{--                                            *</label>--}}
{{--                                        <input type="email" placeholder="{{read_lang_word('email')}}" name="email"--}}
{{--                                               value="{{old('email')}}" class="border w-100 rounded text-start"--}}
{{--                                               dir="ltr" required>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                                <div class="col-sm-6">--}}
{{--                                    <div class="input-field">--}}
{{--                                        <label class="fw-semibold text-secondary mb-1">{{read_lang_word('phone')}}</label>--}}
{{--                                        <input type="tel" placeholder="{{read_lang_word('phone')}}" name="phone"--}}
{{--                                               value="{{old('phone')}}" class="border w-100 rounded text-start"--}}
{{--                                               dir="ltr">--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                                <div class="col-sm-6">--}}
{{--                                    <div class="input-field">--}}
{{--                                        <label class="fw-semibold text-secondary mb-1">{{read_lang_word('issue')}}--}}
{{--                                            *</label>--}}
{{--                                        <input type="tel" placeholder="{{read_lang_word('issue')}}" name="subject"--}}
{{--                                               value="{{old('subject')}}" class="border w-100 rounded" required>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                                <div class="col-sm-12">--}}
{{--                                    <div class="input-field">--}}
{{--                                        <label class="fw-semibold text-secondary mb-1">{{read_lang_word('msg-text')}}--}}
{{--                                            *</label>--}}
{{--                                        <textarea placeholder="{{read_lang_word('msg-text')}}"--}}
{{--                                                  class="border w-100 rounded" name="message" rows="5"--}}
{{--                                                  required>{{old('message')}}</textarea>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                                <div class="col-sm-6 mx-auto">--}}
{{--                                    <div class="input-field">--}}
{{--                                        <label class="fw-semibold text-secondary mb-1">{{read_lang_word('captcha')}}--}}
{{--                                            *</label>--}}
{{--                                        <img src="{{url(captcha())}}" class="m-auto captcha_img d-block" width="80">--}}
{{--                                        <input type="number" placeholder="{{read_lang_word('captcha')}}" name="captcha"--}}
{{--                                               value="" class="border captcha_input w-100 rounded text-center" required>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </div>--}}

{{--                            <button class="btn btn-primary btn-md mt-4"--}}
{{--                                    type="submit">{{read_lang_word('submit-form')}}</button>--}}
{{--                        </form>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--                <div class="col-xl-4">--}}
{{--                    <div class="contact-sidebar-widget py-5 px-4 bg-white rounded mt-5 mt-xl-0">--}}
{{--                        <h4 class="mb-4">{{read_lang_word('r_title')}}</h4>--}}
{{--                        <ul class="fs-md">--}}
{{--                            <li class="fw-500"><strong class="fw-bold text-secondary">{{read_lang_word('address')}}--}}
{{--                                    : </strong>{{read_lang($item,'address')}}</li>--}}
{{--                        </ul>--}}
{{--                        <hr class="mt-4 mb-4">--}}
{{--                        <ul class="contact-info">--}}
{{--                            @if(!blank($item->phone) && count(explode(',',$item->phone)))--}}
{{--                                @foreach(explode(',',$item->phone) as $key=>$phone)--}}
{{--                                    <li class="d-flex align-items-center {{$key>0?'mt-0':''}}">--}}
{{--                                        <span class="icon-wrapper d-flex align-items-center justify-content-center rounded bg-light-primary rounded-circle flex-shrink-0"><i--}}
{{--                                                    class="fa fa-phone"></i></span>--}}
{{--                                        <div class="{{dir_set()=='ltr'?'ms-3':'me-3'}} info-content">--}}
{{--                                            <a href="tel:{{str_replace([' ','+'],'',$phone)}}" dir="ltr" target="_blank"--}}
{{--                                               rel="nofollow noopener noreferrer">{{$phone}}</a>--}}
{{--                                        </div>--}}
{{--                                    </li>--}}
{{--                                @endforeach--}}
{{--                            @endif--}}
{{--                            @if(!blank($item->mobile) && count(explode(',',$item->mobile)))--}}
{{--                                @foreach(explode(',',$item->mobile) as $key=>$mobile)--}}
{{--                                    <li class="d-flex align-items-center {{$key>0?'mt-0':''}}">--}}
{{--                                        <span class="icon-wrapper d-flex align-items-center justify-content-center rounded bg-light-primary rounded-circle flex-shrink-0"><i--}}
{{--                                                    class="fa fa-mobile"></i></span>--}}
{{--                                        <div class="{{dir_set()=='ltr'?'ms-3':'me-3'}} info-content">--}}
{{--                                            <a href="tel:{{str_replace([' ','+'],'',$mobile)}}" dir="ltr"--}}
{{--                                               target="_blank" rel="nofollow noopener noreferrer">{{$mobile}}</a>--}}
{{--                                        </div>--}}
{{--                                    </li>--}}
{{--                                @endforeach--}}
{{--                            @endif--}}
{{--                            @if(!blank($item->fax) && count(explode(',',$item->fax)))--}}
{{--                                @foreach(explode(',',$item->fax) as $key=>$fax)--}}
{{--                                    <li class="d-flex align-items-center {{$key>0?'mt-0':''}}">--}}
{{--                                        <span class="icon-wrapper d-flex align-items-center justify-content-center rounded bg-light-primary rounded-circle flex-shrink-0"><i--}}
{{--                                                    class="fa fa-fax"></i></span>--}}
{{--                                        <div class="{{dir_set()=='ltr'?'ms-3':'me-3'}} info-content">--}}
{{--                                            <a href="tel:{{str_replace([' ','+'],'',$fax)}}" dir="ltr" target="_blank"--}}
{{--                                               rel="nofollow noopener noreferrer">{{$fax}}</a>--}}
{{--                                        </div>--}}
{{--                                    </li>--}}
{{--                                @endforeach--}}
{{--                            @endif--}}
{{--                            @if(!blank($item->whatsapp) && count(explode(',',$item->whatsapp)))--}}
{{--                                @foreach(explode(',',$item->whatsapp) as $key=>$whatsapp)--}}
{{--                                    <li class="d-flex align-items-center {{$key>0?'mt-0':''}}">--}}
{{--                                        <span class="icon-wrapper d-flex align-items-center justify-content-center rounded bg-light-primary rounded-circle flex-shrink-0"><i--}}
{{--                                                    class="fa-brands fa-whatsapp"></i></span>--}}
{{--                                        <div class="{{dir_set()=='ltr'?'ms-3':'me-3'}} info-content">--}}
{{--                                            <a href="https://api.whatsapp.com/send?phone={{str_replace([' ','+'],'',$whatsapp)}}"--}}
{{--                                               dir="ltr" target="_blank"--}}
{{--                                               rel="nofollow noopener noreferrer">{{$whatsapp}}</a>--}}
{{--                                        </div>--}}
{{--                                    </li>--}}
{{--                                @endforeach--}}
{{--                            @endif--}}
{{--                            @if(!blank($item->email) && count(explode(',',$item->email)))--}}
{{--                                @foreach(explode(',',$item->email) as $key=>$email)--}}
{{--                                    <li class="d-flex align-items-center {{$key>0?'mt-0':''}}">--}}
{{--                                        <span class="icon-wrapper d-flex align-items-center justify-content-center rounded bg-light-primary rounded-circle flex-shrink-0"><i--}}
{{--                                                    class="fa-regular fa-envelope"></i></span>--}}
{{--                                        <div class="{{dir_set()=='ltr'?'ms-3':'me-3'}} info-content">--}}
{{--                                            <a href="maito:{{str_replace([' ','+'],'',$email)}}" dir="ltr"--}}
{{--                                               target="_blank" rel="nofollow noopener noreferrer">{{$email}}</a>--}}
{{--                                        </div>--}}
{{--                                    </li>--}}
{{--                                @endforeach--}}
{{--                            @endif--}}
{{--                        </ul>--}}
{{--                        @if($item->telegram || $item->linkedin || $item->instagram || $item->facebook || $item->twitter || $item->youtube || $item->whatsapp_group)--}}
{{--                            <hr class="mt-30 mb-40">--}}
{{--                            <h6 class="mb-3">{{read_lang_word('social')}}</h6>--}}
{{--                            <div class="contact-social">--}}
{{--                                @if($item->telegram)--}}
{{--                                    <a href="{{$item->telegram}}" target="_blank" rel="nofollow noopener noreferrer"><i--}}
{{--                                                class="fab fa-telegram"></i></a>--}}
{{--                                @endif--}}
{{--                                @if($item->instagram)--}}
{{--                                    <a href="{{$item->instagram}}" target="_blank" rel="nofollow noopener noreferrer"><i--}}
{{--                                                class="fab fa-instagram"></i></a>--}}
{{--                                @endif--}}
{{--                                @if($item->facebook)--}}
{{--                                    <a href="{{$item->facebook}}" target="_blank" rel="nofollow noopener noreferrer"><i--}}
{{--                                                class="fab fa-facebook-f"></i></a>--}}
{{--                                @endif--}}
{{--                                @if($item->twitter)--}}
{{--                                    <a href="{{$item->twitter}}" target="_blank" rel="nofollow noopener noreferrer"><i--}}
{{--                                                class="fab fa-twitter"></i></a>--}}
{{--                                @endif--}}
{{--                                @if($item->youtube)--}}
{{--                                    <a href="{{$item->youtube}}" target="_blank" rel="nofollow noopener noreferrer"><i--}}
{{--                                                class="fab fa-youtube"></i></a>--}}
{{--                                @endif--}}
{{--                                @if($item->linkedin)--}}
{{--                                    <a href="{{$item->linkedin}}" target="_blank" rel="nofollow noopener noreferrer"><i--}}
{{--                                                class="fab fa-linkedin"></i></a>--}}
{{--                                @endif--}}
{{--                                @if($item->whatsapp_group)--}}
{{--                                    <a href="{{$item->whatsapp_group}}" target="_blank"--}}
{{--                                       rel="nofollow noopener noreferrer"><i class="fab fa-whatsapp"></i></a>--}}
{{--                                @endif--}}
{{--                            </div>--}}
{{--                        @endif--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--            </div>--}}
        </div>
    </section>
    <!--contact section end-->

{{--    @if(!blank($item->address_iframe))--}}
{{--        <!--map area started-->--}}
{{--        <div class="map-area">--}}
{{--            <iframe src="{{$item->address_iframe}}" width="100%" height="480" style="border:0;" allowfullscreen=""--}}
{{--                    loading="lazy"></iframe>--}}
{{--        </div>--}}
{{--    @endif--}}
@endsection
@section('scripts')
    @include('front.includes.req')
@endsection
