@extends('front.layouts.front')
@section('styles')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.css"/>
@endsection
@section('body')
    <!-- Hero Section -->
    <div class="container-xxl mt-3">
        <div class="row g-3 align-items-stretch">
            <div class="col-xl-3 col-lg-4 col-sm-6 order-sm-1 order-2">
                <div class="categories-widget">
                    <h3 class="widget-title">
                        <i class="fa-solid fa-list"></i>
                        <span>{{ read_lang_word('slider-title-1') }}</span>
                    </h3>
                    <ul class="category-list">
                        @foreach ($cats as $cat)
                            <li>
                                <a href="{{ route('front.product.list', $cat->slug) }}">
                                    <span>{{ read_lang($cat, 'title') }}</span>

                                    @if ($cat->children->count())
                                        <i class="fa-regular fa-chevron-right"></i>
                                    @endif
                                </a>
                                @if ($cat->children->count())
                                    <div class="category-list-dropdown">
                                        <div class="category-list-dropdown-content four-column">
                                            @foreach ($cat->children as $child)
                                                <ul class="sub-category-section">
                                                    <li>
                                                        <span class="sub-category-title">{{ read_lang($child, 'title') }}</span>
                                                    </li>
                                                    @foreach ($child->children as $grandchild)
                                                        <li>
                                                            <a class="sub-category-item"
                                                               href="{{ route('front.product.list', $grandchild->slug) }}">
                                                                {{ read_lang($grandchild, 'title') }}
                                                            </a>
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            @endforeach
                                        </div>
                                        @if ($cat->products_active->take(7)->count() > 0)
                                            <div class="carousel-section">
                                                <div class="swiper header-product-slider">
                                                    <div class="swiper-wrapper">
                                                        @foreach ($cat->products_active->take(7) as $product)
                                                            <div class="swiper-slide">
                                                                <a href="{{ route('front.product.show', $product->slug) }}"
                                                                   class="header-product-item">
                                                                    <img src="{{ $product->photo && is_file($product->photo->path) ? url($product->photo->path) : url('assets/front/product_default.webp') }}"
                                                                         alt="{{ photo_alt($product, 'photo', read_lang($product, 'title')) }}">
                                                                    <span>{{ read_lang($product, 'title') }}</span>
                                                                </a>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                                <!-- Carousel Buttons -->
                                                <div class="swiper-button-next header-product-slider-next"></div>
                                                <div class="swiper-button-prev header-product-slider-prev"></div>
                                            </div>
                                        @endif
                                    </div>
                                @endif
                            </li>
                        @endforeach
                        <li class="all-categories">
                            <a href="{{ route('list.categories') }}">
                                {{ read_lang_word('all-categories') }}
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-xl-6 col-lg-4 order-lg-2 order-0">
                <div class="swiper hero-slider">
                    <div class="swiper-wrapper">
                        @if (count($sliders))
                            @foreach ($sliders as $slider)
                                <div class="swiper-slide">
                                    <img class="lazyload"
                                         data-src="{{ $slider->photo && is_file($slider->photo->path) ? url($slider->photo->path) : url('source/Slıder1.jpg') }}"
                                         @if ($slider->link != '#' || !blank($slider->link)) onclick="document.location = '{{ $slider->link }}'"
                                         @endif alt="{{ photo_alt($slider, 'photo', 'slider') }}"/>
                                    @if($slider->type == 'ad')
                                    <span class="hero-slider-badge">AD</span>
                                    @endif
                                </div>
                            @endforeach
                        @endif
                    </div>
                    <div class="swiper-pagination hero-slider-pagination"></div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-sm-6 order-sm-3 order-3">
                <div class="form-widget-container">
                    <ul class="nav nav-tabs" id="filterTabs" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="suppliers-tab" data-bs-toggle="tab"
                                    data-bs-target="#form-content" type="button" role="tab" aria-controls="suppliers"
                                    aria-selected="true">
                                Suppliers
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="buyers-tab" data-bs-toggle="tab" data-bs-target="#form-content"
                                    type="button" role="tab" aria-controls="buyers" aria-selected="false">
                                Buyers
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="products-tab" data-bs-toggle="tab"
                                    data-bs-target="#form-content" type="button" role="tab" aria-controls="products"
                                    aria-selected="false">
                                Products
                            </button>
                        </li>
                    </ul>

                    <div class="tab-content" id="filterTabsContent">
                        <div class="tab-pane fade show active" id="form-content" role="tabpanel">
                            <form>
                                <div class="mb-2">
                                    <label for="companyType" class="form-label">Company Type</label>
                                    <div class="select-container">
                                        <select id="companyType">
                                            <option selected disabled></option>
                                            <option value="1">Manufacturer</option>
                                            <option value="2">Wholesaler</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="mb-2">
                                    <label for="industry" class="form-label">Industry</label>
                                    <div class="select-container">
                                        <select id="industry">
                                            <option selected disabled></option>
                                            <option value="1">Food & Beverage</option>
                                            <option value="2">Chemical</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="mb-2">
                                    <label for="subIndustry" class="form-label">Sub Industry</label>
                                    <div class="select-container">
                                        <select id="subIndustry">
                                            <option selected disabled></option>
                                            <option value="1">Dairy Products</option>
                                            <option value="2">Personal Care</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="mb-2">
                                    <label for="tradeTerms" class="form-label">Trade Terms</label>
                                    <div class="select-container">
                                        <select id="tradeTerms">
                                            <option selected disabled></option>
                                            <option value="1">FOB</option>
                                            <option value="2">CIF</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-check mb-4">
                                    <input class="form-check-input" type="checkbox" value="" id="verifiedSuppliers">
                                    <label class="form-check-label" for="verifiedSuppliers">
                                        Verified Suppliers
                                    </label>
                                </div>

                                <div class="form-buttons">
                                    <button type="submit" class="default-button">SUBMIT</button>
                                    <button type="reset" class="default-button">RESET</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Of Hero Section -->

    <!-- Cta Section -->
    <div class="container-xxl">
        <div class="row g-3">
            @foreach ($banner1 as $banner)
                <div class="col-md-6">
                    <div class="banner-box">
                        {{-- <a href="{{ $banner->status == 'active' && !blank($banner->link) ? $banner->link : '#' }}"> --}}
                        @if ($banner->status == 'active')
                            <img src="{{ url($banner->photo->path) }}"
                                 alt="{{ photo_alt($banner, 'photo', 'banner') }}">
                        @else
                            <img src="{{ url($banner->photo_default->path) }}"
                                 alt="{{ photo_alt($banner, 'photo_default', 'banner') }}">
                        @endif
                        {{-- </a> --}}
                    </div>
                </div>
            @endforeach
        </div>
    </div>

    <!-- End Of Cta Section -->

    <!-- Products Section -->
    <div class="container-xxl">
        <div class="tab-rotate">
            <ul class="nav nav-tabs flex-column" id="productsTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="new-products-tab" data-bs-toggle="pill"
                            data-bs-target="#new-products" type="button" role="tab" aria-controls="new-products"
                            aria-selected="false">
                        <span>{{ read_lang_word('products-new') }}</span>
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="trend-products-tab" data-bs-toggle="pill"
                            data-bs-target="#trend-products" type="button" role="tab" aria-controls="trend-products"
                            aria-selected="true">
                        <span>{{ read_lang_word('trend-products') }}</span>
                    </button>
                </li>
            </ul>

            <div class="tab-content" id="productsTabsContent">
                <div class="tab-pane fade show active" id="new-products" role="tabpanel"
                     aria-labelledby="new-products-tab">
                    <div class="row g-3">
                        @if (count($products))
                            <!--service section start-->
                            @foreach ($products as $product)
                                <div class="col-md-3 col-6 col-lg-2 col-sm-4">
                                    @include('front.product.includes.card', ['item' => $product])
                                </div>
                            @endforeach
                            <div class="col">
                                <a href="#" class="product-square-card more">
                                    <span>{{ read_lang_word('more') }}</span>
                                    <i class="fa-solid fa-arrow-right"></i>
                                </a>
                            </div>
                            <!--service section end-->
                        @endif

                    </div>
                </div>

                <div class="tab-pane fade" id="trend-products" role="tabpanel" aria-labelledby="trend-products-tab">
                    <div class="row g-3">
                        @if (count($products_top))
                            <!--service section start-->
                            @foreach ($products_top as $product)
                                <div class="col-md-3 col-6 col-lg-2 col-sm-4">
                                    @include('front.product.includes.card', ['item' => $product])
                                </div>
                            @endforeach
                            <div class="col">
                                <a href="#" class="product-square-card more">
                                    <span>{{ read_lang_word('more') }}</span>
                                    <i class="fa-solid fa-arrow-right"></i>
                                </a>
                            </div>
                            <!--service section end-->
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- End Of Products Section -->

    <!-- Cta Section -->
    {{-- <div class="container-xxl">
        <div class="row g-3">
            @foreach ($banner2 as $banner)
                <div class="col-md-6">
                    <div class="banner-box h-auto">
                        <a href="{{ $banner->status == 'active' && !blank($banner->link) ? $banner->link : '#' }}">
                            @if ($banner->status == 'active')
                                <img src="{{ url($banner->photo->path) }}"
                                     alt="{{ photo_alt($banner, 'photo', 'banner') }}">
                            @else
                                <img src="{{ url($banner->photo_default->path) }}"
                                     alt="{{ photo_alt($banner, 'photo_default', 'banner') }}">
                            @endif
                        </a>
                    </div>
                </div>
            @endforeach
        </div>
    </div> --}}
    <div class="container-xxl">
        <div class="row g-3">
            <div class="col-lg-6">
                <div class="banner-box h-100">
                    <img src="{{ url($banner3->first()->photo->path) }}"
                         alt="{{ photo_alt($banner2->first(), 'photo', 'banner') }}">
                </div>
            </div>
            <div class="col-lg-6">
                <form class="section-card flex-column justify-content-between h-100">
                    <div class="section-heading">
                        <div class="section-heading-right-side flex-1">
                            <div class="section-heading-title-box flex-1">
                                <h6 class="section-heading-title flex-1">What Are You Looking For?</h6>
                            </div>
                        </div>

                        <div class="section-heading-left-side">
                            <button class="default-button">
                                Send Request
                            </button>
                        </div>
                    </div>

                    <div class="row g-2">
                        @csrf

                        <div class="col-6">
                            <input type="text" class="form-control error" id="productName" name="product_name"
                                   required="" placeholder="Product Name Or keyword">
                        </div>
                        <div class="col-3">
                            <input type="number" class="form-control" id="requiredQuantity" name="required_quantity"
                                   required="" placeholder="Purchase Quantity">
                        </div>

                        <div class="col-3">
                            <div class="select-container">
                                <select id="selectUnit" name="select_unit" class="form-select" required="">
                                    <option value="" disabled="" selected="">Unit</option>
                                    <option value="American Gallon(s)">American Gallon(s)</option>
                                    <option value="Bag(s)">Bag(s)</option>
                                    <option value="Bale(s)">Bale(s)</option>
                                    <option value="Barrel(s)">Barrel(s)</option>
                                    <option value="Basket(s)">Basket(s)</option>
                                    <option value="Blade(s)">Blade(s)</option>
                                    <option value="Block(s)">Block(s)</option>
                                    <option value="Bolt(s)">Bolt(s)</option>
                                    <option value="Bottle(s)">Bottle(s)</option>
                                    <option value="Box(s)">Box(s)</option>
                                    <option value="British Gallon(s)">British Gallon(s)</option>
                                    <option value="British Horsepower(s)">British Horsepower(s)</option>
                                    <option value="Bullet(s)">Bullet(s)</option>
                                    <option value="Foot(Feet)">Foot(Feet)</option>
                                    <option value="Piece(s)">Piece(s)</option>
                                    <option value="Meter(s)">Meter(s)</option>
                                    <option value="20' Container(s)">20' Container(s)</option>
                                    <option value="40' Container(s)">40' Container(s)</option>
                                    <option value="40' HQ Container(s)">40' HQ Container(s)</option>
                                    <option value="Ream(s)">Ream(s)</option>
                                    <option value="Roll(s)">Roll(s)</option>
                                    <option value="Set(s)">Set(s)</option>
                                    <option value="Square Meter(s)">Square Meter(s)</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-12">
                            <textarea class="form-control" id="productDetails" name="product_details" rows="3"
                                      required="" placeholder="Product Description"></textarea>
                        </div>
                    </div>
                </form>


            </div>
        </div>
    </div>
    <!-- End Of Cta Section -->

    <!-- Service Section -->
    <div class="container-xxl">
        <div class="row g-3">
            <div class="col-lg-9 flex-column">
                <div class="showcase-header">
                    <ul class="nav nav-tabs" id="servicesTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="top-services-tab" data-bs-toggle="tab"
                                    data-bs-target="#top-services" type="button" role="tab" aria-controls="top-services"
                                    aria-selected="true">{{ read_lang_word('top-services') }}
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="top-providers-tab" data-bs-toggle="tab"
                                    data-bs-target="#top-providers" type="button" role="tab"
                                    aria-controls="top-providers" aria-selected="false">
                                {{ read_lang_word('top-service-providers') }}
                            </button>
                        </li>
                    </ul>
                    <a href="#" class="default-button btn-view-more">{{ read_lang_word('view-more') }}</a>
                </div>

                <div class="tab-content" id="servicesTabContent">
                    <div class="tab-pane fade show active" id="top-services" role="tabpanel">
                        <div class="row g-3 h-100">
                            @foreach ($top_product_service as $service)
                                <div class="col-lg-4 col-md-6">
                                    <div class="service-card">
                                        <div class="service-card-header">
                                            <h5 class="service-card-title">{{ read_lang($service, 'title') }}</h5>
                                            <img src="{{ url($service->icon->path ?? 'assets/front/new/icon/default.png') }}">
                                        </div>
                                        <div class="service-card-body">
                                            <div class="service-card-default-content">
                                                <ul>
                                                    @if ($service->c1)
                                                        <li>{{ read_lang($service->c1, 'title') }}</li>
                                                    @endif
                                                    @if ($service->c2)
                                                        <li>{{ read_lang($service->c2, 'title') }}</li>
                                                    @endif
                                                    @if ($service->c3)
                                                        <li>{{ read_lang($service->c3, 'title') }}</li>
                                                    @endif
                                                    @if ($service->c4)
                                                        <li>{{ read_lang($service->c4, 'title') }}</li>
                                                    @endif
                                                </ul>
                                            </div>
                                            <div class="service-card-hover-content">
                                                {{ Str::limit(strip_tags(read_lang($service, 'text') ?? ''), 250, '...') }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <div class="tab-pane fade" id="top-providers" role="tabpanel">
                        <div class="row g-3">
                            @foreach ($topProviders as $provider)
                                @if ($provider->services->count() > 0)
                                    <div class="col-lg-4 col-md-6">
                                        <div class="provider-card">
                                            <div class="provider-card-logo">
                                                <img style="width: 100px"
                                                     src="{{ $provider->photo && is_file($provider->photo->path) ? url($provider->photo->path) : url('assets/front/new/images/sup.webp') }}"
                                                     alt="{{ $provider->name }} Logo">
                                            </div>
                                            <div class="provider-card-image-wrapper">
                                                @if ($provider->services->count() > 0)
                                                    <img style="height:250px; "
                                                         src="{{ $provider->services[0]->photo && is_file($provider->services[0]->photo->path) ? url($provider->services[0]->photo->path) : url($provider->photo->path) }}"
                                                         class="provider-card-main-image"
                                                         alt="{{ read_lang($provider->services[0], 'title') }}">
                                                @else
                                                    <img style="height:250px; " src="{{ url($provider->photo->path) }}"
                                                         class="provider-card-main-image" alt="No Service">
                                                @endif

                                                <div class="provider-card-overlay">
                                                    <p><strong>{{ read_lang_word('company-name') }}
                                                            :</strong> {{ $provider->name }}</p>

                                                    @if ($provider->services->count() > 0)
                                                        <p class="provider-card-main-service">
                                                            <strong>{{ read_lang_word('service-sig') }}:</strong>
                                                            {{ read_lang($provider->services[0], 'title') }}
                                                        </p>
                                                    @endif

                                                    <div class="provider-card-hover-details">
                                                        <h6 class="base-title">{{ read_lang_word('service') }}:</h6>
                                                        <ul>
                                                            @foreach ($provider->services as $service)
                                                                <li>{{ read_lang($service, 'title') }}</li>
                                                            @endforeach
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 flex-column gap-3">
                <div class="form-widget-container p-3">

                    <h3 class="base-title">{{ read_lang_word('what-service-do-you-need') }}</h3>
                    <livewire:front.service.service-form wire:lazy/>

                </div>

                <div class="banner-box h-auto">
                    <img src="{{ url($banner3->first()->photo->path) }}"
                         alt="{{ photo_alt($banner3->first(), 'photo', 'banner') }}">
                </div>
            </div>
        </div>
    </div>
    <!-- End OF Service Section -->

    <!-- Top Suppliers Section -->
    @if (count($suppliers))
        <div class="container-xxl">
            <div class="section-card">
                <div class="section-heading">
                    <div class="section-heading-right-side">
                        <div class="section-heading-title-box">
                            <h6 class="section-heading-title">{{ read_lang_word('top-suppliers2') }}</h6>
                        </div>
                    </div>

                    <div class="section-heading-left-side">
                        <a href="" class="default-button">
                            {{ read_lang_word('view-more') }}
                        </a>
                    </div>
                </div>

                <div class="row g-3">
                    @foreach ($suppliers as $index => $item)
                        @if ($index < 2)
                            @if ($item->products->first())
                                <div class="col-lg-6">
                                    <a href="{{ route('front.supplier.show', $item->u_id) }}" class="supplier-card">
                                        <div class="card-details-section">
                                            <div class="card-logo">
                                                <img src="{{ $item->photo && is_file($item->photo->path) ? url($item->photo->path) : url('assets/front/img/favicon.png') }}"
                                                     alt="{{ photo_alt($item, 'photo', $item->name) }}">
                                            </div>
                                            <ul class="info-list">
                                                <li><strong>Company Name:</strong>
                                                    <span>{{ read_lang($item, $item->company_name == null ? 'name' : 'company_name') }}</span>
                                                </li>
                                                <li><strong>{{ read_lang_word('industry') }}:</strong>
                                                    <span>{{ $item->industry ?? 'N/A' }}</span>
                                                </li>
                                                <li><strong>{{ read_lang_word('company-type') }}:</strong>
                                                    <span>
                                                        @if (count($item->user_business))
                                                            <span>
                                                                @foreach ($item->user_business as $key => $business)
                                                                    {{ $key > 0 ? ', ' : '' }}
                                                                    {{ $business->title }}
                                                                @endforeach
                                                            </span>
                                                        @else
                                                            <span>__</span>
                                                        @endif
                                                    </span>
                                                </li>
                                                <li><strong>Year of Establish:</strong>
                                                    <span>{{ $item->year_established ?? 'N/A' }}</span>
                                                </li>
                                                <li><strong>{{ read_lang_word('verified-supplier') }}:</strong>
                                                    <span>{{ $item->status == 'active' ? 'YES' : 'NO' }}</span>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="card-image-section">
                                            @if ($item->products->first())
                                                <img src="{{ $item->products->first()->photo && is_file($item->products->first()->photo->path) ? url($item->products->first()->photo->path) : url('assets/front/new/images/device.webp') }}"
                                                     alt="{{ $item->name }} Equipment">
                                            @endif
                                        </div>
                                    </a>
                                </div>
                            @endif
                        @else
                            @if ($item->products->first())
                                <div class="col-xl-2 col-lg-3 col-md-4 col-6">
                                    <a href="{{ route('front.supplier.show', $item->u_id) }}" class="supplier-card sm">
                                        <div class="card-logo">
                                            <img src="{{ $item->photo && is_file($item->photo->path) ? url($item->photo->path) : url('assets/front/img/favicon.png') }}"
                                                 alt="{{ photo_alt($item, 'photo', $item->name) }}">
                                        </div>
                                        <ul class="info-list">
                                            <li><strong>Industry:</strong> <span>{{ $item->industry ?? 'N/A' }}</span>
                                            </li>
                                        </ul>
                                        <div class="product-image">
                                            @if ($item->products->first())
                                                <img src="{{ $item->products->first()->photo && is_file($item->products->first()->photo->path) ? url($item->products->first()->photo->path) : url('assets/front/new/images/device.webp') }}"
                                                     alt="{{ $item->name }} Equipment">
                                            @endif
                                        </div>
                                    </a>
                                </div>
                            @endif
                        @endif
                    @endforeach
                </div>
            </div>
        </div>
    @endif
    <!-- End OF Top Suppliers Section -->

    <div class="container-xxl">
        <a href="{{ $banner4->first()->status == 'active' && !blank($banner4->first()->link) ? $banner4->first()->link : '#' }}"
           class="banner-box h-auto">
            <img src="{{ url($banner4->first()->photo->path) }}"
                 alt="{{ photo_alt($banner4->first(), 'photo', 'banner') }}">
        </a>
    </div>

    <div class="container-xxl">
        <div class="row g-3 justify-content-center">
            @if ($exhibitions_smart->count())
                <div class="col-lg-6">

                    <div class="section-card">
                        <div class="section-heading">
                            <div class="section-heading-right-side">
                                <div class="section-heading-title-box">
                                    <h6 class="section-heading-title">{{ read_lang_word('smart-expo') }}</h6>
                                </div>
                            </div>
                            <div class="section-heading-left-side">
                                <a href="#" class="default-button">{{ read_lang_word('view-more') }}</a>
                            </div>
                        </div>

                        <div class="section-content">
                            <div class="row g-4">
                                @foreach ($exhibitions_smart as $index => $exhibition)
                                    @if ($index < 1)
                                        <div class="col-12">
                                            <div class="expo-card">
                                                <div class="expo-card-details">
                                                    <h5 class="expo-title">{{ read_lang($exhibition, 'title') }}</h5>
                                                    <ul class="info-list">
                                                        <li><strong>{{ read_lang_word('industry') }}:</strong>
                                                            <span>{{ read_lang($exhibition, 'industry') }}</span>
                                                        </li>
                                                        <li><strong>{{ read_lang_word('duration') }}:</strong>
                                                            <span>{{ formatDateRange($exhibition->start_date, $exhibition->end_date) }}</span>
                                                        </li>
                                                    </ul>
                                                </div>
                                                <div class="expo-card-banner">
                                                    <img src="{{ url($exhibition->photo->path) }}"
                                                         alt="Subcon Thailand">
                                                </div>
                                            </div>
                                        </div>
                                    @else
                                        <div class="col-lg-4 col-md-6">
                                            <div class="expo-card sm">
                                                <div class="expo-card-image">
                                                    <img src="{{ url($exhibition->photo->path) }}"
                                                         alt="Subcon Thailand">
                                                </div>
                                                <div class="expo-card-details">
                                                    <h6 class="expo-title">{{ read_lang($exhibition, 'title') }}</h6>
                                                    <ul class="info-list">
                                                        <li><strong>{{ read_lang_word('industry') }}:</strong>
                                                            <span>{{ read_lang($exhibition, 'industry') }}</span>
                                                        </li>
                                                        <li><strong>{{ read_lang_word('duration') }}:</strong>
                                                            <span>{{ formatDateRange($exhibition->start_date, $exhibition->end_date) }}</span>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            @if ($exhibitions_online->count())
                <div class="col-lg-6">
                    <div class="section-card">
                        <div class="section-heading">
                            <div class="section-heading-right-side">
                                <div class="section-heading-title-box">
                                    <h6 class="section-heading-title">{{ read_lang_word('online-expo') }}</h6>
                                </div>
                            </div>
                            <div class="section-heading-left-side">
                                <a href="#" class="default-button">{{ read_lang_word('view-more') }}</a>
                            </div>
                        </div>

                        <div class="section-content">
                            <div class="row g-4">
                                @foreach ($exhibitions_online as $index => $exhibition)
                                    @if ($index < 1)
                                        <div class="col-12">
                                            <div class="expo-card">
                                                <div class="expo-card-details">
                                                    <h5 class="expo-title">{{ read_lang($exhibition, 'title') }}</h5>
                                                    <ul class="info-list">
                                                        <li><strong>{{ read_lang_word('industry') }}:</strong>
                                                            <span>{{ read_lang($exhibition, 'industry') }}</span>
                                                        </li>
                                                        <li><strong>{{ read_lang_word('duration') }}:</strong>
                                                            <span>{{ formatDateRange($exhibition->start_date, $exhibition->end_date) }}</span>
                                                        </li>
                                                    </ul>
                                                </div>
                                                <div class="expo-card-banner">
                                                    <img src="{{ url($exhibition->photo->path) }}"
                                                         alt="Subcon Thailand">
                                                </div>
                                            </div>
                                        </div>
                                    @else
                                        <div class="col-lg-4 col-md-6">
                                            <div class="expo-card sm">
                                                <div class="expo-card-image">
                                                    <img src="{{ url($exhibition->photo->path) }}"
                                                         alt="Subcon Thailand">
                                                </div>
                                                <div class="expo-card-details">
                                                    <h6 class="expo-title">{{ read_lang($exhibition, 'title') }}</h6>
                                                    <ul class="info-list">
                                                        <li><strong>{{ read_lang_word('industry') }}:</strong>
                                                            <span>{{ read_lang($exhibition, 'industry') }}</span>
                                                        </li>
                                                        <li><strong>{{ read_lang_word('duration') }}:</strong>
                                                            <span>{{ formatDateRange($exhibition->start_date, $exhibition->end_date) }}</span>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Servceis List Section -->
    @if ($our_service->count())
        <div class="container-xxl">
            <div class="section-card">
                <div class="section-heading">
                    <div class="section-heading-right-side">
                        <div class="section-heading-title-box">
                            <h6 class="section-heading-title">{{ read_lang_word('our-services') }}</h6>
                        </div>
                    </div>

                    <div class="section-heading-left-side">
                        <a href="" class="default-button">
                            {{ read_lang_word('view-more') }}
                        </a>
                    </div>
                </div>
                <div class="row g-3">
                    @foreach ($our_service as $service)
                        <div class="col-lg-3 col-md-6">
                            <div class="service-card">
                                <div class="service-card-header">
                                    <h5 class="service-card-title">{{ read_lang($service, 'title') }}</h5>
                                    <img style="width: 30px"
                                         src="{{ url($service->icon->path ?? 'assets/front/new/icon/default.png') }}">
                                </div>
                                <div class="service-card-body">
                                    <div class="service-card-default-content">
                                        <ul>
                                            @if ($service->c1)
                                                <li>{{ read_lang($service->c1, 'title') }}</li>
                                            @endif
                                            @if ($service->c2)
                                                <li>{{ read_lang($service->c2, 'title') }}</li>
                                            @endif
                                            @if ($service->c3)
                                                <li>{{ read_lang($service->c3, 'title') }}</li>
                                            @endif
                                            @if ($service->c4)
                                                <li>{{ read_lang($service->c4, 'title') }}</li>
                                            @endif
                                        </ul>
                                    </div>
                                    <div class="service-card-hover-content">
                                        {{ Str::limit(strip_tags(read_lang($service, 'text') ?? ''), 250, '...') }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif
    <!-- End Of Servceis List Section -->


    <div class="container-xxl">
        <div class="row g-4">

            <div class="col-xl-6">
                <div class="section-card h-100">
                    <div class="section-heading">
                        <div class="section-heading-right-side">
                            <div class="section-heading-title-box">
                                <h6 class="section-heading-title">{{ read_lang_word('blog') }}</h6>
                            </div>
                        </div>
                        <div class="section-heading-left-side">
                            <a href="#" class="default-button">{{ read_lang_word('view-more') }}</a>
                        </div>
                    </div>
                    <div class="section-content home-blog-section">
                        @foreach ($blogs as $index => $blog)
                            @if ($index < 2)
                                <div class="blog-card">
                                    <div class="card-image">
                                        <img src="{{ $blog->photo && is_file($blog->photo->path) ? url($blog->photo->path) : url('assets/front/img/home1/blog-1.jpg') }}"
                                             alt="{{ photo_alt($blog, 'photo', read_lang($blog, 'title')) }}">
                                        <div class="image-overlay-title">{{ read_lang($blog, 'title') }}</div>
                                    </div>
                                    <div class="card-content">
                                        <h5 class="card-title">{{ read_lang($blog, 'title') }}</h5>
                                        <p class="card-excerpt">{{ Str::limit(strip_tags(read_lang($blog, 'text') ?? ''), 100, '...') }}</p>
                                        <div class="card-meta">
                                            <div class="card-meta-left">
                                                <span>{{ read_lang($blog, 'author') }}</span>
                                                @if (app()->getLocale() == 'fa')
                                                    <span dir="rtl">{{ my_jdate($blog->created_at, 'd F Y') }}</span>
                                                @else
                                                    <span>{{ $blog->created_at->format('M d, Y') }}</span>
                                                @endif
                                            </div>
                                            <a href="{{ route('front.blog.show', [$blog->slug]) }}" class="arrow-link">
                                                <i class="fa-solid fa-arrow-right"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            @endif
                            @if ($index > 1 && $index < 4)
                                <div class="blog-card sm">
                                    <div class="card-image">
                                        <img src="{{ $blog->photo && is_file($blog->photo->path) ? url($blog->photo->path) : url('assets/front/img/home1/blog-1.jpg') }}"
                                             alt="{{ photo_alt($blog, 'photo', read_lang($blog, 'title')) }}">
                                    </div>
                                    <div class="card-content">
                                        <h6 class="card-title">{{ read_lang($blog, 'title') }}</h6>
                                        <div class="card-meta">
                                            <div class="card-meta-left">
                                                <span>{{ read_lang($blog, 'author') }}</span>
                                                @if (app()->getLocale() == 'fa')
                                                    <span dir="rtl">{{ my_jdate($blog->created_at, 'd F Y') }}</span>
                                                @else
                                                    <span>{{ $blog->created_at->format('M d, Y') }}</span>
                                                @endif
                                            </div>
                                            <a href="{{ route('front.blog.show', [$blog->slug]) }}" class="arrow-link">
                                                <i class="fa-solid fa-arrow-right"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>

            <div class="col-xl-6">
                <div class="section-card h-100 d-flex flex-column">
                    <div class="section-heading">
                        <div class="section-heading-right-side">
                            <div class="section-heading-title-box">
                                <h6 class="section-heading-title">{{ read_lang_word('learning-center') }}</h6>
                            </div>
                        </div>
                        <div class="section-heading-left-side">
                            <a href="#" class="default-button">{{ read_lang_word('view-more') }}</a>
                        </div>
                    </div>
                    <div class="section-content video-section">
                        @foreach ($learnings as $index => $learning)
                            @if ($index < 1)
                                <div class="resource-card featured video">
                                    <div class="card-image">
                                        <img src="{{ $learning->photo ? url($learning->photo->path) : url('assets/front/new/images/video.jpg') }}"
                                             alt="{{ $learning->slug }}">

                                        <a href="{{ $learning->link == null ? url($learning->video->path) : $learning->link }}"
                                           class="play-button" data-fancybox>
                                            <i class="fa-solid fa-play"></i>
                                        </a>

                                        <div class="video-overlay-content">
                                            <div class="d-flex justify-content-between">
                                                {{ Str::limit(strip_tags(read_lang($learning, 'text') ?? ''), 150, '...') }}
                                                <a style="width: 20px;height: 10px;" class="default-button" href="#"><i style="font-size: 14px ;"
                                                                                                           class="fa fa-arrow-down fa-rotate-270"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @elseif($index < 3)
                                <div class="resource-card featured video">
                                    <div class="card-image">
                                        <img src="{{ $learning->photo ? url($learning->photo->path) : url('assets/front/new/images/video.jpg') }}"
                                             alt="{{ $learning->title ?? 'Supplier' }}">

                                        <a href="{{ $learning->link == null ? url($learning->video->path) : $learning->link }}"
                                           class="play-button" data-fancybox>
                                            <i class="fa-solid fa-play"></i>
                                        </a>
                                        <div class="video-overlay-content">
                                            <div class="d-flex justify-content-between">
                                                <h5 class="card-title">{{ Str::limit(strip_tags(read_lang($learning, 'text') ?? ''), 50, '...') }}</h5>
                                                <a style="width: 20px;height: 10px;" class="default-button" href="#"><i style="font-size: 14px ;"
                                                                                                                        class="fa fa-arrow-down fa-rotate-270"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>

        </div>
    </div>


    <div class="container-xxl">
        <div class="section-card">
            <div class="section-heading">
                <div class="section-heading-right-side">
                    <div class="section-heading-title-box">
                        <h6 class="section-heading-title">{{ read_lang_word('testimonials') }}</h6>
                    </div>
                    <p>{{ read_lang_word('we-truly-appreciate-your-time-and-support-your-feedback-help-us-grow') }}</p>
                </div>
                <div class="section-heading-left-side">
                    <a href="#" class="default-button">{{ read_lang_word('view-more') }}</a>
                </div>
            </div>

            <div class="section-content">
                <div class="row g-4">

                    <div class="col-lg-4">
                        <div class="gray-card">
                            <div class="flex justify-content-between">
                                <h5 class="base-title">{{ read_lang_word('success-stories') }}</h5>
                                <a href="#" class="view-all-link">{{ read_lang_word('view-all') }}</a>
                            </div>
                            <div class="swiper success-stories-slider">
                                <div class="swiper-wrapper">
                                    @foreach ($stories as $story)
                                        <div class="swiper-slide">
                                            <div class="testimonial-card">
                                                <div class="card-logo"><img src="{{ url($story->photo->path) }}"
                                                                            alt="Glaicmc Logo"></div>
                                                <p class="testimonial-text">{{ Str::limit(strip_tags($story->story ?? ''), 250, '...') }}</p>
                                                <span class="testimonial-author">The story of {{ $story->company_name }} company</span>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                                <div class="swiper-button-prev success-stories-slider-prev"></div>
                                <div class="swiper-button-next success-stories-slider-next"></div>
                            </div>
                            <button type="button" class="default-button" data-bs-toggle="modal"
                                    data-bs-target="#feedbackModal">
                                {{ read_lang_word('send-feedback') }}
                            </button>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="gray-card">
                            <h5 class="base-title">{{ read_lang_word('videos') }}</h5>
                            <div class="swiper video-slider text-center">
                                <div class="swiper-wrapper">
                                    @foreach ($videos as $video)
                                        <div class="swiper-slide">
                                            <a data-fancybox href="{{ url($video->video->path) }}"
                                               data-caption="{{ $video->full_name }}">
                                                <video width="320" height="180" preload="metadata" muted>
                                                    <source src="{{ url($video->video->path) }}" type="video/mp4"/>
                                                </video>
                                            </a>
                                        </div>
                                    @endforeach
                                </div>
                                <div class="swiper-button-prev video-nav-prev"></div>
                                <div class="swiper-button-next video-nav-next"></div>
                            </div>
                            <button type="button" class="default-button" data-bs-toggle="modal"
                                    data-bs-target="#feedbackModal2">
                                {{ read_lang_word('send-video') }}
                            </button>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="gray-card">
                            <h5 class="base-title">{{ read_lang_word('mainexpo-rating--reviews') }}</h5>
                            <div class="ratings-list">
                                @foreach ($ratings as $rating)
                                    <div class="rating-item">
                                        <a href="{{ $rating->link }}" target="_blank">
                                            <img src="{{ url($rating->photo->path) }}" alt="Google Logo"
                                                 class="platform-logo">
                                        </a>
                                        <span class="rating-score">{{ number_format($rating->score, 1) }}</span>
                                        <div class="stars">
                                            @for ($i = 1; $i <= 5; $i++)
                                                @if ($i <= floor($rating->score))
                                                    <i class="fa-solid fa-star"></i>
                                                @elseif($i == floor($rating->score) + 1 && $rating->score - floor($rating->score) >= 0.5)
                                                    <i class="fa-solid fa-star-half-stroke"></i>
                                                @else
                                                    <i class="fa-regular fa-star"></i>
                                                @endif
                                            @endfor
                                        </div>
                                        <a href="{{ $rating->link }}" class="default-button"
                                           target="_blank">{{ read_lang_word('write-review') }}</a>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- Feedback Modal -->
    <div class="modal fade" id="feedbackModal" tabindex="-1" aria-labelledby="feedbackModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="feedbackModalLabel">{{ read_lang_word('send-feedback') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="feedbackForm" action="{{ route('front.feedback.submit') }}" method="POST"
                      enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="feedbackName" class="form-label">{{ read_lang_word('full-name') }} *</label>
                            <input type="text" class="form-control" id="feedbackName" name="name" required>
                        </div>
                        <div class="mb-3">
                            <label for="feedbackEmail" class="form-label">{{ read_lang_word('email') }} *</label>
                            <input type="email" class="form-control" id="feedbackEmail" name="email" required>
                        </div>
                        <div class="mb-3">
                            <label for="feedbackCompany" class="form-label">{{ read_lang_word('company-name') }}
                                *</label>
                            <input type="text" class="form-control" id="feedbackCompany" name="company">
                        </div>
                        <div class="mb-3">
                            <label for="logo" class="form-label">{{ read_lang_word('logo') }} *</label>
                            <input type="file" class="form-control" id="logo" name="logo">
                        </div>
                        <div class="mb-3">
                            <label for="feedbackStory" class="form-label">{{ read_lang_word('your-success-story') }}
                                *</label>
                            <textarea class="form-control" id="feedbackStory" name="story" rows="5" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-bs-dismiss="modal">{{ read_lang_word('close') }}</button>
                        <button type="submit" class="default-button">{{ read_lang_word('submit-form') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" id="feedbackModal2" tabindex="-1" aria-labelledby="feedbackModalLabel2" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="feedbackModalLabel">{{ read_lang_word('send-feedback') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="feedbackForm2" action="{{ route('front.feedback.video.submit') }}" method="POST"
                      enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="feedbackName" class="form-label">{{ read_lang_word('full-name') }} *</label>
                            <input type="text" class="form-control" id="feedbackName" name="name" required>
                        </div>
                        <div class="mb-3">
                            <label for="feedbackEmail" class="form-label">{{ read_lang_word('email') }} *</label>
                            <input type="email" class="form-control" id="feedbackEmail" name="email" required>
                        </div>
                        <div class="mb-3">
                            <label for="video" class="form-label">{{ read_lang_word('video') }} *</label>
                            <input type="file" class="form-control" id="video" name="video">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-bs-dismiss="modal">{{ read_lang_word('close') }}</button>
                        <button type="submit" class="default-button">{{ read_lang_word('submit-form') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Partners Section -->
    @if (count($partners))
        <div class="container-xxl d-flex">
            <span class="default-button rotate">{{ read_lang_word('partner2') }}</span>

            <div class="swiper logos-slider bg-white p-3">
                <div class="swiper-wrapper">
                    @foreach ($partners as $item)
                        <div class="swiper-slide">
                            <div class="logo-slide-card" style="background-color: white">
                                <a href="{{ $item->link ?? '#' }}" class="top_suppliers_a">
                                    <img class="lazyload"
                                         data-src="{{ $item->photo && is_file($item->photo->path) ? url($item->photo->path) : url('assets/front/img/home1/blog-1.jpg') }}"
                                         alt="{{ photo_alt($item, 'photo', read_lang($item, 'title')) }}"/>
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif
    <!-- End Of Partners Section -->

    <!-- FAQ Section -->
    <section class="container-xxl mt--5">
        <div class="section-card">
            <!-- Heading Box -->
            <div class="section-heading">
                <!-- Title And Description -->
                <div class="section-heading-right-side">
                    <div class="section-heading-title-box">
                        <h6 class="section-heading-title">{{ read_lang_word('frequently-asked-questions') }}</h6>
                    </div>
                </div>

                <!-- Input Or Buttons -->
                <div class="section-heading-left-side">
                    <a href="" class="default-button">
                        {{ read_lang_word('view-more') }}
                    </a>
                </div>
            </div>

            <!-- Accordions List -->
            <div class="accordion flex-column gap-3" id="faqAccordion">
                <!-- Accordion Item -->
                @foreach ($faqs as $index => $faq)
                    <div class="accordion-item">
                        <h3 class="accordion-header" id="accordion-{{ $index + 1 }}">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#accordion-body-{{ $index + 1 }}" aria-expanded="true"
                                    aria-controls="collapseOne">
                                {{ $index + 1 }}. {{ $faq->question }}
                            </button>
                        </h3>
                        <div id="accordion-body-{{ $index + 1 }}" class="accordion-collapse collapse"
                             aria-labelledby="accordion-{{ $index + 1 }}" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                {!! $faq->answer !!}
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <div>
                <button type="button" class="default-button m-auto mt-3" data-bs-toggle="modal"
                        data-bs-target="#askModal">
                    {{read_lang_word('ask-your-question')}}
                </button>
            </div>
        </div>
    </section>
    <!-- End FAQ Section -->
    <!-- ask Modal -->
    <div class="modal fade" id="askModal" tabindex="-1" aria-labelledby="askModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="feedbackModalLabel">{{ read_lang_word('send-feedback') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="feedbackForm" action="{{ route('front.feedback.submit') }}" method="POST"
                      enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="feedbackName" class="form-label">{{ read_lang_word('full-name') }} *</label>
                            <input type="text" class="form-control" id="feedbackName" name="name" required>
                        </div>
                        <div class="mb-3">
                            <label for="feedbackEmail" class="form-label">{{ read_lang_word('email') }} *</label>
                            <input type="email" class="form-control" id="feedbackEmail" name="email" required>
                        </div>
                        <div class="mb-3">
                            <label for="feedbackCompany" class="form-label">{{ read_lang_word('company-name') }}
                                *</label>
                            <input type="text" class="form-control" id="feedbackCompany" name="company">
                        </div>
                        <div class="mb-3">
                            <label for="feedbackStory" class="form-label">{{ read_lang_word('your-question') }}
                            </label>
                            <textarea class="form-control" id="feedbackStory" name="story" rows="5" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-bs-dismiss="modal">{{ read_lang_word('close') }}</button>
                        <button type="submit" class="default-button">{{ read_lang_word('submit-form') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.umd.js"></script>
    <script>
        Fancybox.bind("[data-fancybox]", {});
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {

            const feedbackForm = document.getElementById('feedbackForm');
            const feedbackForm2 = document.getElementById('feedbackForm2');

            if (feedbackForm) {
                feedbackForm.addEventListener('submit', function (e) {
                    e.preventDefault();

                    // نمایش اسپینر یا پیام در حال بارگذاری
                    const submitBtn = feedbackForm.querySelector('[type="submit"]');
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> {{ read_lang_word('submitting') }}...';

                    // ارسال فرم با AJAX
                    fetch(feedbackForm.action, {
                        method: 'POST',
                        body: new FormData(feedbackForm),
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest',
                            'Accept': 'application/json'
                        }
                    })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                alert('{{ read_lang_word('feedback-submitted-successfully') }}');
                                feedbackForm.reset();
                                const modal = bootstrap.Modal.getInstance(document.getElementById('feedbackModal'));
                                modal.hide();
                            } else {
                                alert(data.message || '{{ read_lang_word('submission-failed') }}');
                            }
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            alert('{{ read_lang_word('submission-error') }}');
                        })
                        .finally(() => {
                            submitBtn.disabled = false;
                            submitBtn.textContent = '{{ read_lang_word('submit') }}';
                        });
                });
            }
            if (feedbackForm2) {
                feedbackForm2.addEventListener('submit', function (e) {
                    e.preventDefault();

                    // نمایش اسپینر یا پیام در حال بارگذاری
                    const submitBtn = feedbackForm2.querySelector('[type="submit"]');
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> {{ read_lang_word('submitting') }}...';

                    // ارسال فرم با AJAX
                    fetch(feedbackForm2.action, {
                        method: 'POST',
                        body: new FormData(feedbackForm2),
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest',
                            'Accept': 'application/json'
                        }
                    })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                alert('{{ read_lang_word('feedback-submitted-successfully') }}');
                                feedbackForm2.reset();
                                const modal = bootstrap.Modal.getInstance(document.getElementById('feedbackModal2'));
                                modal.hide();
                            } else {
                                alert(data.message || '{{ read_lang_word('submission-failed') }}');
                            }
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            alert('{{ read_lang_word('submission-error') }}');
                        })
                        .finally(() => {
                            submitBtn.disabled = false;
                            submitBtn.textContent = '{{ read_lang_word('submit') }}';
                        });
                });
            }
        });
    </script>
@endsection
