@extends('front.layouts.front')
@section('styles')
@endsection
@section('body')
    <!--Login Register section start-->
    <div class="container my-5">
        <div class="mlp-login-container">
            <div class="row g-0">
                <div class="col-lg-6 mlp-left-panel d-flex flex-column justify-content-between">
                    <div class="mlp-left-panel-content">
                        <h1 class="display-5 fw-bold">{{read_lang_word('dont-have-an-account-yet')}}</h1>
                        <p class="sub-title my-3">{{read_lang_word('discover-global-trade-opportunities')}}</p>
                        <p>{{read_lang_word('connect-with-verified-buyers--suppliers-from-around-the-world')}}</p>
                        <a href="{{route('front.signupnew')}}"
                           class="mlp-btn-join mt-4">{{read_lang_word('join-for-free-now')}}</a>
                    </div>
                    <div class="mlp-logo text-white mb-4 ms-4">
                        mainexpo
                    </div>
                </div>

                <div class="col-lg-6 mlp-right-panel d-flex flex-column align-items-center justify-content-center">
                    <div class="mlp-login-form-wrapper">
                        <h2 class="fw-bold">{{read_lang_word('welcome-back')}}</h2>
                        <p class="text-muted mb-4">{{read_lang_word('sign-in-to-access-your-dashboard-and-grow-your-global-business')}}</p>

                        <ul class="nav nav-tabs mlp-auth-toggle nav-fill  mb-3" id="loginMethodTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="email-login-tab" data-bs-toggle="tab"
                                        data-bs-target="#email-login-pane" type="button" role="tab"
                                        aria-controls="email-login-pane"
                                        aria-selected="true">{{read_lang_word('sign-in-with-email')}}
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="phone-login-tab" data-bs-toggle="tab"
                                        data-bs-target="#phone-login-pane"
                                        type="button" role="tab" aria-controls="phone-login-pane" aria-selected="false">
                                    {{read_lang_word('sign-in-with-phone')}}
                                </button>
                            </li>
                        </ul>

                        <div class="tab-content" id="loginMethodTabContent">
                            <div class="tab-pane fade show active" id="email-login-pane" role="tabpanel"
                                 aria-labelledby="email-login-tab">
                                <form action="{{ route('login') }}" method="POST" id="mlp-email-login-form">
                                    @csrf
                                    <div class="mb-3">
                                        <input type="email"
                                               class="form-control mlp-form-control @error('username') is-invalid @enderror"
                                               id="mlp-login-email"
                                               name="username"
                                               autocomplete="username"
                                               placeholder="Enter registered email" value="{{ old('username') }}"
                                               required>
                                        @error('username')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                        @enderror
                                    </div>
                                    <div class="mb-3 position-relative">
                                        <input type="password"
                                               class="form-control mlp-form-control  @error('password') is-invalid @enderror"
                                               id="mlp-login-password"
                                               name="password"
                                               placeholder="Enter Password" autocomplete="current-password" required>
                                        <span class="mlp-password-toggle">
                        👁️
                                        </span>
                                        @error('password')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                        @enderror
                                    </div>
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <div class="form-check">
                                            <input type="checkbox" class="form-check-input" id="mlp-remember-me">
                                            <label class="form-check-label"
                                                   for="mlp-remember-me">{{read_lang_word('remember-me')}}</label>
                                        </div>
                                        @if (Route::has('password.request'))
                                            <a href="" class="mlp-link">{{read_lang_word('login-forget-password')}}</a>
                                        @endif

                                    </div>
                                    <button type="submit"
                                            class="default-button w-100">{{read_lang_word('login-btn')}}</button>
                                </form>
                            </div>
                            <div class="tab-pane fade" id="phone-login-pane" role="tabpanel"
                                 aria-labelledby="phone-login-tab">
                                <form action="{{ route('login') }}" method="POST" id="mlp-phone-login-form">
                                    @csrf
                                    <div class="mb-3">
                                        <input type="tel"
                                               class="form-control mlp-form-control @error('mobile') is-invalid @enderror"
                                               id="mlp-login-phone"
                                               placeholder="Enter phone number" required
                                               name="mobile"
                                               value="{{ old('mobile') }}"
                                        >
                                        @error('mobile')
                                        <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
            </span>
                                        @enderror
                                    </div>
                                    <div class="mb-3 position-relative">
                                        <input type="password" class="form-control mlp-form-control  @error('password') is-invalid @enderror"
                                               id="mlp-login-password-phone"
                                               name="password"
                                               placeholder="Enter Password" autocomplete="current-password" required>
                                        <span class="mlp-password-toggle">
                👁️
            </span>
                                        @error('password')
                                        <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
            </span>
                                        @enderror
                                    </div>
                                    <button type="submit" class="default-button w-100">{{read_lang_word('sign-in-with-phone')}}</button>
                                </form>
                            </div>
                        </div>

                        <p class="text-muted text-center my-3">{{read_lang_word('or-sign-in-with')}}</p>
                        <div class="d-flex justify-content-center gap-3">
                            <a href="{{ route('front.redirectToGoogle') }}" class="mlp-social-btn">
                                <img src="{{ url('assets/front/new/images/google.png') }}" alt="Google">
                            </a>
                            <a href="#" class="mlp-social-btn"><img
                                        src="{{url('assets/front/new/images/facebook.png')}}"
                                        alt="Facebook"></a>
                            <a href="#" class="mlp-social-btn"><img
                                        src="{{url('assets/front/new/images/linkedin.png')}}"
                                        alt="LinkedIn"></a>
                            <a href="#" class="mlp-social-btn"><img src="{{url('assets/front/new/images/twiter.png')}}"></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--Login Register section end-->
@endsection
@section('scripts')
@endsection
