@extends('front.layouts.front')
@section('styles')
    <link rel="stylesheet" href="{{url('assets/front/css/fancybox.css')}}">
@endsection
@section('body')
    <section class="blog-section pt-120 overflow-hidden pb-120">
        <div class="container">
            <div class="row">
                <div class="col-12 top_text position-relative">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-lg-4 order-2 order-lg-1 text-991-center">
                                <img src="{{$top->transport_photo && is_file($top->transport_photo->path)?url($top->transport_photo->path):url('assets/front/img/home1/car-red.png')}}"
                                     alt="{{photo_alt($top,'transport_photo',read_lang($top,'transport_title'))}}"
                                     class="img-fluid top_img">
                            </div>
                            <div class="col-lg-8 order-1 order-lg-2">
                                <h2>{{read_lang($top,'transport_title')}}</h2>
                                <div class="editor-text">
                                    {!! read_lang($top,'transport_text') !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @if(count($items_m))
                    <div class="col-12 mt-5">
                        <h3>{{read_lang_word('multimodal-transports')}}</h3>
                    </div>
                    @foreach($items_m as $item)
                        <div class="col-lg-6 mt-2">
                            @include('front.pages.includes.import_export_services_card')
                        </div>
                    @endforeach
                @endif
                @if(count($items_s))
                    <div class="col-12 mt-4">
                        <h3>{{read_lang_word('sea-transportation')}}</h3>
                    </div>
                    @foreach($items_s as $item)
                        <div class="col-lg-6 mt-2">
                            @include('front.import_export_services_card')
                        </div>
                    @endforeach
                @endif
                @if(count($items_a))
                    <div class="col-12 mt-4">
                        <h3>{{read_lang_word('air-freight')}}</h3>
                    </div>
                    @foreach($items_a as $item)
                        <div class="col-lg-6 mt-2">
                            @include('front.import_export_services_card')
                        </div>
                    @endforeach
                @endif
                @if(count($items_l))
                    <div class="col-12 mt-4">
                        <h3>{{read_lang_word('land-freight')}}</h3>
                    </div>
                    @foreach($items_l as $item)
                        <div class="col-lg-6 mt-2">
                            @include('front.import_export_services_card')
                        </div>
                    @endforeach
                @endif
                @if(count($items_f))
                    <div class="col-12 mt-4">
                        <h3>{{read_lang_word('freight-agents')}}</h3>
                    </div>
                    @foreach($items_f as $item)
                        <div class="col-lg-6 mt-2">
                            @include('front.import_export_services_card')
                        </div>
                    @endforeach
                @endif
                @if(count($items_c))
                    <div class="col-12 mt-4">
                        <h3>{{read_lang_word('customs-clearance-services')}}</h3>
                    </div>
                    @foreach($items_c as $item)
                        <div class="col-lg-6 mt-2">
                            @include('front.import_export_services_card')
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>
@endsection
@section('scripts')
    <script src="{{url('assets/front/js/fancybox.js')}}"></script>
    <script>
        function openPopup(event) {
            event.preventDefault(); // جلوگیری از باز شدن لینک در تب جدید
            const width = 600; // عرض پنجره
            const height = 700; // ارتفاع پنجره
            const left = 0; // محاسبه موقعیت افقی پنجره
            const top = 0; // محاسبه موقعیت عمودی پنجره

            window.open(
                event.target.href, // آدرس لینک
                "popupWindow", // نام پنجره
                `width=${width},height=${height},left=${left},top=${top},resizable=yes,scrollbars=yes`
            );
        }
    </script>
@endsection
