@extends('front.layouts.front')
@section('styles')
    <style>
        .app-content {
            margin-right: unset !important;
            margin-top: 20px !important;
        }

        footer.footer {
            padding: unset;
        }

        .bg_image {
            background: url('{{request_bg()}}');
            background-repeat: no-repeat;
            background-size: cover;
        }

        .gmail_icon {
            width: 60px;
        }
    </style>
@endsection
@section('body')
    <div class="py-5 bg_image">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 col-md-10">
                    <div class="card glass-effect">
                        <div class="card-header">{{$title}}</div>

                        <div class="card-body">
                            {{ Form::open(array('route' => 'front.sell.your.products.post', 'method' => 'POST','class'=>'container-fluid' , 'id'=>'from_req')) }}
                            <div class="row">
                                <div class="col-md-6 my-2">
                                    <div class="form-group">
                                        {{Form::label('c_name', read_lang_word('request-form-c-name').' *')}}
                                        {{Form::text('c_name', null, array('class' => 'form-control','required'))}}
                                    </div>
                                </div>
                                <div class="col-md-12"></div>
                                <div class="col-md-6 my-2">
                                    <div class="form-group">
                                        {{Form::label('f_name', read_lang_word('request-form-f-name').' *')}}
                                        {{Form::text('f_name', null, array('class' => 'form-control','required'))}}
                                    </div>
                                </div>
                                <div class="col-md-6 my-2">
                                    <div class="form-group">
                                        {{Form::label('l_name', read_lang_word('request-form-l-name').' *')}}
                                        {{Form::text('l_name', null, array('class' => 'form-control','required'))}}
                                    </div>
                                </div>
                                <div class="col-md-6 my-2">
                                    <div class="form-group">
                                        {{Form::label('email', read_lang_word('request-form-email').' *')}}
                                        {{Form::email('email', null, array('class' => 'form-control','dir'=>'ltr','required'))}}
                                    </div>
                                </div>
                                <div class="col-md-6 my-2">
                                    <div class="form-group">
                                        {{Form::label('phone', read_lang_word('request-form-phone').'(+90)')}}
                                        {{Form::number('phone', null, array('class' => 'form-control phone_input','dir'=>'ltr'))}}
                                    </div>
                                </div>
                                <div class="col-md-6 my-2">
                                    <div class="form-group">
                                        {{Form::label('date_start', read_lang_word('request-form-date-start').' *')}}
                                        {{Form::date('date_start', null, array('class' => 'form-control','dir'=>'ltr','min'=>now()->format('Y-m-d'),'required'))}}
                                    </div>
                                </div>
                                <div class="col-md-6 my-2">
                                    <div class="form-group">
                                        {{Form::label('date_end', read_lang_word('request-form-date-end').' *')}}
                                        {{Form::date('date_end', null, array('class' => 'form-control','dir'=>'ltr','min'=>now()->format('Y-m-d'),'required'))}}
                                    </div>
                                </div>
                                <div class="col-md-12 my-2">
                                    <div class="form-group">
                                        {{Form::label('text', read_lang_word('request-form-text').' *')}}
                                        {{Form::textarea('text', null, array('class' => 'form-control','rows'=>'4','required'))}}
                                    </div>
                                </div>
                                <div class="col-md-6 mx-auto my-2">
                                    <div class="form-group position-relative">
                                        {{Form::label('captcha', read_lang_word('captcha').' *')}}
                                        <img src="{{url(captcha())}}" class="m-auto captcha_img d-block" width="80">
                                        {{Form::number('captcha', null, array('class' => 'form-control text-center','dir'=>'ltr','required'))}}
                                    </div>
                                </div>
                                <div class="col-md-12 my-2">
                                    {{Form::submit(read_lang_word('request-form-btn'),array('class'=>'btn btn-primary w-100','onclick'=>"return confirm('".read_lang_word('request-form-submit')."')"))}}
                                </div>
                            </div>
                            {{ Form::close() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    @include('front.includes.req')
@endsection