@extends('front.layouts.front')
@section('styles')
    <link rel="stylesheet" href="{{url('assets/front/css/fancybox.css')}}">
@endsection
@section('body')
    <section class="blog-section pt-120 overflow-hidden pb-120">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-lg-9 col-md-8 col-sm-6">
                                <h2>{{read_lang($top,'sourcing_magazine_title')}}</h2>
                                <div class="editor-text">
                                    {!! read_lang($top,'sourcing_magazine_text') !!}
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-4 col-sm-6">
                                <img src="{{$top->sourcing_magazine_photo && is_file($top->sourcing_magazine_photo->path)?url($top->sourcing_magazine_photo->path):url('assets/front/img/home1/car-red.png')}}"
                                     alt="{{photo_alt($top,'sourcing_magazine_photo',read_lang($top,'sourcing_magazine_title'))}}"
                                     class="img-fluid">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 mt-5 mb-4">
                    @foreach($cats as $key=>$cat)
                        <button class="btn tab-btn {{$cat_id == $cat->id ? 'btn-primary' : 'btn-outline-primary'}} my-1" data-id="{{$cat->id}}">
                            {{read_lang($cat,'title')}}
                        </button>
                    @endforeach
                </div>
                @if(count($items))
                    @foreach($items as $item)
                        <div class="col-lg-6 mt-2 cat_id cat_id_{{$item->cat_id}} {{$item->cat_id == $cat_id ? '' : 'd-none'}}">
                            @include('front.pages.includes.sourcing_magazine_card')
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>
@endsection
@section('scripts')
    <script src="{{url('assets/front/js/fancybox.js')}}"></script>
    <script>
        $('.tab-btn').click(function (){
            var cat_id=$(this).attr('data-id')
            $('.cat_id').addClass('d-none')
            $('.tab-btn').removeClass('btn-primary')
            $('.tab-btn').addClass('btn-outline-primary')
            $('.tab-btn').removeClass('text-white')
            $('.cat_id_'+cat_id).removeClass('d-none')
            $(this).removeClass('btn-outline-primary')
            $(this).addClass('btn-primary')
            $(this).addClass('text-white')
        })
        function openPopup(event) {
            event.preventDefault(); // جلوگیری از باز شدن لینک در تب جدید
            const width = 600; // عرض پنجره
            const height = 700; // ارتفاع پنجره
            const left = 0; // محاسبه موقعیت افقی پنجره
            const top = 0; // محاسبه موقعیت عمودی پنجره

            window.open(
                event.target.href, // آدرس لینک
                "popupWindow", // نام پنجره
                `width=${width},height=${height},left=${left},top=${top},resizable=yes,scrollbars=yes`
            );
        }
    </script>
@endsection
