@extends('front.layouts.front')
@section('styles') @endsection
@section('body')
    <!--blog section start-->
    <section class="blog-section pt-70 overflow-hidden pb-70">
      <div class="container">
        <div class="blog-card-wrapper">
          <div class="row g-4 justify-content-center">
            <div class="col-lg-4 col-md-6 ul_category_product">
              <div class="sidebar mt-xl-0">
                <div class="widget-top d-flex">
                  <h5 class="mb-0 flex-shrink-0">{{read_lang_word('category')}}</h5>
                </div>
                <hr class="mt-3"/>
                <ul class="menu">
                  <li>
                    <a @if($cat_id!='all') href="{{route('front.product.list','all')}}" @endif class="font-weight-bold {{$cat_id=='all'?'active-tag':''}}">
                      {{read_lang_word('all')}}
                    </a>
                  </li>
                  @foreach($cats as $key => $cat)
                    <li class="{{count($cat->childs_active) ? 'has-submenu' : ''}}">
                      <a href="{{route('front.product.list',$cat->slug)}}" class="font-weight-bold {{$cat_id==$cat->id || $cat->childs_active->where('id',$cat_id)->first() ? 'active-tag' : ''}}">{{read_lang($cat,'title')}}</a>
                      @if(count($cat->childs_active))
                        <span class="toggle-submenu">{{$cat->childs_active->where('id',$cat_id)->first() ? '-' : '+'}}</span> <!-- علامت + -->
                        <ul class="submenu {{$cat->childs_active->where('id',$cat_id)->first() ? 'active' : ''}}">
                          @foreach($cat->childs_active as $child)
                            <li><a href="{{route('front.product.list',$child->slug)}}" class="{{$cat_id==$child->id?'active-tag':''}}">{{read_lang($child,'title')}}</a></li>
                          @endforeach
                        </ul>
                      @endif
                    </li>
                  @endforeach
                </ul>
              </div>
            </div>
            <div class="col-lg-8 col-md-6">
              <div class="container-fluid">
                <div class="row">
                  @if(count($items))
                  @foreach($items as $item)
                    <div class="col-lg-4 col-md-6 col-sm-4 col-6 px-1 pb-4">
                      @include('front.product.includes.card',['item'=>$item])
                    </div>
                  @endforeach

                    <div class="col-12 mt-5 paginate-div text-center">
                      {{$items->appends(Request::except('page'))->links("cpag.custom")}}
                    </div>
                  @else
                    <div class="col-12 alert alert-danger text-center">
                      Not Found Items
                    </div>
                  @endif
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!--blog section end-->
  <button class="open_filter">
    <i class="fas fa-filter ul_category_product_filter"></i>
  </button>
@endsection
@section('scripts')
  <script>
    document.querySelectorAll('.toggle-submenu').forEach(toggle => {
      toggle.addEventListener('click', function (e) {
        e.stopPropagation(); // جلوگیری از انتشار رویداد به عناصر والد
        const submenu = this.parentElement.querySelector('.submenu');
        submenu.classList.toggle('active'); // اضافه یا حذف کلاس active

        // تغییر علامت + به - و بالعکس
        if (this.textContent === '+') {
          this.textContent = '-';
        } else {
          this.textContent = '+';
        }
      });
    });

    // جلوگیری از باز شدن زیرمنو هنگام کلیک روی لینک
    document.querySelectorAll('.has-submenu > a').forEach(link => {
      link.addEventListener('click', function (e) {
        e.stopPropagation(); // جلوگیری از باز شدن زیرمنو
      });
    });
  </script>
@endsection
