@extends('front.layouts.front')
@if(!blank($item->photo && is_file($item->photo->path)))
    @section('title_seo')
        <meta name="twitter:image" content="{{url($item->photo->path)}}"/>
        <meta property="og:image" content="{{url($item->photo->path)}}"/>
    @endsection
@endif
@section('styles')
    <link rel="stylesheet" href="{{url('assets/front/css/fancybox.css')}}"/>
@endsection
@section('body')
    <!--blog list section start-->
    <section class="blog-list-section ptb-50 bg-white product_single">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="sticky-top-80px">
                        <div class="swiper mySwiperProduct2">
                            <div class="swiper-wrapper">
                                @if($item->photo)
                                    <div class="swiper-slide" data-fancybox="gallery"
                                         href="{{url($item->photo->path)}}">
                                        <img src="{{url($item->photo->path)}}"
                                             alt="{{photo_alt($item,'photo',read_lang($item,'title'))}}"/>
                                    </div>
                                @endif
                                @foreach($item->gallery as $gallery)
                                    <div class="swiper-slide" data-fancybox="gallery" href="{{url($gallery->path)}}">
                                        <img src="{{url($gallery->path)}}"
                                             alt="{{$gallery->alt ?? read_lang($item,'title')}}"/>
                                    </div>
                                @endforeach
                                @if($item->video)
                                    <div class="swiper-slide" data-fancybox="gallery"
                                         href="{{url($item->video->path)}}">
                                        <video controls>
                                            <source src="{{url($item->video->path)}}" type="video/mp4">
                                        </video>
                                    </div>
                                @endif
                            </div>
                            <div class="swiper-button-next product-next"></div>
                            <div class="swiper-button-prev product-prev"></div>
                        </div>
                        <div thumbsSlider="" class="swiper mySwiperProduct">
                            <div class="swiper-wrapper">
                                @if($item->photo)
                                    <div class="swiper-slide">
                                        <img src="{{url($item->photo->path)}}"
                                             alt="{{photo_alt($item,'photo',read_lang($item,'title'))}}"/>
                                    </div>
                                @endif
                                @foreach($item->gallery as $gallery)
                                    <div class="swiper-slide">
                                        <img src="{{url($gallery->path)}}"
                                             alt="{{$gallery->alt ?? read_lang($item,'title')}}"/>
                                    </div>
                                @endforeach
                                @if($item->video)
                                    <div class="swiper-slide">
                                        <img src="{{url('assets/front/img/mp4.jpg')}}"
                                             alt="{{read_lang($item,'title')}}"/>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <h3>{{read_lang($item,'title')}}</h3>
                    <span class="badge bg-primary">
            <img src="{{$item->category && $item->category->icon && is_file($item->category->icon->path) ? url($item->category->icon->path) : url('assets/front/cat_default.webp')}}"
                 class="cat_icon_menu me-1"
                 alt="{{photo_alt($item->category,'icon',read_lang($item->category,'title'))}}">
            {{read_lang($item->category,'title')}}
          </span>
                    @if(count($item->prices))
                        <hr class="my-4"/>
                        <div class="container-fluid price_css">
                            <div class="row">
                                @foreach($item->prices as $price)
                                    <div class="col-md-4 col-6">
                                        <strong>$ {{number_format($price->price,2,'.')}}</strong>
                                        <br/>
                                        <span>{{$price->from}} -{{$price->to}} /{{$item->unit}}</span>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif
                    @if(count($item->features))
                        <hr class="my-4"/>
                        <h4>{{read_lang_word('product-feature')}}</h4>
                        @foreach($item->features as $feature)
                            <p class="mb-1">
                                <strong class="me-3">{{read_lang($feature,'title')}}: </strong>
                                {{read_lang($feature,'value')}}
                            </p>
                        @endforeach
                    @endif
                    <hr class="my-4"/>
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-6 mx-auto">
                                @include('front.product.includes.contact')
                            </div>
                            @if($days > 0 && $user->verify_type == 'vip')
                            <div class="col-6">
                                @include('front.product.includes.chat')
                            </div>
                            @endif
                            <div class="col-12">
                                <p class="mt-2 mb-0">{{read_lang_word('product-request1')}} <strong class="mx-1"><a
                                                href="#">{{read_lang_word('product-request1')}}</a></strong></p>
                            </div>
                        </div>
                    </div>
                    @if($item->user)
                        <hr class="my-4"/>
                        <a href="{{route('front.supplier.show',$item->user->u_id)}}" class="d-inline-flex align-items-center bg-supplier">
                            <img class="w-h-50"
                                 src="{{$item->user->photo && is_file($item->user->photo->path)?url($item->user->photo->path):url('source/Slıder1.jpg')}}"
                                 alt="{{photo_alt($item->user,'photo',$item->user->name)}}">
                            {{$item->user->name}}
                        </a>
                    @endif
                </div>
            </div>
        </div>
    </section>
    @if(count($items_similar))
        <section class="blog-section pt-20 overflow-hidden pb-0">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-6 col-lg-7">
                        <div class="at-section-title text-center">
                            <span class="at-subtitle position-relative text-primary lead">{{read_lang_word('product')}}</span>
                            <h2 class="mt-2 h1">{{read_lang_word('products-similar')}}</h2>
                        </div>
                    </div>
                </div>
                <div class="blog-card-wrapper mt-2">
                    <div class="h4-categories-slider-wrapper overflow-hidden px-0">
                        <div class="s4_ct_slider_product h4-categories-slider swiper overflow-visible">
                            <div class="swiper-wrapper">
                                @foreach($items_similar as $product)
                                    <div class="swiper-slide px-1">
                                        @include('front.product.includes.card',['item'=>$product])
                                    </div>
                                @endforeach
                            </div>
                            <div class="flash-controls sflash-button-prev flash-button-prev"><i
                                        class="fa-solid fa-angle-left"></i></div>
                            <div class="flash-controls sflash-button-next flash-button-next"><i
                                        class="fa-solid fa-angle-right"></i></div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    <ul class="nav nav-tabs sticky-top-75px" role="tablist">
        <li class="nav-item" role="presentation">
            <a class="nav-link active" id="simple-tab-0" data-bs-toggle="tab" href="#simple-tabpanel-0"
               role="tab" aria-controls="simple-tabpanel-0" aria-selected="true">{{read_lang_word('product-detail')}}</a>
        </li>
        @if($item->user)
            <li class="nav-item" role="presentation">
                <a class="nav-link" id="simple-tab-1" data-bs-toggle="tab" href="#simple-tabpanel-1" role="tab"
                   aria-controls="simple-tabpanel-1" aria-selected="false">{{read_lang_word('product-company-info')}}</a>
            </li>
        @endif
    </ul>
    <section class="blog-list-section ptb-50 bg-white">
        <div class="container">
            <div class="tab-content" id="tab-content">
                <div class="tab-pane active" id="simple-tabpanel-0" role="tabpanel" aria-labelledby="simple-tab-0">
                    <div class="editor-text">
                        {!! read_lang($item,'text') !!}
                    </div>
                </div>
                @if($item->user)
                <div class="tab-pane" id="simple-tabpanel-1" role="tabpanel" aria-labelledby="simple-tab-1">
                    <div class="editor-text">
                        {!! read_lang($item->user,'info') !!}
                    </div>

                    @if(count($item->user->certificates))
                        <section class="blog-section pt-20 overflow-hidden pb-0">
                            <div class="container">
                                <div class="row justify-content-center">
                                    <div class="col-xl-12"><hr class="my-4"/></div>
                                    <div class="col-xl-6 col-lg-7">
                                        <div class="at-section-title text-center">
                                            <span class="at-subtitle position-relative text-primary lead">{{read_lang_word('product-certificate')}}</span>
                                            <h2 class="mt-2 h1">{{read_lang_word('products-certificate-company')}} {{$item->user->name}}</h2>
                                        </div>
                                    </div>
                                </div>
                                <div class="blog-card-wrapper mt-2">
                                    <div class="h4-categories-slider-wrapper overflow-hidden px-0">
                                        <div class="s4_ct_slider_2 h4-categories-slider swiper overflow-visible">
                                            <div class="swiper-wrapper">
                                                @foreach($item->user->certificates as $certificate)
                                                    <div class="swiper-slide px-1" data-fancybox="gallery_certificate"
                                                         href="{{url($certificate->photo->path)}}">
                                                        <img src="{{url($certificate->photo->path)}}" class="certificate_img" alt="{{photo_alt($certificate,'photo',$certificate->type_title)}}">
                                                    </div>
                                                @endforeach
                                            </div>
                                            <div class="flash-controls sflash-button-prev flash-button-prev"><i
                                                        class="fa-solid fa-angle-left"></i></div>
                                            <div class="flash-controls sflash-button-next flash-button-next"><i
                                                        class="fa-solid fa-angle-right"></i></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
                    @endif
                </div>
                @endif
            </div>
        </div>
    </section>
@endsection
@section('scripts')
    <script src="{{url('assets/front/js/fancybox.js')}}"></script>
@endsection
