<div x-data="{
    isDragging: false,
    isUploading: false,
    previews: @js($previewUrls),
    newPreviews: [],
    maxFiles: {{ $maxFiles }},
    addPreview(file, index) {
        if (!file) return;
        const totalFiles = this.previews.length + this.newPreviews.length;
        if (totalFiles >= this.maxFiles) {
            Swal.fire({
                icon: 'warning',
                title: '{{ translateText('Warning', lang_admin()) }}',
                html: `{{ translateText('Maximum', lang_admin()) }} ${this.maxFiles} {{ translateText('files allowed.', lang_admin()) }}`,
                timer: 3000,
                showConfirmButton: false
            });
            return;
        }
        const extension = file.name.split('.').pop().toLowerCase();
        if (['jpg', 'jpeg', 'png', 'webp', 'gif'].includes(extension)) {
            const reader = new FileReader();
            reader.onload = (e) => {
                this.newPreviews[index] = { url: e.target.result, name: file.name, size: file.size, type: 'image' };
            };
            reader.readAsDataURL(file);
        } else {
            this.newPreviews[index] = {
                url: null,
                name: file.name,
                size: file.size,
                type: extension === 'mp4' ? 'video' : (extension === 'pdf' ? 'pdf' : 'file')
            };
        }
    },
    init() {
        this.$wire.on('previews-updated', (event) => {
            this.previews = event.previews || [];
            this.newPreviews = [];
            this.$nextTick(() => {
                this.$el.querySelectorAll('.row.g-3').forEach(el => el.dispatchEvent(new Event('input')));
            });
        });
        this.$wire.on('file-upload-ready', () => {
            this.isUploading = false;
        });
    }
}"
     x-on:dragover.prevent="isDragging = true"
     x-on:dragleave.prevent="isDragging = false"
     x-on:livewire-upload-start="isUploading = true"
     x-on:livewire-upload-finish="isUploading = false"
     x-on:livewire-upload-error="isUploading = false; newPreviews = []"
     x-on:file-upload-ready.window="isUploading = false"
     x-on:alert.window="Swal.fire({ icon: $event.detail.icon, title: $event.detail.title, text: $event.detail.text, timer: 3000, showConfirmButton: false })"
     x-on:file-upload-failed.window="Swal.fire({ icon: 'error', title: $event.detail.type + ': ' + '{{ translateText('Error', lang_admin()) }}', html: $event.detail.error, timer: 5000, showConfirmButton: true })"
     class="file-upload-container p-4 rounded-3 border">
    <!-- Label -->
    <label class="form-label fw-bold mb-3 d-block">
        {{ $label }}
        @if($required)
            <span class="text-danger">*</span>
        @endif
    </label>

    @if($type === 'gallery')
        <div wire:ignore class="col-md-12 mb-3">
            <div class="form-check form-switch form-check-reverse" style="padding-left: 20px">
                <input wire:model.defer="applyWatermark"
                       class="form-check-input badge-light-info ms-2"
                       id="watermark-{{ $uniqueKey }}"
                       type="checkbox">
                <label class="form-check-label" for="watermark-{{ $uniqueKey }}">
                    {{ translateText('Apply Watermark to Images', lang_admin()) }}
                </label>
            </div>
        </div>
    @endif

    <!-- File Input Section -->
    <div class="mb-3 pointer">
        <div class="border border-2 border-dashed rounded-3 p-4 text-center position-relative transition-all pointer">
            <input
                    @if($required)
                        required
                    @endif
                    x-ref="fileInput"
                    type="file"
                    wire:model.defer="files"
                    :multiple="{{ $isMultiple ? 'true' : 'false' }}"
                    accept=".{{ str_replace(',', ',.', $acceptedFormats) }}"
                    class="position-absolute top-0 start-0 w-100 h-100 opacity-0 cursor-pointer pointer"
                    @change="
                    @if($isMultiple)
                        const totalFiles = previews.length + $event.target.files.length;
                        if (totalFiles > maxFiles) {
                            Swal.fire({
                                icon: 'warning',
                                title: '{{ translateText('Warning', lang_admin()) }}',
                                html: `{{ translateText('Maximum', lang_admin()) }} ${maxFiles} {{ translateText('files allowed.', lang_admin()) }}`,
                                timer: 3000,
                                showConfirmButton: false
                            });
                            return;
                        }
                        @this.set('files', [...@this.files, ...Array.from($event.target.files)]);
                        Array.from($event.target.files).forEach((file, i) => addPreview(file, @this.files.length - $event.target.files.length + i));
                    @else
                        @this.set('files', $event.target.files[0]);
                        addPreview($event.target.files[0], 0);
                    @endif
                "
            >
            <div class="d-flex flex-column justify-content-center h-100 pointer">
                <i class="fas fa-cloud-upload-alt fa-2x text-muted mb-2"></i>
                <p class="mb-2 fw-medium">
                    {{ $isMultiple ? translateText('Drag & drop files here or click to upload', lang_admin()) : translateText('Drag & drop a file here or click to upload', lang_admin()) }}
                </p>
                <p class="text-muted small mb-0">
                    {{ $acceptedFormats ? translateText('Allowed formats: ', lang_admin()) . str_replace(',', ', ', $acceptedFormats) : '' }}
                    @if($maxSize)
                        | {{ translateText('Max size: ', lang_admin()) . ($maxSize / 1024) . ' MB' }}
                    @endif
                    @if($dimensions)
                        | {{ translateText('Dimensions: ', lang_admin()) . $dimensions }}
                    @endif
                    @if($isMultiple && $maxFiles)
                        | {{ translateText('Max files: ', lang_admin()) . $maxFiles }}
                    @endif
                </p>
            </div>
        </div>
    </div>

    <!-- Loading Indicator -->
    <div x-show="isUploading" class="text-center mb-3">
        <i class="fas fa-spinner fa-spin fa-2x text-primary"></i>
        <span class="text-primary ms-2">{{ translateText('Uploading...', lang_admin()) }}</span>
    </div>

    <!-- Existing Files Preview -->
    @if($previewUrls)
        <div class="mt-3" x-show="previews.length > 0">
            <h6 class="mb-2">{{ translateText('Existing Files', lang_admin()) }}</h6>
            <div class="row g-3">
                <template x-for="(file, index) in previews" :key="file.id">
                    <div class="{{ $isMultiple ? 'col-6 col-md-4 col-lg-3' : 'col-12' }}">
                        <div class="card h-100 border-0 shadow-sm">
                            <div class="position-relative" style="height: 160px; background-color: #f8f9fa;">
                                <template x-if="file.type === 'image'">
                                    <img :src="file.path" :alt="file.name" class="w-100 h-100 object-fit-contain p-2">
                                </template>
                                <template x-if="file.type === 'video'">
                                    <div class="w-100 h-100 position-relative">
                                        <video :src="file.path" class="w-100 h-100 object-fit-cover" muted></video>
                                        <div class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center">
                                            <i class="fas fa-play-circle fa-3x text-white opacity-75"></i>
                                        </div>
                                    </div>
                                </template>
                                <template x-if="file.type === 'pdf'">
                                    <div class="w-100 h-100 d-flex align-items-center justify-content-center">
                                        <i class="fas fa-file-pdf fa-3x text-danger"></i>
                                    </div>
                                </template>
                            </div>
                            <div class="card-body p-2">
                                <h6 class="card-title text-truncate mb-1" x-text="file.name"></h6>
                                <p class="card-text text-muted small mb-0" x-text="file.size ? (file.size / 1024 / 1024).toFixed(2) + ' MB' : ''"></p>
                            </div>
                            <div class="card-footer bg-transparent border-top p-2 d-flex gap-2">
                                <a :href="file.path" target="_blank" class="btn btn-outline-primary btn-sm flex-grow-1">
                                    <i class="fas fa-eye me-1"></i> {{ translateText('View', lang_admin()) }}
                                </a>
                                <button type="button" wire:click="deleteFile(file.id)" class="btn btn-outline-danger btn-sm flex-grow-1">
                                    <i class="fas fa-trash me-1"></i> {{ translateText('Delete', lang_admin()) }}
                                </button>
                            </div>
                        </div>
                    </div>
                </template>
            </div>
        </div>
    @endif

    <!-- New Files Preview -->
    <div class="mt-3" x-show="newPreviews.length > 0">
        <h6 class="mb-2">{{ translateText('New Files', lang_admin()) }}</h6>
        <div class="row g-3">
            <template x-for="(preview, index) in newPreviews" :key="index">
                <div class="{{ $isMultiple ? 'col-6 col-md-4 col-lg-3' : 'col-12' }}">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="position-relative" style="height: 160px; background-color: #f8f9fa;">
                            <template x-if="preview.type === 'image'">
                                <img :src="preview.url" :alt="preview.name" class="w-100 h-100 object-fit-contain p-2">
                            </template>
                            <template x-if="preview.type === 'video'">
                                <div class="w-100 h-100 position-relative">
                                    <video :src="preview.url" class="w-100 h-100 object-fit-cover" muted></video>
                                    <div class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center">
                                        <i class="fas fa-play-circle fa-3x text-white opacity-75"></i>
                                    </div>
                                </div>
                            </template>
                            <template x-if="preview.type === 'pdf'">
                                <div class="w-100 h-100 d-flex align-items-center justify-content-center">
                                    <i class="fas fa-file-pdf fa-3x text-danger"></i>
                                </div>
                            </template>
                            <template x-if="preview.type === 'file'">
                                <div class="w-100 h-100 d-flex align-items-center justify-content-center">
                                    <i class="fas fa-file-alt fa-3x text-secondary"></i>
                                </div>
                            </template>
                        </div>
                        <div class="card-body p-2">
                            <h6 class="card-title text-truncate mb-1" x-text="preview.name"></h6>
                            <p class="card-text text-muted small mb-0" x-text="preview.size ? (preview.size / 1024 / 1024).toFixed(2) + ' MB' : ''"></p>
                        </div>
                        <div class="card-footer bg-transparent border-top p-2">
                            <button type="button" @click="newPreviews.splice(index, 1); @this.set('files', @this.files.filter((_, i) => i !== index))"
                                    class="btn btn-outline-danger btn-sm w-100">
                                <i class="fas fa-trash me-1"></i> {{ translateText('Remove', lang_admin()) }}
                            </button>
                        </div>
                    </div>
                </div>
            </template>
        </div>
    </div>

    @push('styles')
        <style>
            .file-upload-container {
                transition: all 0.3s ease;
                background: #fff;
            }
            .border-dashed {
                border-style: dashed;
            }
            .object-fit-contain {
                object-fit: contain;
            }
            .object-fit-cover {
                object-fit: cover;
            }
            .card {
                transition: transform 0.2s ease, box-shadow 0.2s ease;
            }
            .transition-all {
                transition: all 0.3s ease;
            }
            .border-primary.bg-primary.bg-opacity-10 {
                animation: pulse 1.5s infinite;
            }
            @keyframes pulse {
                0% { transform: scale(1); }
                50% { transform: scale(1.01); }
                100% { transform: scale(1); }
            }
        </style>
    @endpush
</div>