<div style="{{$style != null ? $style['at'] : ''}}:{{$style != null ? $style['val'] : ''}}" wire:ignore x-data="{ value: @js($value ?? ($isMultiple ? [] : null)) }" x-init="
    const select = new TomSelect($refs.select, {
        plugins: {{ $isMultiple ? "['remove_button']" : '[]' }},
        valueField: 'value',
        labelField: 'text',
        searchField: 'text',
        options: @js(array_map(function($value, $text) {
            return ['value' => $value, 'text' => $text];
        }, array_keys($options), array_values($options))),
        items: value,
        @if($keyword)
        create: true,
        @endif
        maxItems: {{ $isMultiple ? 'null' : '1' }},
        placeholder: @js($placeholder . ($isMultiple ? ' (multiple choice)' : '')),
        onChange: (val) => {
            value = val;
            console.log('TomSelect onChange:', { field: '{{ $field }}', value: val });
            @if($immediateUpdate)
                @this.dispatch('tomselect-updated', { field: '{{ $field }}', value: val });
            @else
                window.tomSelectValues = window.tomSelectValues || {};
                window.tomSelectValues['{{ $uniqueKey }}'] = val;
                console.log('TomSelect stored value:', { key: '{{ $uniqueKey }}', value: window.tomSelectValues['{{ $uniqueKey }}'] });
            @endif
        },
        onItemRemove: (val) => {
            console.log('TomSelect onItemRemove:', { field: '{{ $field }}', removed: val });
            @if($isMultiple && !$immediateUpdate)
                window.tomSelectValues = window.tomSelectValues || {};
                window.tomSelectValues['{{ $uniqueKey }}'] = select.getValue();
                console.log('TomSelect updated value after remove:', { key: '{{ $uniqueKey }}', value: window.tomSelectValues['{{ $uniqueKey }}'] });
            @endif
        },
        onBlur: () => {
            @if(!$immediateUpdate)
                if (window.tomSelectValues && window.tomSelectValues['{{ $uniqueKey }}'] !== undefined) {
                    console.log('TomSelect onBlur:', { field: '{{ $field }}', value: window.tomSelectValues['{{ $uniqueKey }}'] });
                    @this.dispatch('tomselect-updated', { field: '{{ $field }}', value: window.tomSelectValues['{{ $uniqueKey }}'] });
                }
            @endif
        }
    });

    window.tomSelectInstances = window.tomSelectInstances || {};
    window.tomSelectInstances['{{ $uniqueKey }}'] = select;
">
    @if($label)
        <label class="form-label">{{ $label }}{!! $required ? " <span class='text-danger'>*</span>" : ''!!}</label>
    @endif
    <select {{ $required ? ' required ' : ''}} x-ref="select" {{ $isMultiple ? 'multiple' : '' }} {{ $disabled ? 'disabled' : '' }}></select>
</div>
@push('styles')
    <style>
        .ts-control .item .remove{
            opacity: 0;
            visibility: hidden;
            max-width: 0;
            overflow: hidden;
            padding-inline:0 !important;
        }
        .ts-control:has(input:focus) .item .remove {
            opacity: 1;
            visibility: visible;
            max-width: 100px;
            padding-inline:6px !important;
        }
        .ts-control {
            position: relative;
            padding-right: 30px;
            height: 37.6px;
        }
        .ts-control::after {
            content: '';
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            border: 6px solid transparent;
            border-top-color: #333;
            pointer-events: none;
        }
    </style>
@endpush