<div x-data="{ isOpen: false }">
    <button type="button" class="btn btn-success" @click="isOpen = true">
        <i class="fa fa-plus"></i>{{ translateText('Add Certificate', lang_admin()) }}
    </button>

    <div class="modal fade" :class="{ 'show d-block': isOpen }" x-show="isOpen"
         @click.away="isOpen = false" role="dialog" aria-modal="true">
        <div class="modal-dialog my-style-modal">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ translateText('Add New Certificate', lang_admin()) }}</h5>
                    <button type="button" class="btn-close" @click="isOpen = false"
                            aria-label="Close"></button>
                </div>

                <form wire:submit.prevent="save">
                    <div class="modal-body">
                        <div class="row">
                            <div wire:ignore class="col-md-6 mb-3">
                                <label>{{ translateText('Status', lang_admin()) }}</label>
                                <div class="form-check form-switch form-check-reverse "
                                     style="padding-left: 20px">
                                    <input wire:model="data.status"
                                           class="form-check-input badge-light-info ms-2"
                                           id="flexSwitchCheckReverse" type="checkbox">
                                    <label class="form-check-label"
                                           for="flexSwitchCheckReverse">
                                        {{ translateText('Will it be published?', lang_admin()) }}
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label>{{ translateText('Certificate Title', lang_admin()) }}
                                    <span class="text-danger">*</span></label>
                                <input class="form-control" wire:model="data.certificate_title"
                                       type="text">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label>{{ translateText('Certificate ID Number', lang_admin()) }}
                                    <span class="text-danger">*</span></label>
                                <input class="form-control"
                                       wire:model="data.certificate_id_number" type="text">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label>{{ translateText('Issued By', lang_admin()) }} <span
                                            class="text-danger">*</span></label>
                                <input class="form-control" wire:model="data.issued_by"
                                       type="text">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label>{{ translateText('Issued Date', lang_admin()) }} <span
                                            class="text-danger">*</span></label>
                                <input class="form-control" wire:model="data.issued_date"
                                       type="date">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label>{{ translateText('Expiry Date', lang_admin()) }}</label>
                                <input class="form-control" wire:model="data.expiry_date"
                                       type="date">
                            </div>

                            <div class="col-md-12 mb-3" wire:ignore>
                                <label>{{ translateText('Description', lang_admin()) }}</label>
                                <textarea x-data
                                          x-init="
                                                        let editor;
                                                        $nextTick(() => {
                                                            editor = CKEDITOR.replace($el, {
                                                                filebrowserImageBrowseUrl: '{{ url('filemanager?type=Images') }}',
                                                                filebrowserImageUploadUrl: '{{ url('filemanager/upload?type=Images&_token=') }}',
                                                                filebrowserBrowseUrl: '{{ url('filemanager?type=Files') }}',
                                                                filebrowserUploadUrl: '{{ url('filemanager/upload?type=Files&_token=') }}',
                                                                language: 'en',
                                                                contentsLangDirection: 'ltr',
                                                                autoUpdateElement: false
                                                            });
                                                            editor.on('blur', function() {
                                                                @this.set('data.certificate_description', editor.getData());
                                                            });
                                                            if (!window.__ckeditorHandlers) {
                                                                window.__ckeditorHandlers = [];
                                                            }
                                                            window.__ckeditorHandlers.push(() => {
                                                                @this.set('data.certificate_description', editor.getData());
                                                            });
                                                        });
                                                      "
                                          wire:model.defer="data.certificate_description"
                                          id="editor-en"></textarea>
                            </div>


                            <div class="col-md-4 mb-3">
                                <livewire:components.file-upload
                                        type="photo1"
                                        :isMultiple="false"
                                        :label="translateText('Photo1', lang_admin())"
                                        acceptedFormats="jpeg,jpg,png,webp"
                                        maxSize="1024"
                                        dimensions="1000x1000"
                                        modelClass="\App\Models\CompanyCertificate"
                                        uniqueKey="file-upload-photo1"
                                        wire:key="file-upload-photo1"
                                        uploadDisk="livewire_file"
                                        pathPrefix="assets/admin/uploads/company"/>
                            </div>

                            <div class="col-md-4 mb-3">
                                <livewire:components.file-upload
                                        type="photo2"
                                        :isMultiple="false"
                                        :label="translateText('Photo2', lang_admin())"
                                        acceptedFormats="jpeg,jpg,png,webp"
                                        maxSize="1024"
                                        dimensions="1000x1000"
                                        modelClass="\App\Models\CompanyCertificate"
                                        uniqueKey="file-upload-photo2"
                                        wire:key="file-upload-photo2"
                                        uploadDisk="livewire_file"
                                        pathPrefix="assets/admin/uploads/company"/>
                            </div>
                            <div class="col-md-4 mb-3">
                                <livewire:components.file-upload
                                        type="photo3"
                                        :isMultiple="false"
                                        :label="translateText('Photo3', lang_admin())"
                                        acceptedFormats="jpeg,jpg,png,webp"
                                        maxSize="1024"
                                        dimensions="1000x1000"
                                        modelClass="\App\Models\CompanyCertificate"
                                        uniqueKey="file-upload-photo3"
                                        wire:key="file-upload-photo3"
                                        uploadDisk="livewire_file"
                                        pathPrefix="assets/admin/uploads/company"/>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" @click="isOpen = false">
                            {{ translateText('Close', lang_admin()) }}
                        </button>
                        <button type="submit" class="btn btn-primary">
                            {{ translateText('Save', lang_admin()) }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal-backdrop fade" :class="{ 'show': isOpen }" x-show="isOpen"></div>
</div>