<div x-data="{ isOpen: false }">
    <button type="button" class="btn btn-success" @click="isOpen = true">
        <i class="fa fa-plus"></i>{{ translateText('Add Faq', lang_admin()) }}
    </button>

    <div class="modal fade" :class="{ 'show d-block': isOpen }" x-show="isOpen"
         @click.away="isOpen = false" role="dialog" aria-modal="true">
        <div class="modal-dialog mt-5 my-style-modal">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ translateText('Add New Faq', lang_admin()) }}</h5>
                    <button type="button" class="btn-close" @click="isOpen = false"
                            aria-label="Close"></button>
                </div>

                <form wire:submit.prevent="save">
                    <div class="modal-body">
                        <nav class="nav nav-tabs">
                            @foreach(tab_langs() as $lang)
                                <button class="nav-link {{ $lang->status == 'default' ? 'active' : '' }}"
                                        type="button"
                                        data-bs-toggle="tab"
                                        data-bs-target="#lang-{{ $lang->lang }}">
                                    {{ strtoupper($lang->lang) }}
                                </button>
                            @endforeach
                        </nav>

                        <div class="tab-content p-3 border border-top-0">
                            @foreach(tab_langs() as $lang)
                                @php
                                    $suffix = $lang->status == 'default' ? '' : '_' . $lang->lang;
                                    $dir = $lang->align;
                                @endphp
                                <div class="tab-pane fade {{ $lang->status == 'default' ? 'show active' : '' }}"
                                     id="lang-{{ $lang->lang }}" style="direction: {{ $dir }}">
                                    <div wire:ignore class="col-md-12 mb-3" style="direction:ltr">
                                        <label>{{ translateText('Status', lang_admin()) }}</label>
                                        <div class="form-check form-switch form-check-reverse"
                                             style="padding-left: 20px">
                                            <input wire:model="data.status{{ $suffix }}"
                                                   class="form-check-input badge-light-info ms-2"
                                                   id="flexSwitchCheckReverse{{ $suffix }}" type="checkbox">
                                            <label class="form-check-label"
                                                   for="flexSwitchCheckReverse{{ $suffix }}">
                                                {{ translateText('Will it be published?', lang_admin()) }}
                                            </label>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label>
                                            {{ translateText('Question', lang_admin()) }}
                                            {!! $lang->status == 'default' ? "<span class='text-danger'>*</span>" : '' !!}
                                        </label>
                                        <textarea {{ $lang->status == 'default' ? "required" : ''}}  type="text"
                                               wire:model="data.question{{ $suffix }}"
                                               class="form-control"></textarea>
                                    </div>
                                    <div class="mb-3">
                                        <label>
                                            {{ translateText('Answer', lang_admin()) }}
                                            {!! $lang->status == 'default' ? "<span class='text-danger'>*</span>" : '' !!}
                                        </label>
                                        <textarea {{ $lang->status == 'default' ? "required" : ''}}  type="text"
                                                  wire:model="data.answer{{ $suffix }}"
                                                  class="form-control"></textarea>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" @click="isOpen = false">
                            {{ translateText('Close', lang_admin()) }}
                        </button>
                        <button type="submit" class="btn btn-primary">
                            {{ translateText('Save', lang_admin()) }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal-backdrop fade" :class="{ 'show': isOpen }" x-show="isOpen"></div>
</div>