<div>
    <livewire:dashboard.page-title :page_title="$page_title"/>

    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h5>{{ $title }}</h5>
                    </div>
                    <div class="card-body">
                        <form enctype="multipart/form-data" x-data="{ isUploading: false }" wire:submit.prevent="save">
                            <div x-data class="row"
                                 x-on:livewire-upload-start="isUploading = true"
                                 x-on:livewire-upload-finish="isUploading = false"
                                 x-on:livewire-upload-error="isUploading = false">

                                <div class="col-md-6 mb-3">
                                    <label>{{ translateText('Factory Location', lang_admin()) }}</label>
                                    <input type="text"
                                           wire:model="data.factory_location"
                                           class="form-control">
                                </div>

                                <div class="col-md-6 mb-3" wire:ignore>
                                    <label>{{ translateText('Factory Total Area', lang_admin()) }}</label>
                                    <input type="text"
                                           wire:model.debounce.500ms="data.factory_total_area"
                                           class="form-control"
                                           placeholder="e.g. 2000 m² ~ 5000 m²"
                                           dir="ltr"
                                           x-maska="'#0000 m² ~ #0000 m²'"
                                           data-maska-tokens="0:[0-9]:optional">
                                </div>
                                <div x-data="{ slug: '' }" class="col-md-6 mb-3">
                                    <label>{{ translateText('Slug', lang_admin()) }}</label>
                                    <input type="text"
                                           x-model="slug"
                                           class="form-control"
                                           placeholder="e.g. my-page-slug"
                                           dir="ltr"
                                           v-maska
                                           data-maska="[a-z0-9-]*"
                                           data-maska-tokens="a:[a-z]|0:[0-9]"
                                           x-on:input="slug = slug.toLowerCase().replace(/[^a-z0-9-]/g, '').replace(/\s+/g, '-').replace(/-+/g, '-')">
                                    <div class="text-muted mt-2">
                                        پیش‌نمایش: <span x-text="slug"></span>
                                    </div>
                                </div>

                                <div class="col-md-6 mb-3" wire:ignore>
                                    <label>{{ translateText('Number of Production Staff', lang_admin()) }}</label>
                                    <input type="text"
                                           wire:model.debounce.500ms="data.no_production_staff"
                                           class="form-control"
                                           placeholder="e.g. 10 ~ 100 People"
                                           dir="ltr"
                                           x-maska="'#00 ~ #00 People'"
                                           data-maska-tokens="0:[0-9]:optional">
                                </div>

                                <!-- Number of QC Staff -->
                                <div class="col-md-6 mb-3" wire:ignore>
                                    <label>{{ translateText('Number of QC Staff', lang_admin()) }}</label>
                                    <input type="text"
                                           wire:model.debounce.500ms="data.no_qc_staff"
                                           class="form-control"
                                           placeholder="e.g. 10 ~ 100 People"
                                           dir="ltr"
                                           x-maska="'#00 ~ #00 People'"
                                           data-maska-tokens="0:[0-9]:optional">
                                </div>

                                <div class="col-md-6 mb-3" wire:ignore>
                                    <label>{{ translateText('Number of R&D Staff', lang_admin()) }}</label>
                                    <input type="text"
                                           wire:model.debounce.500ms="data.no_rd_staff"
                                           class="form-control"
                                           placeholder="e.g. 10 ~ 100 People"
                                           dir="ltr"
                                           x-maska="'#00 ~ #00 People'"
                                           data-maska-tokens="0:[0-9]:optional">
                                </div>

                                <div class="col-md-6 mb-3" wire:ignore>
                                    <label>{{ translateText('Annual Output', lang_admin()) }}</label>
                                    <input type="text"
                                           wire:model.debounce.500ms="data.annual_output"
                                           class="form-control"
                                           placeholder="e.g. 100000 KG"
                                           dir="ltr"
                                           x-maska="'#0000000 AAAAAAAAAA'"
                                           data-maska-tokens="0:[0-9]:optional|A:[A-Za-z0-9]"
                                           >
                                </div>
                                <div class="col-md-6 mb-3" wire:ignore>
                                    <label>{{ translateText('Average Lead Time', lang_admin()) }}</label>
                                    <input type="text"
                                           wire:model.debounce.500ms="data.average_lead_time"
                                           class="form-control"
                                           placeholder="e.g. 10 ~ 15 Days"
                                           dir="ltr"
                                           x-maska="'#00 ~ #00 Days'"
                                           data-maska-tokens="0:[0-9]:optional">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>{{ translateText('Number of Production Lines', lang_admin()) }}</label>
                                    <input type="number"
                                           wire:model="data.no_production_lines"
                                           class="form-control"
                                           min="0"
                                           max="100">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <livewire:components.file-upload
                                            type="video"
                                            :isMultiple="false"
                                            :label="translateText('Video', lang_admin())"
                                            acceptedFormats="mp4,mov"
                                            maxSize="10240"
                                            :modelId="$item->id"
                                            modelClass="\App\Models\FactoryInformation"
                                            :required="false"
                                            :data="$data['video']"
                                            uniqueKey="file-upload-video"
                                            wire:key="file-upload-video"
                                            uploadDisk="livewire_file"
                                            pathPrefix="assets/admin/uploads/company/factory"/>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>{{ translateText('YouTube Video URL', lang_admin()) }}</label>
                                    <input type="text"
                                           wire:model="data.video_url"
                                           class="form-control"
                                           placeholder="{{ translateText('e.g. https://www.youtube.com/...', lang_admin()) }}">
                                </div>

                                <div class="col-md-12 mb-3">
                                    <livewire:components.file-upload
                                            type="gallery"
                                            :isMultiple="true"
                                            :label="translateText('Gallery', lang_admin())"
                                            acceptedFormats="jpeg,jpg,png,webp"
                                            maxSize="5120"
                                            dimensions="1000x1000"
                                            :modelId="$item->id"
                                            modelClass="\App\Models\FactoryInformation"
                                            :required="false"
                                            :data="$data['gallery']"
                                            uniqueKey="file-upload-gallery"
                                            wire:key="file-upload-gallery"
                                            uploadDisk="livewire_file"
                                            pathPrefix="assets/admin/uploads/company/factory"
                                            :maxFiles="6"/>
                                </div>

                                <div class="col-md-12 text-left">
                                    <button x-show="!isUploading"
                                            wire:loading.attr="disabled"
                                            type="submit"
                                            class="btn btn-primary mt-3">
                                        {{ translateText('Submit', lang_admin()) }}
                                    </button>
                                    <span x-show="isUploading" class="text-info">
                                        {{ translateText('Uploading...', lang_admin()) }}
                                        <i class="fas fa-spinner fa-spin me-2"></i>
                                    </span>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
